/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.pem;

import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.modules.bpel.debugger.pem.ProcessExecutionModelImpl;

public abstract class PemEntityImpl
implements PemEntity {
    private final ProcessExecutionModelImpl myModel;
    private final PsmEntity myPsmEntity;
    private final String myBranchId;
    private final boolean myIsReceivingEvents;
    private PemEntity.State myState;
    private PemEntityImpl myParent;
    private int myIndex;
    private int myStartedChildrenCount;
    private int myLastStartedEventIndex;

    protected PemEntityImpl(ProcessExecutionModelImpl processExecutionModelImpl, PsmEntity psmEntity, String string, boolean bl) {
        this.myModel = processExecutionModelImpl;
        this.myBranchId = string;
        this.myPsmEntity = psmEntity;
        this.myIsReceivingEvents = bl;
        this.myState = PemEntity.State.UNKNOWN;
    }

    public ProcessExecutionModelImpl getModel() {
        return this.myModel;
    }

    public String getBranchId() {
        return this.myBranchId;
    }

    public PsmEntity getPsmEntity() {
        return this.myPsmEntity;
    }

    public PemEntity.State getState() {
        return this.myState;
    }

    public PemEntityImpl getParent() {
        return this.myParent;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public boolean isDescendantOf(PemEntity pemEntity) {
        PemEntityImpl pemEntityImpl;
        for (pemEntityImpl = this.getParent(); pemEntityImpl != null && pemEntityImpl != pemEntity; pemEntityImpl = pemEntityImpl.getParent()) {
        }
        return pemEntityImpl != null;
    }

    public boolean isInTree(PemEntity pemEntity) {
        return pemEntity == this || this.isDescendantOf(pemEntity);
    }

    public int getLastStartedEventIndex() {
        return this.myLastStartedEventIndex;
    }

    public abstract PemEntityImpl[] getChildren();

    public abstract PemEntityImpl[] getChildren(PsmEntity var1);

    protected void setState(PemEntity.State state) {
        if (this.myState == state) {
            return;
        }
        if (this.myParent != null) {
            this.myParent.onBeforeChildStateChanged(this, this.myState, state);
        }
        this.myState = state;
    }

    protected void onBeforeChildStateChanged(PemEntity pemEntity, PemEntity.State state, PemEntity.State state2) {
        if (this.myIsReceivingEvents) {
            if (this.getState() == PemEntity.State.UNKNOWN && state2 == PemEntity.State.STARTED) {
                this.setState(PemEntity.State.STARTED);
            }
            return;
        }
        if (state == PemEntity.State.STARTED) {
            --this.myStartedChildrenCount;
        } else if (state2 == PemEntity.State.STARTED) {
            ++this.myStartedChildrenCount;
        }
        if (this.myStartedChildrenCount > 0) {
            this.setState(PemEntity.State.STARTED);
        } else {
            this.setState(PemEntity.State.COMPLETED);
        }
    }

    protected abstract void addChild(PemEntityImpl var1);

    protected void setParent(PemEntityImpl pemEntityImpl) {
        this.myParent = pemEntityImpl;
    }

    protected void setIndex(int n) {
        this.myIndex = n;
    }

    protected void setLastStartedEventIndex(int n) {
        this.myLastStartedEventIndex = n;
        if (this.myParent != null) {
            this.myParent.setLastStartedEventIndex(n);
        }
    }
}

