/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.netbeans.modules.soa.mapper.basicmapper.MapperLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasController;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasView;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicAccumulatingMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperLinkFromLinkRequest;
import org.netbeans.modules.soa.mapper.common.IMapperLinkFromNodeRequest;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperView;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.dnd.IBasicDragController;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasGroupNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasLink;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseData;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasNode;

public class BasicCanvasController
extends AbstractCanvasController {
    private static final DataFlavor DROP_DATAFLAVOR = MapperUtilities.getJVMLocalObjectDataFlavor();
    private Logger LOGGER = Logger.getLogger(BasicCanvasController.class.getName());
    private Cursor mOriginalDragCursor;

    public boolean handleAddLink(ICanvasNode iCanvasNode, ICanvasNode iCanvasNode2) {
        if (!(iCanvasNode instanceof ICanvasFieldNode) || !(iCanvasNode2 instanceof ICanvasFieldNode)) {
            return false;
        }
        MapperLink mapperLink = new MapperLink(((ICanvasFieldNode)iCanvasNode).getFieldNode(), ((ICanvasFieldNode)iCanvasNode2).getFieldNode());
        this.requestNewLink(mapperLink);
        return true;
    }

    private boolean handleAddLink(final IMapperLink iMapperLink, final Point point, final Point point2, final int n) {
        IMapperLinkFromLinkRequest iMapperLinkFromLinkRequest = new IMapperLinkFromLinkRequest(){

            public IMapperLink getSourceLink() {
                return iMapperLink;
            }

            public Point getModelTargetLocation() {
                return point;
            }

            public Point getViewTargetLocation() {
                return point2;
            }

            public int getDropAction() {
                return n;
            }
        };
        this.requestNewLink(iMapperLinkFromLinkRequest);
        return true;
    }

    public boolean handleAddLink(final ICanvasNode iCanvasNode, final Point point, final Point point2, final int n) {
        IMapperLinkFromNodeRequest iMapperLinkFromNodeRequest = new IMapperLinkFromNodeRequest(){

            public IMapperNode getSourceNode() {
                return ((ICanvasFieldNode)iCanvasNode).getFieldNode();
            }

            public Point getModelTargetLocation() {
                return point;
            }

            public Point getViewTargetLocation() {
                return point2;
            }

            public int getDropAction() {
                return n;
            }
        };
        this.requestNewLink(iMapperLinkFromNodeRequest);
        return true;
    }

    public boolean handleAddLink(ICanvasNode iCanvasNode, ICanvasNode iCanvasNode2, boolean bl, boolean bl2) {
        return this.handleAddLink(iCanvasNode, iCanvasNode2);
    }

    public void handleDeleteNonGroupNodes() {
        Collection collection = this.getCanvas().getSelectedNodes();
        if (collection != null) {
            ArrayList arrayList = new ArrayList();
            for (Object e : collection) {
                if (e instanceof ICanvasGroupNode) continue;
                arrayList.add(e);
            }
            this.getCanvas().removeNodes(arrayList);
        }
    }

    public boolean handleDeleteSelection() {
        if (!((Component)((Object)this.getCanvas())).isEnabled() || !((Component)((Object)this.getCanvas())).isVisible()) {
            return false;
        }
        Collection collection = this.getCanvas().getSelectedNodes();
        Collection collection2 = this.getCanvas().getSelectedLinks();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            this.handleDeleteLink((ICanvasLink)iterator.next());
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.handleDeleteNode((ICanvasNode)iterator.next());
        }
        return true;
    }

    public boolean handleDragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.getView() instanceof IBasicMapperView && !((IBasicMapperView)this.getView()).isMapable()) {
            Toolkit.getDefaultToolkit().beep();
            return true;
        }
        this.LOGGER.finest("CanvasController handleDrop(): " + dropTargetDropEvent);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        try {
            if (transferable.isDataFlavorSupported(DROP_DATAFLAVOR)) {
                return this.handleDropObject(dropTargetDropEvent, transferable.getTransferData(DROP_DATAFLAVOR));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace(System.err);
        }
        return false;
    }

    public boolean handleMouseClick(ICanvasMouseData iCanvasMouseData) {
        if (!((Component)((Object)this.getCanvas())).isEnabled() || !((Component)((Object)this.getCanvas())).isVisible()) {
            return false;
        }
        Point point = iCanvasMouseData.getModelLocation();
        JGoObject jGoObject = ((JGoView)this.getCanvas()).pickDocObject(point, true);
        if (jGoObject != null && jGoObject instanceof BasicCanvasMethoidNode && ((BasicCanvasMethoidNode)jGoObject).isInButton(point)) {
            BasicCanvasMethoidNode basicCanvasMethoidNode = (BasicCanvasMethoidNode)jGoObject;
            if (basicCanvasMethoidNode.isExpanded()) {
                basicCanvasMethoidNode.collapse();
            } else {
                basicCanvasMethoidNode.expand();
            }
            return true;
        }
        this.getCanvas().doDefaultMouseClick(iCanvasMouseData);
        return false;
    }

    public boolean handleMouseDblClick(ICanvasMouseData iCanvasMouseData) {
        if (!((Component)((Object)this.getCanvas())).isEnabled() || !((Component)((Object)this.getCanvas())).isVisible()) {
            return false;
        }
        this.getCanvas().doDefaultMouseDblClick(iCanvasMouseData);
        return false;
    }

    public boolean handleMouseDown(ICanvasMouseData iCanvasMouseData) {
        if (!((Component)((Object)this.getCanvas())).isEnabled() || !((Component)((Object)this.getCanvas())).isVisible()) {
            return false;
        }
        this.getCanvas().doDefaultMouseDown(iCanvasMouseData);
        return false;
    }

    public boolean handleMouseMove(ICanvasMouseData iCanvasMouseData) {
        if (!((Component)((Object)this.getCanvas())).isEnabled() || !((Component)((Object)this.getCanvas())).isVisible()) {
            return false;
        }
        this.getCanvas().doDefaultMouseMove(iCanvasMouseData);
        return false;
    }

    public boolean handleMouseUp(ICanvasMouseData iCanvasMouseData) {
        if (!((Component)((Object)this.getCanvas())).isEnabled() || !((Component)((Object)this.getCanvas())).isVisible()) {
            return false;
        }
        this.getCanvas().doDefaultMouseUp(iCanvasMouseData);
        return false;
    }

    protected void handleDeleteLink(ICanvasLink iCanvasLink) {
        if (iCanvasLink instanceof ICanvasMapperLink) {
            this.requestRemoveLink(((ICanvasMapperLink)iCanvasLink).getMapperLink());
        }
    }

    protected void handleDeleteNode(ICanvasNode iCanvasNode) {
        if (iCanvasNode instanceof ICanvasMethoidNode) {
            this.requestRemoveNode(((ICanvasMethoidNode)iCanvasNode).getMethoidNode());
        }
    }

    protected boolean handleDropObject(DropTargetDropEvent dropTargetDropEvent, Object object) {
        this.LOGGER.finest("CanvasController transferData.class=" + object.getClass().getName());
        if (object instanceof IMapperLink) {
            return this.handleNewLinkDrop(dropTargetDropEvent, (IMapperLink)object);
        }
        if (object instanceof IMethoid) {
            return this.handleNewMethoidDrop(dropTargetDropEvent, (IMethoid)object);
        }
        return false;
    }

    protected boolean handleNewMethoidDrop(DropTargetDropEvent dropTargetDropEvent, IMethoid iMethoid) {
        BasicMethoidNode basicMethoidNode = null;
        basicMethoidNode = iMethoid.isAccumulative() ? new BasicAccumulatingMethoidNode(iMethoid) : new BasicMethoidNode(iMethoid);
        Point point = dropTargetDropEvent.getLocation();
        ((JGoView)this.getCanvas()).convertViewToDoc(point);
        basicMethoidNode.setX(point.x);
        basicMethoidNode.setY(point.y);
        this.requestNewNode(basicMethoidNode);
        return true;
    }

    protected boolean handleNewLinkDrop(DropTargetDropEvent dropTargetDropEvent, IMapperLink iMapperLink) {
        JGoView jGoView = (JGoView)this.getCanvas();
        Point point = dropTargetDropEvent.getLocation();
        Point point2 = new Point(point);
        jGoView.convertViewToDoc(point2);
        BasicCanvasView basicCanvasView = (BasicCanvasView)this.getCanvas();
        if (basicCanvasView.getPortObjectInModel(point2, false) == null) {
            this.handleAddLink(iMapperLink, point2, point, dropTargetDropEvent.getDropAction());
            return false;
        }
        return basicCanvasView.connectLinkByPoint(point2, iMapperLink);
    }

    public void handleDragEnter(DropTargetDragEvent dropTargetDragEvent) {
        IBasicDragController iBasicDragController = this.getMapperDragController();
        Object object = iBasicDragController.getTransferObject();
        if (object instanceof IMapperLink) {
            Object object2;
            IMapperLink iMapperLink = (IMapperLink)object;
            IMapperNode iMapperNode = null;
            if (iMapperLink.getStartNode() != null) {
                iMapperNode = iMapperLink.getStartNode();
            }
            if (iMapperLink.getEndNode() != null) {
                iMapperNode = iMapperLink.getEndNode();
            }
            if (iMapperNode != null && iMapperNode instanceof IMapperTreeNode) {
                object2 = new MapperLink();
                IMapperNode iMapperNode2 = (IMapperNode)iMapperNode.clone();
                object2.setStartNode(iMapperLink.getStartNode() != null ? iMapperNode2 : null);
                object2.setEndNode(iMapperLink.getEndNode() != null ? iMapperNode2 : null);
                if (!MapperUtilities.isLinkAlreadyConnected(iMapperLink, iMapperNode)) {
                    iMapperNode2.addLink((IMapperLink)object2);
                    this.getViewModel().addNode(iMapperNode2);
                    iBasicDragController.setOriginatingDragNode(iMapperNode2);
                }
            }
            if ((object2 = iBasicDragController.getLinkDragSourceContext()) != null) {
                this.mOriginalDragCursor = ((DragSourceContext)object2).getCursor();
                ((DragSourceContext)object2).setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    public void handleDragExit(DropTargetEvent dropTargetEvent) {
        IBasicDragController iBasicDragController = this.getMapperDragController();
        if (iBasicDragController.getTransferObject() instanceof IMapperLink) {
            IMapperNode iMapperNode = iBasicDragController.getOriginatingDragNode();
            if (iMapperNode != null) {
                this.getViewModel().removeNode(iMapperNode);
            }
            iBasicDragController.resetDragLinkEndLocation();
            iBasicDragController.getLinkDragSourceContext().setCursor(this.mOriginalDragCursor);
            this.mOriginalDragCursor = null;
        }
    }

    public boolean handleDragOver(DropTargetDragEvent dropTargetDragEvent) {
        IBasicDragController iBasicDragController = this.getMapperDragController();
        if (iBasicDragController.getTransferObject() instanceof IMapperLink) {
            iBasicDragController.setDragLinkEndLocation(dropTargetDragEvent.getLocation());
        }
        return true;
    }

    public void handleDragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.getMapperDragController().setTransferObject(this);
    }
}

