/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasFieldNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasPort;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.DrawPort;
import org.netbeans.modules.soa.mapper.common.IMapperGroupNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasGroupNode;

public class BasicCanvasFieldNode
extends AbstractCanvasFieldNode {
    private static final Color TEXT_COLOR_RESULT = Color.WHITE;
    private static final Color TEXT_COLOR_INPUT = Color.BLACK;
    private static final Color TEXT_COLOR_LITERAL = new Color(30, 70, 230);
    private static final JGoPen BORDER_INPUT_REGULAR = JGoPen.makeStockPen((Color)new Color(186, 205, 240));
    private static final JGoPen BORDER_OUTPUT_REGULAR = JGoPen.makeStockPen((Color)new Color(116, 140, 192));
    private static final JGoPen BORDER_HOVER = JGoPen.make((int)65535, (int)1, (Color)new Color(0, 24, 127));
    private static final JGoBrush BRUSH_LITERAL = JGoBrush.makeStockBrush((Color)Color.WHITE);
    private static final JGoBrush BRUSH_REGULAR = JGoBrush.makeStockBrush((Color)new Color(255, 255, 255, 0));
    private static final JGoBrush BRUSH_RESULT = JGoBrush.makeStockBrush((Color)new Color(116, 140, 192));
    private DrawPort mInPort;
    private DrawPort mOutPort;
    private BasicCanvasPort mPort;
    private String mCurrentTextStyle = "";
    private boolean mIsResultField;
    private boolean mIsLiteral;

    public BasicCanvasFieldNode(IFieldNode iFieldNode) {
        super(iFieldNode);
        IMethoid iMethoid;
        IMethoidNode iMethoidNode;
        iFieldNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("FieldNode.Name".equals(string)) {
                    BasicCanvasFieldNode.this.updateLabel((String)propertyChangeEvent.getNewValue());
                } else if ("FieldNode.ObjectChanged".equals(string)) {
                    BasicCanvasFieldNode.this.updateLabel(BasicCanvasFieldNode.this.mFieldNode.getName());
                } else if ("FieldNode.Style".equals(string)) {
                    BasicCanvasFieldNode.this.updateLabelStyle((String)propertyChangeEvent.getNewValue());
                } else if ("MNode.AddLink".equals(string)) {
                    BasicCanvasFieldNode.this.setPortStyleVacant(false);
                } else if ("MNode.RemoveLink".equals(string)) {
                    BasicCanvasFieldNode.this.setPortStyleVacant(true);
                }
            }
        });
        this.mPort = new BasicCanvasPort();
        this.mPort.setStyle(1);
        this.mPort.setValidDestination(false);
        this.mPort.setValidSource(false);
        this.mPort.setSelectable(false);
        this.mPort.setDraggable(true);
        this.mIsResultField = iFieldNode.isOutput();
        IMapperGroupNode iMapperGroupNode = iFieldNode.getGroupNode();
        if (iMapperGroupNode instanceof IMethoidNode && (iMethoidNode = (IMethoidNode)iMapperGroupNode).getMethoidObject() instanceof IMethoid && (iMethoid = (IMethoid)iMethoidNode.getMethoidObject()).isLiteral()) {
            this.mIsResultField = false;
            this.mIsLiteral = true;
        }
        if (iFieldNode.isInput()) {
            this.mInPort = this.makePort();
            this.mPort.setValidDestination(true);
        }
        if (iFieldNode.isOutput()) {
            this.mOutPort = this.makePort();
            this.mPort.setValidSource(true);
        }
        this.mPort.setPortObject((JGoObject)this.getDrawPort());
        this.layoutPorts();
        this.setHorizonalAligment(1);
        if (this.mIsResultField) {
            this.setBrush(BRUSH_RESULT);
        } else if (this.mIsLiteral) {
            this.setBrush(BRUSH_LITERAL);
        } else {
            this.setBrush(BRUSH_REGULAR);
        }
        this.mCurrentTextStyle = "normal";
        this.setTextColorFromStyle(this.mCurrentTextStyle);
    }

    private DrawPort makePort() {
        DrawPort drawPort = new DrawPort(this);
        drawPort.setDraggable(false);
        drawPort.setSelectable(false);
        drawPort.setResizable(false);
        return drawPort;
    }

    public Object getConnectPointObject() {
        return this.mPort;
    }

    public DrawPort getDrawPort() {
        if (this.mInPort != null) {
            return this.mInPort;
        }
        if (this.mOutPort != null) {
            return this.mOutPort;
        }
        return null;
    }

    public void setMapperCanvas(ICanvasView iCanvasView) {
        super.setMapperCanvas(iCanvasView);
        if (this.mInPort != null) {
            this.setPen(BORDER_INPUT_REGULAR);
        }
        if (this.mOutPort != null) {
            this.setPen(BORDER_OUTPUT_REGULAR);
        }
    }

    public void setIsHovering(boolean bl) {
        if (this.mInPort != null) {
            this.setPen(bl ? BORDER_HOVER : BORDER_INPUT_REGULAR);
        }
    }

    public void layoutPorts() {
        int n;
        Dimension dimension;
        Point point = null;
        if (this.mOutPort != null) {
            point = this.getSpotLocation(4);
            dimension = this.mPort.getDrawSize();
            n = 3;
            this.mOutPort.setDrawLocation(point.x + n, point.y - dimension.height / 2);
            this.mPort.setBoundingRect(this.getLeft(), this.getTop(), this.getWidth() + dimension.width + n, this.getHeight());
        }
        if (this.mInPort != null) {
            point = this.getSpotLocation(8);
            dimension = this.mPort.getDrawSize();
            n = dimension.width + 2;
            this.mInPort.setDrawLocation(point.x - n, point.y - dimension.height / 2);
            this.mPort.setBoundingRect(this.getLeft() - n, this.getTop(), this.getWidth() + n, this.getHeight());
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.mPort.setVisible(bl);
    }

    private void updateLabelStyle(String string) {
        if (this.mCurrentTextStyle.equals(string)) {
            return;
        }
        if (!"normal".equals(string) && !"literal".equals(string)) {
            throw new IllegalArgumentException("Style " + string + " not supported.");
        }
        this.mCurrentTextStyle = string;
        this.setTextColorFromStyle(string);
        this.setPortStyleVacant("normal".equals(string));
        this.ensureContainerSize();
    }

    public void updateLabel(String string) {
        super.updateLabel(string);
        this.ensureContainerSize();
    }

    private void ensureContainerSize() {
        ICanvasGroupNode iCanvasGroupNode = this.getContainer();
        if (iCanvasGroupNode != null && iCanvasGroupNode instanceof BasicCanvasMethoidNode) {
            ((BasicCanvasMethoidNode)iCanvasGroupNode).ensureBounding();
        }
    }

    public void setHighlight(boolean bl) {
        DrawPort drawPort = this.getDrawPort();
        if (drawPort != null) {
            drawPort.setIsActivated(bl);
        }
    }

    private void setTextColorFromStyle(String string) {
        if (this.mIsResultField) {
            this.setTextColor(TEXT_COLOR_RESULT);
        } else if (string.equals("normal")) {
            this.setTextColor(TEXT_COLOR_INPUT);
        } else if (string.equals("literal")) {
            this.setTextColor(TEXT_COLOR_LITERAL);
        }
    }

    private void setPortStyleVacant(boolean bl) {
        DrawPort drawPort = this.getDrawPort();
        if (drawPort != null) {
            drawPort.setIsConnected(!bl);
        }
    }
}

