/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.mapper.basicmapper.MapperLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasView;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasFieldNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasMouseData;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasObjectFactory;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasPort;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicTitleBarUI;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.DrawPort;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.PortSelection;
import org.netbeans.modules.soa.mapper.common.IMapperGroupNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.IMapperViewController;
import org.netbeans.modules.soa.mapper.common.IMapperViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.IMapperCanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasNodeToNodeLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasNodeToTreeLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasObjectFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasTreeToNodeLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasTreeToTreeLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasGroupNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasLink;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseData;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseListener;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasNode;

public class BasicCanvasView
extends AbstractCanvasView {
    static final int MOUSE_CLICK = 1;
    static final int MOUSE_DBLCLICK = 2;
    static final int MOUSE_PRESS = 3;
    static final int MOUSE_RELEASE = 4;
    static final int MOUSE_MOVE = 5;
    private Logger mLogger = Logger.getLogger(BasicCanvasView.class.getName());
    private PropertyChangeListener mViewModelListener = new ViewModelChangeListener();
    private List mFilterTreeNodeLink = new Vector();
    private List mFilterNodeLinks = new Vector();
    private Map mLayerModelMap;
    private PropertyChangeListener mNodeLinkListener;
    private PropertyChangeListener mGroupNodeListener;
    private ICanvasObjectFactory mObjectFactory;
    private JGoLayer mSelectedLayer;
    private Cursor mDefaultCursor = Cursor.getDefaultCursor();
    private Cursor mLinkCursor = Cursor.getPredefinedCursor(12);
    private Cursor mMoveCursor = Cursor.getPredefinedCursor(13);
    private List mNewLinkList;
    private HoverPort mCurrentTargetHoverPort;
    private HoverPort mCurrentSourceHoverPort;
    private Point mDropLocation;
    private int mDropAction;
    private Set mMouseListeners = new HashSet();

    public BasicCanvasView(IMapperCanvasView iMapperCanvasView) {
        super(iMapperCanvasView);
        this.setHidingDisabledScrollbars(true);
        this.setDocument(new JGoDocument());
        this.addComponentListener(new CanvasSizeListener());
        this.mNodeLinkListener = new NodeLinkListener(this);
        this.mGroupNodeListener = new GroupNodeListener();
        this.mLayerModelMap = new Hashtable();
        BasicCanvasView.setDefaultPrimarySelectionColor((Color)ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR);
        this.mObjectFactory = new BasicCanvasObjectFactory();
        this.mObjectFactory.setMapperCanvas(this);
        this.mNewLinkList = new Vector();
        BasicCanvasView.setDefaultPortGravity((int)20);
    }

    public ICanvasLink getCanvasLinkByDataObject(Object object) {
        if (!(object instanceof IMapperLink)) {
            return null;
        }
        IMapperLink iMapperLink = (IMapperLink)object;
        JGoDocument jGoDocument = this.getDocument();
        JGoListPosition jGoListPosition = jGoDocument.getFirstObjectPos();
        JGoObject jGoObject = null;
        while (jGoListPosition != null) {
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof ICanvasMapperLink && ((ICanvasMapperLink)jGoObject).getMapperLink() == iMapperLink) {
                return (ICanvasLink)jGoObject;
            }
            jGoListPosition = jGoDocument.getNextObjectPos(jGoListPosition);
        }
        return null;
    }

    public ICanvasNode getCanvasNodeByDataObject(Object object) {
        if (object instanceof IFieldNode) {
            return this.findCanvasFieldNode((IFieldNode)object);
        }
        if (object instanceof IMethoidNode) {
            return this.findCanvasMethoidNode((IMethoidNode)object);
        }
        return null;
    }

    public ICanvasObjectFactory getCanvasObjectFactory() {
        return this.mObjectFactory;
    }

    public List getNodes() {
        ArrayList<JGoObject> arrayList = new ArrayList<JGoObject>();
        if (this.mSelectedLayer == null) {
            return arrayList;
        }
        JGoListPosition jGoListPosition = this.mSelectedLayer.getFirstObjectPos();
        while (jGoListPosition != null) {
            arrayList.add(this.mSelectedLayer.getObjectAtPos(jGoListPosition));
            jGoListPosition = this.mSelectedLayer.getNextObjectPos(jGoListPosition);
        }
        return arrayList;
    }

    public Object getObjectInModel(Point point, boolean bl) {
        return this.mSelectedLayer.pickObject(point, bl);
    }

    public Object getPortObjectInModel(Point point, boolean bl) {
        JGoPort jGoPort = this.pickNearestPort(point);
        if (jGoPort != null) {
            return jGoPort;
        }
        return this.mSelectedLayer.pickObject(point, bl);
    }

    public Collection getSelectedLinks() {
        ArrayList<JGoObject> arrayList = new ArrayList<JGoObject>();
        JGoSelection jGoSelection = this.getSelection();
        if (jGoSelection == null) {
            return arrayList;
        }
        JGoObject jGoObject = null;
        JGoListPosition jGoListPosition = jGoSelection.getFirstObjectPos();
        while (jGoListPosition != null) {
            jGoObject = jGoSelection.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof ICanvasLink) {
                arrayList.add(jGoObject);
            }
            jGoListPosition = jGoSelection.getNextObjectPos(jGoListPosition);
        }
        return arrayList;
    }

    public Collection getSelectedNodes() {
        ArrayList<JGoObject> arrayList = new ArrayList<JGoObject>();
        JGoSelection jGoSelection = this.getSelection();
        if (jGoSelection == null) {
            return arrayList;
        }
        JGoObject jGoObject = null;
        JGoListPosition jGoListPosition = jGoSelection.getFirstObjectPos();
        while (jGoListPosition != null) {
            jGoObject = jGoSelection.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof ICanvasNode) {
                arrayList.add(jGoObject);
            }
            jGoListPosition = jGoSelection.getNextObjectPos(jGoListPosition);
        }
        return arrayList;
    }

    public Component getUIComponent() {
        return this;
    }

    public boolean isNodeExisit(ICanvasNode iCanvasNode) {
        JGoListPosition jGoListPosition = this.getDocument().findObject((JGoObject)iCanvasNode);
        if (jGoListPosition == null) {
            return false;
        }
        if (!this.allContainersExpanded(iCanvasNode)) {
            return false;
        }
        return ((JGoObject)iCanvasNode).isVisible();
    }

    public void setCanvasObjectFactory(ICanvasObjectFactory iCanvasObjectFactory) {
        this.mObjectFactory = iCanvasObjectFactory;
    }

    public void setViewModel(IMapperViewModel iMapperViewModel) {
        IMapperViewModel iMapperViewModel2 = this.getParentView().getViewModel();
        this.clearSelection();
        if (iMapperViewModel2 != null) {
            iMapperViewModel2.removePropertyChangeListener(this.mViewModelListener);
        }
        if (iMapperViewModel != null) {
            iMapperViewModel.addPropertyChangeListener(this.mViewModelListener);
            if (this.mLayerModelMap.containsKey(iMapperViewModel)) {
                this.mSelectedLayer.setVisible(false);
                this.mSelectedLayer = (JGoLayer)this.mLayerModelMap.get(iMapperViewModel);
                this.mSelectedLayer.setVisible(true);
                this.getDocument().setDefaultLayer(this.mSelectedLayer);
            } else {
                if (this.mSelectedLayer == null) {
                    this.mSelectedLayer = this.getDocument().getDefaultLayer();
                } else {
                    this.mSelectedLayer.setVisible(false);
                    this.mSelectedLayer = this.getDocument().addLayerBefore(this.mSelectedLayer);
                }
                this.getDocument().setDefaultLayer(this.mSelectedLayer);
                this.mSelectedLayer.setVisible(true);
                this.mLayerModelMap.put(iMapperViewModel, this.mSelectedLayer);
                this.initializeCanvasNode(iMapperViewModel);
            }
        }
    }

    public void addLink(ICanvasLink iCanvasLink) {
        if (this.mSelectedLayer == null) {
            this.mSelectedLayer = this.getDocument().getDefaultLayer();
        }
        this.mSelectedLayer.addObjectAtHead((JGoObject)iCanvasLink);
        if (iCanvasLink instanceof ICanvasNodeToTreeLink || iCanvasLink instanceof ICanvasTreeToNodeLink || iCanvasLink instanceof ICanvasTreeToTreeLink) {
            this.mFilterTreeNodeLink.add(iCanvasLink);
        }
        if (iCanvasLink instanceof ICanvasNodeToNodeLink) {
            this.mFilterNodeLinks.add(iCanvasLink);
        }
    }

    public void addNode(ICanvasNode iCanvasNode) {
        if (this.mSelectedLayer == null) {
            this.mSelectedLayer = this.getDocument().getDefaultLayer();
        }
        this.clearSelection();
        this.mSelectedLayer.addObjectAtTail((JGoObject)iCanvasNode);
    }

    public boolean allContainersExpanded(ICanvasNode iCanvasNode) {
        ICanvasGroupNode iCanvasGroupNode = iCanvasNode.getContainer();
        if (iCanvasGroupNode == null) {
            return true;
        }
        return iCanvasGroupNode.isExpanded() && this.allContainersExpanded(iCanvasGroupNode);
    }

    public void clearSelection() {
        this.getSelection().clearSelection();
    }

    public void collapseAllNode() {
        JGoListPosition jGoListPosition = this.mSelectedLayer.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.mSelectedLayer.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof BasicCanvasMethoidNode) {
                ((BasicCanvasMethoidNode)jGoObject).collapse();
            }
            jGoListPosition = this.mSelectedLayer.getNextObjectPos(jGoListPosition);
        }
    }

    public boolean connectLinkByDrag(IMapperLink iMapperLink) {
        Point point = this.getDnDDragOrginPoint();
        this.convertViewToDoc(point);
        return this.connectLinkByPoint(point, iMapperLink);
    }

    public boolean connectLinkByPoint(Point point, IMapperLink iMapperLink) {
        JGoLayer jGoLayer = this.mSelectedLayer;
        JGoObject jGoObject = (JGoObject)this.getPortObjectInModel(point, false);
        ICanvasFieldNode iCanvasFieldNode = null;
        if (jGoObject instanceof JGoPort) {
            iCanvasFieldNode = this.findCanvasFieldNodeByConnectionObject(jGoLayer, jGoObject);
            if (iCanvasFieldNode == null) {
                return false;
            }
        } else {
            return false;
        }
        IFieldNode iFieldNode = iCanvasFieldNode.getFieldNode();
        IMapperNode iMapperNode = iMapperLink.getStartNode() == null ? iMapperLink.getEndNode() : iMapperLink.getStartNode();
        boolean bl = false;
        if (iMapperNode instanceof IMapperTreeNode) {
            bl = ((IMapperTreeNode)iMapperNode).isSourceTreeNode();
        } else if (iMapperNode instanceof IFieldNode) {
            bl = ((IFieldNode)iMapperNode).isOutput();
        } else {
            throw new Error("This shouldn't have happened...");
        }
        if (bl ? !iFieldNode.isInput() : !iFieldNode.isOutput()) {
            return false;
        }
        if (iMapperLink.getStartNode() == null) {
            ((MapperLink)iMapperLink).setStartNode(iFieldNode);
        } else {
            ((MapperLink)iMapperLink).setEndNode(iFieldNode);
        }
        ((IMapperViewController)((Object)this.getCanvasController())).requestNewLink(iMapperLink);
        return true;
    }

    private ICanvasFieldNode findCanvasFieldNodeByConnectionObject(JGoLayer jGoLayer, Object object) {
        JGoObject jGoObject;
        Object var3_3 = null;
        Object var4_4 = null;
        ICanvasMethoidNode iCanvasMethoidNode = null;
        ICanvasFieldNode iCanvasFieldNode = null;
        JGoListPosition jGoListPosition = jGoLayer.getFirstObjectPos();
        while (!(jGoListPosition == null || (jGoObject = jGoLayer.getObjectAtPos(jGoListPosition)) instanceof ICanvasMethoidNode && (iCanvasFieldNode = (iCanvasMethoidNode = (ICanvasMethoidNode)jGoObject).getFieldNodeByConnectPointObject(object)) != null)) {
            jGoListPosition = jGoLayer.getNextObjectPos(jGoListPosition);
        }
        return iCanvasFieldNode;
    }

    public void deleteSelection() {
        if (this.getCanvasController() != null) {
            this.getCanvasController().handleDeleteSelection();
        } else {
            this.doDefaultDeleteSelection();
        }
    }

    public boolean doDefaultDeleteSelection() {
        super.deleteSelection();
        return true;
    }

    public void doUncapturedMouseMove(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, true);
        Cursor cursor = this.mDefaultCursor;
        this.markCurrentHoverPort(point, false);
        if (jGoObject instanceof BasicCanvasMethoidNode) {
            BasicCanvasMethoidNode basicCanvasMethoidNode = (BasicCanvasMethoidNode)jGoObject;
            if (!basicCanvasMethoidNode.isExpanded()) {
                if (!basicCanvasMethoidNode.isInButton(point2)) {
                    cursor = this.mMoveCursor;
                }
            } else {
                JGoListPosition jGoListPosition = basicCanvasMethoidNode.getFirstObjectPos();
                while (jGoListPosition != null) {
                    JGoObject jGoObject2 = basicCanvasMethoidNode.getObjectAtPos(jGoListPosition);
                    if (jGoObject2.getBoundingRect().contains(point)) {
                        if (jGoObject2 instanceof BasicTitleBarUI) {
                            if (((BasicTitleBarUI)jGoObject2).isInButton(point2)) break;
                            cursor = this.mMoveCursor;
                            break;
                        }
                        if (jGoObject2 instanceof JGoPort) {
                            cursor = this.mLinkCursor;
                            break;
                        }
                    }
                    jGoListPosition = basicCanvasMethoidNode.getNextObjectPos(jGoListPosition);
                }
            }
        }
        this.setCursor(cursor);
    }

    public JGoLink createTemporaryLinkForNewLink(JGoPort jGoPort, JGoPort jGoPort2) {
        JGoLink jGoLink = super.createTemporaryLinkForNewLink(jGoPort, jGoPort2);
        jGoLink.setPen(JGoPen.make((int)65535, (int)1, (Color)ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR));
        jGoLink.setBrush(JGoBrush.makeStockBrush((Color)ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR));
        if (jGoPort instanceof BasicCanvasPort) {
            this.mCurrentSourceHoverPort = new HoverPort(((BasicCanvasPort)jGoPort).getDrawPort());
            this.mCurrentSourceHoverPort.set(true);
        } else if (jGoPort2 instanceof BasicCanvasPort) {
            this.mCurrentSourceHoverPort = new HoverPort(((BasicCanvasPort)jGoPort2).getDrawPort());
            this.mCurrentSourceHoverPort.set(true);
        }
        return jGoLink;
    }

    public void removeRawLink(ICanvasLink iCanvasLink) {
        super.removeRawLink(iCanvasLink);
        if (this.mCurrentSourceHoverPort != null) {
            this.mCurrentSourceHoverPort.unset();
            this.mCurrentSourceHoverPort = null;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        this.markCurrentHoverPort(dropTargetDragEvent.getLocation(), true);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        super.dragOver(dragSourceDragEvent);
        Point point = dragSourceDragEvent.getLocation();
        Point point2 = this.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
        this.markCurrentHoverPort(point, true);
    }

    private void markCurrentHoverPort(Point point, boolean bl) {
        Object object;
        BasicCanvasMethoidNode basicCanvasMethoidNode;
        JGoObject jGoObject;
        if (this.mCurrentTargetHoverPort != null) {
            this.mCurrentTargetHoverPort.unset();
        }
        if (this.mCurrentSourceHoverPort != null) {
            this.mCurrentSourceHoverPort.set(true);
        }
        if ((jGoObject = this.pickDocObject(point, true)) instanceof BasicCanvasMethoidNode && (basicCanvasMethoidNode = (BasicCanvasMethoidNode)jGoObject).isExpanded()) {
            object = basicCanvasMethoidNode.getFirstObjectPos();
            while (object != null) {
                BasicCanvasFieldNode basicCanvasFieldNode;
                JGoObject jGoObject2 = basicCanvasMethoidNode.getObjectAtPos((JGoListPosition)object);
                if (jGoObject2.getBoundingRect().contains(point) && jGoObject2 instanceof BasicCanvasFieldNode && (basicCanvasFieldNode = (BasicCanvasFieldNode)jGoObject2).getDrawPort() != null) {
                    this.mCurrentTargetHoverPort = new HoverPort(basicCanvasFieldNode);
                    this.mCurrentTargetHoverPort.set(bl);
                    return;
                }
                object = basicCanvasMethoidNode.getNextObjectPos((JGoListPosition)object);
            }
        }
        if ((basicCanvasMethoidNode = this.pickNearestPort(point)) instanceof BasicCanvasPort && ((BasicCanvasPort)((Object)(object = (BasicCanvasPort)((Object)basicCanvasMethoidNode)))).getDrawPort() != null) {
            this.mCurrentTargetHoverPort = new HoverPort(((BasicCanvasPort)((Object)object)).getDrawPort());
            this.mCurrentTargetHoverPort.set(bl);
        }
    }

    public boolean doDefaultMouseClick(ICanvasMouseData iCanvasMouseData) {
        if (this.fireMouseEvent(1, iCanvasMouseData)) {
            return true;
        }
        return this.doDefaultMouseClick(iCanvasMouseData.getMouseModifier(), iCanvasMouseData.getModelLocation(), iCanvasMouseData.getViewLocation());
    }

    public boolean doDefaultMouseClick(int n, Point point, Point point2) {
        return super.doMouseClick(n, point, point2);
    }

    public boolean doDefaultMouseDblClick(ICanvasMouseData iCanvasMouseData) {
        if (this.fireMouseEvent(2, iCanvasMouseData)) {
            return true;
        }
        return this.doDefaultMouseDblClick(iCanvasMouseData.getMouseModifier(), iCanvasMouseData.getModelLocation(), iCanvasMouseData.getViewLocation());
    }

    public boolean doDefaultMouseDblClick(int n, Point point, Point point2) {
        return super.doMouseDblClick(n, point, point2);
    }

    public boolean doDefaultMouseDown(ICanvasMouseData iCanvasMouseData) {
        if (this.fireMouseEvent(3, iCanvasMouseData)) {
            return true;
        }
        return this.doDefaultMouseDown(iCanvasMouseData.getMouseModifier(), iCanvasMouseData.getModelLocation(), iCanvasMouseData.getViewLocation());
    }

    public boolean doDefaultMouseDown(int n, Point point, Point point2) {
        return super.doMouseDown(n, point, point2);
    }

    public boolean doDefaultMouseMove(ICanvasMouseData iCanvasMouseData) {
        if (this.fireMouseEvent(5, iCanvasMouseData)) {
            return true;
        }
        return this.doDefaultMouseMove(iCanvasMouseData.getMouseModifier(), iCanvasMouseData.getModelLocation(), iCanvasMouseData.getViewLocation());
    }

    public boolean doDefaultMouseMove(int n, Point point, Point point2) {
        return super.doMouseMove(n, point, point2);
    }

    public boolean doDefaultMouseUp(ICanvasMouseData iCanvasMouseData) {
        if (this.fireMouseEvent(4, iCanvasMouseData)) {
            return true;
        }
        boolean bl = this.doDefaultMouseUp(iCanvasMouseData.getMouseModifier(), iCanvasMouseData.getModelLocation(), iCanvasMouseData.getViewLocation());
        int n = iCanvasMouseData.getMouseModifier();
        if (this.getState() == 0 && (n & 0x10) == 0) {
            this.doDefaultMouseClick(iCanvasMouseData);
        }
        return bl;
    }

    public boolean doDefaultMouseUp(int n, Point point, Point point2) {
        if (this.mCurrentSourceHoverPort != null) {
            this.mCurrentSourceHoverPort.unset();
            this.mCurrentSourceHoverPort = null;
        }
        return super.doMouseUp(n, point, point2);
    }

    public boolean doMouseClick(int n, Point point, Point point2) {
        if (this.getCanvasController() != null) {
            BasicCanvasMouseData basicCanvasMouseData = new BasicCanvasMouseData(this, n, point, point2);
            return this.getCanvasController().handleMouseClick(basicCanvasMouseData);
        }
        return this.doDefaultMouseClick(n, point, point2);
    }

    public boolean doMouseDblClick(int n, Point point, Point point2) {
        if (this.getCanvasController() != null) {
            BasicCanvasMouseData basicCanvasMouseData = new BasicCanvasMouseData(this, n, point, point2);
            return this.getCanvasController().handleMouseDblClick(basicCanvasMouseData);
        }
        return this.doDefaultMouseDblClick(n, point, point2);
    }

    public boolean doMouseUp(int n, Point point, Point point2) {
        if (this.getCanvasController() != null) {
            BasicCanvasMouseData basicCanvasMouseData = new BasicCanvasMouseData(this, n, point, point2);
            return this.getCanvasController().handleMouseUp(basicCanvasMouseData);
        }
        return this.doDefaultMouseUp(n, point, point2);
    }

    public boolean doMouseDown(int n, Point point, Point point2) {
        if (this.getCanvasController() != null) {
            BasicCanvasMouseData basicCanvasMouseData = new BasicCanvasMouseData(this, n, point, point2);
            return this.getCanvasController().handleMouseDown(basicCanvasMouseData);
        }
        return this.doDefaultMouseDown(n, point, point2);
    }

    public boolean doMouseMove(int n, Point point, Point point2) {
        if (this.getCanvasController() != null) {
            BasicCanvasMouseData basicCanvasMouseData = new BasicCanvasMouseData(this, n, point, point2);
            return this.getCanvasController().handleMouseMove(basicCanvasMouseData);
        }
        return this.doDefaultMouseMove(n, point, point2);
    }

    public void expendAllNode() {
        JGoListPosition jGoListPosition = this.mSelectedLayer.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.mSelectedLayer.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof BasicCanvasMethoidNode) {
                ((BasicCanvasMethoidNode)jGoObject).expand();
            }
            jGoListPosition = this.mSelectedLayer.getNextObjectPos(jGoListPosition);
        }
    }

    public Point getDefaultLocationForNewNode(IMethoidNode iMethoidNode) {
        Point point = new Point(this.getViewPosition());
        JGoObject jGoObject = null;
        int n = 1;
        do {
            point.x += 10;
            point.y += 10;
            if (point.y < this.getExtentSize().height) continue;
            point.x = this.getViewPosition().x + n++ * 40;
            point.y = this.getViewPosition().y + 10;
        } while ((jGoObject = this.mSelectedLayer.pickObject(point, false)) != null && jGoObject.getLocation().equals(point));
        return point;
    }

    public ICanvasFieldNode findCanvasFieldNode(IFieldNode iFieldNode) {
        JGoDocument jGoDocument = this.getDocument();
        JGoListPosition jGoListPosition = null;
        JGoObject jGoObject = null;
        ICanvasFieldNode iCanvasFieldNode2 = null;
        Collection collection = null;
        jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null) {
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof ICanvasMethoidNode) {
                ICanvasMethoidNode iCanvasMethoidNode = (ICanvasMethoidNode)jGoObject;
                collection = iCanvasMethoidNode.getNodes();
                for (ICanvasFieldNode iCanvasFieldNode2 : collection) {
                    if (iCanvasFieldNode2.getFieldNode() != iFieldNode) continue;
                    return iCanvasFieldNode2;
                }
            }
            jGoListPosition = jGoDocument.getNextObjectPos(jGoListPosition);
        }
        return null;
    }

    public ICanvasMethoidNode findCanvasMethoidNode(IMethoidNode iMethoidNode) {
        JGoDocument jGoDocument = this.getDocument();
        JGoListPosition jGoListPosition = null;
        JGoObject jGoObject = null;
        Object var5_5 = null;
        jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null) {
            ICanvasMethoidNode iCanvasMethoidNode;
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof ICanvasMethoidNode && (iCanvasMethoidNode = (ICanvasMethoidNode)jGoObject).getMethoidNode() == iMethoidNode) {
                return iCanvasMethoidNode;
            }
            jGoListPosition = jGoDocument.getNextObjectPos(jGoListPosition);
        }
        return null;
    }

    public ICanvasMethoidNode getCanvasMethoidNodeByPoint(Point point) {
        Point point2 = new Point(point);
        this.convertViewToDoc(point2);
        JGoListPosition jGoListPosition = this.mSelectedLayer.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.mSelectedLayer.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof ICanvasMethoidNode && jGoObject.getBoundingRect().contains(point2)) {
                return (ICanvasMethoidNode)jGoObject;
            }
            jGoListPosition = this.mSelectedLayer.getNextObjectPos(jGoListPosition);
        }
        return null;
    }

    public ICanvasFieldNode getCanvasFieldNodeByPoint(Point point) {
        Point point2 = new Point(point);
        this.convertViewToDoc(point2);
        ICanvasMethoidNode iCanvasMethoidNode = this.getCanvasMethoidNodeByPoint(point);
        if (iCanvasMethoidNode != null) {
            return iCanvasMethoidNode.getFieldNodeByPoint(point2);
        }
        return null;
    }

    public void newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        if (this.getCanvasController() == null) {
            super.newLink(jGoPort, jGoPort2);
        }
        if (jGoPort.getParent() == jGoPort2.getParent()) {
            this.noNewLink(jGoPort, jGoPort2);
            return;
        }
        if (!(jGoPort.getParent() instanceof ICanvasMethoidNode) || !(jGoPort2.getParent() instanceof ICanvasMethoidNode)) {
            this.noNewLink(jGoPort, jGoPort2);
            return;
        }
        ICanvasFieldNode iCanvasFieldNode = ((ICanvasMethoidNode)jGoPort.getParent()).getFieldNodeByConnectPointObject(jGoPort);
        ICanvasFieldNode iCanvasFieldNode2 = ((ICanvasMethoidNode)jGoPort2.getParent()).getFieldNodeByConnectPointObject(jGoPort2);
        if (iCanvasFieldNode == null || iCanvasFieldNode2 == null) {
            this.noNewLink(jGoPort, jGoPort2);
            return;
        }
        if (!this.getCanvasController().handleAddLink(iCanvasFieldNode, iCanvasFieldNode2)) {
            this.noNewLink(jGoPort, jGoPort2);
        }
    }

    protected void noNewLink(JGoPort jGoPort, JGoPort jGoPort2) {
        JGoPort jGoPort3;
        if (this.mDropLocation == null) {
            return;
        }
        Point point = this.mDropLocation;
        Point point2 = new Point(point);
        this.mDropLocation = null;
        this.convertViewToDoc(point2);
        super.noNewLink(jGoPort, jGoPort2);
        if (point2 == null) {
            return;
        }
        if (this.getCanvasController() == null) {
            return;
        }
        JGoPort jGoPort4 = jGoPort3 = jGoPort != null ? jGoPort : jGoPort2;
        if (jGoPort3 == null) {
            return;
        }
        ICanvasFieldNode iCanvasFieldNode = ((ICanvasMethoidNode)jGoPort3.getParent()).getFieldNodeByConnectPointObject(jGoPort3);
        if (iCanvasFieldNode == null) {
            return;
        }
        this.getCanvasController().handleAddLink((ICanvasNode)iCanvasFieldNode, point2, point, this.mDropAction);
    }

    public void doCancelMouse() {
        this.mDropLocation = null;
        super.doCancelMouse();
    }

    public void onDrop(DropTargetDropEvent dropTargetDropEvent) {
        this.mDropLocation = dropTargetDropEvent.getLocation();
        this.mDropAction = dropTargetDropEvent.getDropAction();
        super.onDrop(dropTargetDropEvent);
    }

    public void onKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127 && this.getDocument().isModifiable()) {
            this.deleteSelection();
        }
    }

    public void removeNodes(Collection collection) {
        final Iterator iterator = collection.iterator();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    JGoObject jGoObject = (JGoObject)iterator.next();
                    if (jGoObject instanceof ICanvasNodeToNodeLink) {
                        BasicCanvasView.this.mFilterNodeLinks.remove(jGoObject);
                    } else if (jGoObject instanceof ICanvasNodeToTreeLink || jGoObject instanceof ICanvasTreeToNodeLink || jGoObject instanceof ICanvasTreeToTreeLink) {
                        BasicCanvasView.this.mFilterTreeNodeLink.remove(jGoObject);
                    }
                    BasicCanvasView.this.getDocument().removeObject(jGoObject);
                }
            }
        });
    }

    public void selectNode(Object object) {
        JGoDocument jGoDocument = this.getDocument();
        JGoListPosition jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null) {
            ICanvasNode iCanvasNode;
            JGoObject jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ICanvasNode) || (iCanvasNode = (ICanvasNode)jGoObject).getDataObject() != object) continue;
            this.selectObject(jGoObject);
            return;
        }
    }

    public void onDragGestureRecognized(DragGestureEvent dragGestureEvent) {
        super.onDragGestureRecognized(dragGestureEvent);
    }

    protected void handleNewGroupNode(IMapperGroupNode iMapperGroupNode) {
        if (!(iMapperGroupNode instanceof IMethoidNode)) {
            return;
        }
        IMethoidNode iMethoidNode = (IMethoidNode)iMapperGroupNode;
        ICanvasMethoidNode iCanvasMethoidNode = this.getCanvasObjectFactory().createMethoidNode(iMethoidNode);
        this.addNode(iCanvasMethoidNode);
        IMapperNode iMapperNode = iMethoidNode.getFirstNode();
        while (iMapperNode != null) {
            this.handleNewNode(iMapperNode);
            iMapperNode = iMethoidNode.getNextNode(iMapperNode);
        }
        iMapperGroupNode.addPropertyChangeListener(this.mGroupNodeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewNode(IMapperNode iMapperNode) {
        if (iMapperNode instanceof IMapperGroupNode) {
            this.handleNewGroupNode((IMapperGroupNode)iMapperNode);
            return;
        }
        List list = iMapperNode.getLinks();
        List list2 = this.mNewLinkList;
        synchronized (list2) {
            for (int i = 0; i < list.size(); ++i) {
                if (this.mNewLinkList.contains(list.get(i))) continue;
                this.mNewLinkList.add(list.get(i));
            }
        }
        iMapperNode.addPropertyChangeListener(this.mNodeLinkListener);
    }

    protected void handleRemoveNode(IMapperNode iMapperNode) {
        if (iMapperNode instanceof IMethoidNode) {
            this.handleRemoveMethoidNode((IMethoidNode)iMapperNode);
            return;
        }
        iMapperNode.removePropertyChangeListener(this.mNodeLinkListener);
    }

    protected void handleRemoveMethoidNode(IMethoidNode iMethoidNode) {
        Object object;
        if (iMethoidNode instanceof IMethoidNode) {
            iMethoidNode.removePropertyChangeListener(this.mGroupNodeListener);
            object = iMethoidNode.getFirstNode();
            while (object != null) {
                this.handleRemoveNode((IMapperNode)object);
                object = iMethoidNode.getNextNode((IMapperNode)object);
            }
        }
        if ((object = this.findCanvasMethoidNode(iMethoidNode)) != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            this.removeNodes(arrayList);
        }
    }

    protected void onScrollEvent(AdjustmentEvent adjustmentEvent) {
        if (this.mFilterTreeNodeLink == null) {
            return;
        }
        int n = this.getViewPosition().x;
        int n2 = this.getViewPosition().y;
        super.onScrollEvent(adjustmentEvent);
        if (n != this.getViewPosition().x) {
            this.adjustTreeLinkPortsX();
        }
        if (n2 != this.getViewPosition().y) {
            this.adjustTreeLinkPortsY();
        }
        this.updateNodeToNodeLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeCanvasNode(IMapperViewModel iMapperViewModel) {
        List list = iMapperViewModel.getNodes();
        Iterator iterator = list.iterator();
        Object var4_4 = null;
        List list2 = list;
        synchronized (list2) {
            while (iterator.hasNext()) {
                var4_4 = iterator.next();
                if (!(var4_4 instanceof IMapperNode)) continue;
                this.handleNewNode(var4_4);
            }
        }
        this.initializeNewLinks();
    }

    private void initializeNewLinks() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.initializeNewLinksInST();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BasicCanvasView.this.initializeNewLinksInST();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNewLinksInST() {
        IMapperViewModel iMapperViewModel = this.getParentView().getViewModel();
        List list = this.mNewLinkList;
        synchronized (list) {
            for (int i = 0; i < this.mNewLinkList.size(); ++i) {
                IMapperLink iMapperLink = (IMapperLink)this.mNewLinkList.get(i);
                IMapperNode iMapperNode = this.findTopLevelNode(iMapperLink.getStartNode());
                IMapperNode iMapperNode2 = this.findTopLevelNode(iMapperLink.getEndNode());
                if (iMapperNode == null || iMapperNode2 == null || !iMapperViewModel.containsNode(iMapperNode) || !iMapperViewModel.containsNode(iMapperNode2)) continue;
                ICanvasMapperLink iCanvasMapperLink = this.getCanvasObjectFactory().createLink(iMapperLink);
                if (iCanvasMapperLink != null) {
                    this.addLink(iCanvasMapperLink);
                    this.mNewLinkList.remove(i);
                    --i;
                    continue;
                }
                this.mLogger.log(Level.SEVERE, "Factory cannot create Canvas Link from mapper link: " + iMapperLink.toString());
            }
        }
    }

    private IMapperNode findTopLevelNode(IMapperNode iMapperNode) {
        while (iMapperNode != null && iMapperNode.getGroupNode() != null) {
            iMapperNode = iMapperNode.getGroupNode();
        }
        return iMapperNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeToNodeLinks() {
        if (this.mFilterNodeLinks == null) {
            return;
        }
        List list = this.mFilterNodeLinks;
        synchronized (list) {
            for (int i = 0; i < this.mFilterNodeLinks.size(); ++i) {
                AbstractCanvasLink abstractCanvasLink = (AbstractCanvasLink)this.mFilterNodeLinks.get(i);
                if (!abstractCanvasLink.isDisplaying(this.getViewRect())) continue;
                abstractCanvasLink.calculateStroke();
            }
        }
    }

    int getTreeLinkFromPortX() {
        return this.getViewPosition().x;
    }

    int getTreeLinkPortY(IMapperNode iMapperNode) {
        return iMapperNode.getY() + 1 + this.getViewPosition().y;
    }

    int getTreeLinkToPortX() {
        return this.getTreeLinkFromPortX() + this.getExtentSize().width;
    }

    private void adjustTreeLinkPortsX() {
        final int n = this.getTreeLinkFromPortX();
        final int n2 = this.getTreeLinkToPortX();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n3 = 0;
                Object var2_2 = null;
                while (n3 < BasicCanvasView.this.mFilterTreeNodeLink.size()) {
                    JGoPort jGoPort;
                    Object object = BasicCanvasView.this.mFilterTreeNodeLink;
                    synchronized (object) {
                        if (BasicCanvasView.this.mFilterTreeNodeLink.size() <= n3) {
                            break;
                        }
                        var2_2 = BasicCanvasView.this.mFilterTreeNodeLink.get(n3++);
                    }
                    if (!(var2_2 instanceof AbstractCanvasLink)) continue;
                    object = var2_2;
                    if (((AbstractCanvasLink)object).getMapperLink().getStartNode() instanceof IMapperTreeNode) {
                        jGoPort = object.getFromPort();
                        jGoPort.setLeft(n);
                    }
                    if (!(((AbstractCanvasLink)object).getMapperLink().getEndNode() instanceof IMapperTreeNode)) continue;
                    jGoPort = object.getToPort();
                    jGoPort.setLeft(n2);
                }
            }
        });
    }

    private void adjustTreeLinkPortsY() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n = 0;
                Object var2_2 = null;
                while (n < BasicCanvasView.this.mFilterTreeNodeLink.size()) {
                    JGoPort jGoPort;
                    Object object = BasicCanvasView.this.mFilterTreeNodeLink;
                    synchronized (object) {
                        if (n >= BasicCanvasView.this.mFilterTreeNodeLink.size()) {
                            break;
                        }
                        var2_2 = BasicCanvasView.this.mFilterTreeNodeLink.get(n++);
                    }
                    if (!(var2_2 instanceof AbstractCanvasLink)) continue;
                    object = var2_2;
                    if (((AbstractCanvasLink)object).getMapperLink().getStartNode() instanceof IMapperTreeNode) {
                        jGoPort = object.getFromPort();
                        jGoPort.setTop(BasicCanvasView.this.getTreeLinkPortY(((AbstractCanvasLink)object).getMapperLink().getStartNode()));
                    }
                    if (!(((AbstractCanvasLink)object).getMapperLink().getEndNode() instanceof IMapperTreeNode)) continue;
                    jGoPort = object.getToPort();
                    jGoPort.setTop(BasicCanvasView.this.getTreeLinkPortY(((AbstractCanvasLink)object).getMapperLink().getEndNode()));
                }
            }
        });
    }

    private void debugDoc() {
        JGoListPosition jGoListPosition = this.getDocument().getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.getDocument().getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getDocument().getNextObjectPos(jGoListPosition);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.isMouseEnabled()) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        this.convertViewToDoc(point);
        for (JGoObject jGoObject = this.pickDocObject(point, false); jGoObject != null; jGoObject = jGoObject.getParent()) {
            String string = null;
            string = jGoObject instanceof BasicCanvasMethoidNode ? ((BasicCanvasMethoidNode)jGoObject).getToolTipText(point) : jGoObject.getToolTipText();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCanvasMouseListener(ICanvasMouseListener iCanvasMouseListener) {
        Set set = this.mMouseListeners;
        synchronized (set) {
            this.mMouseListeners.add(iCanvasMouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCanvasMouseListener(ICanvasMouseListener iCanvasMouseListener) {
        Set set = this.mMouseListeners;
        synchronized (set) {
            this.mMouseListeners.remove(iCanvasMouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireMouseEvent(int n, ICanvasMouseData iCanvasMouseData) {
        boolean bl = false;
        LinkedList linkedList = new LinkedList();
        Set set = this.mMouseListeners;
        synchronized (set) {
            linkedList.addAll(this.mMouseListeners);
        }
        for (ICanvasMouseListener iCanvasMouseListener : linkedList) {
            switch (n) {
                case 1: {
                    if (!iCanvasMouseListener.doMouseClick(iCanvasMouseData)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!iCanvasMouseListener.doMouseDblClick(iCanvasMouseData)) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (!iCanvasMouseListener.doMouseDown(iCanvasMouseData)) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (!iCanvasMouseListener.doMouseUp(iCanvasMouseData)) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (!iCanvasMouseListener.doMouseMove(iCanvasMouseData)) break;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public JGoSelection createDefaultSelection() {
        return new PortSelection(this){

            public JGoObject selectObject(JGoObject jGoObject) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BasicCanvasView.this.requestFocus();
                    }
                });
                BasicCanvasView.this.getDocument().bringObjectToFront(jGoObject);
                return super.selectObject(jGoObject);
            }
        };
    }

    public void autoscroll(Point point) {
    }

    private class GroupNodeListener
    implements PropertyChangeListener {
        private GroupNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("MapperGN.InsertNode")) {
                BasicCanvasView.this.handleNewNode((IMapperNode)propertyChangeEvent.getNewValue());
                BasicCanvasView.this.initializeNewLinks();
            } else if (propertyChangeEvent.getPropertyName().equals("MapperGN.RemoveNode")) {
                BasicCanvasView.this.handleRemoveNode((IMapperNode)propertyChangeEvent.getOldValue());
            }
        }
    }

    private class ViewModelChangeListener
    implements PropertyChangeListener {
        private ViewModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("MapperVM.AddNode")) {
                BasicCanvasView.this.handleNewNode((IMapperNode)propertyChangeEvent.getNewValue());
                BasicCanvasView.this.initializeNewLinks();
            } else if (propertyChangeEvent.getPropertyName().equals("MapperVM.RemoveNode")) {
                BasicCanvasView.this.handleRemoveNode((IMapperNode)propertyChangeEvent.getOldValue());
            }
        }
    }

    private class NodeLinkListener
    implements PropertyChangeListener {
        private ICanvasView mCanvasView;

        private NodeLinkListener(ICanvasView iCanvasView) {
            this.mCanvasView = iCanvasView;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IMapperLink iMapperLink;
            ICanvasLink iCanvasLink;
            if (propertyChangeEvent.getPropertyName().equals("MNode.AddLink")) {
                if (propertyChangeEvent.getNewValue() instanceof IMapperLink && propertyChangeEvent.getSource() == ((IMapperLink)propertyChangeEvent.getNewValue()).getStartNode()) {
                    BasicCanvasView.this.mNewLinkList.add((IMapperLink)propertyChangeEvent.getNewValue());
                    BasicCanvasView.this.initializeNewLinks();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("MNode.RemoveLink") && propertyChangeEvent.getOldValue() instanceof IMapperLink && (iCanvasLink = BasicCanvasView.this.getCanvasLinkByDataObject(iMapperLink = (IMapperLink)propertyChangeEvent.getOldValue())) != null) {
                ArrayList<ICanvasLink> arrayList = new ArrayList<ICanvasLink>(1);
                arrayList.add(iCanvasLink);
                this.mCanvasView.removeNodes(arrayList);
            }
        }
    }

    private class CanvasSizeListener
    extends ComponentAdapter {
        private CanvasSizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            BasicCanvasView.this.adjustTreeLinkPortsX();
            BasicCanvasView.this.updateNodeToNodeLinks();
        }
    }

    private static class HoverPort {
        private BasicCanvasFieldNode mFieldNode;
        private DrawPort mDrawPort;

        public HoverPort(BasicCanvasFieldNode basicCanvasFieldNode) {
            this.mFieldNode = basicCanvasFieldNode;
            this.mDrawPort = basicCanvasFieldNode.getDrawPort();
        }

        public HoverPort(DrawPort drawPort) {
            this.mFieldNode = drawPort.getFieldNode();
            this.mDrawPort = drawPort;
        }

        public void set(boolean bl) {
            this.mDrawPort.setIsActivated(bl);
            this.mDrawPort.setIsHovering(true);
            this.mFieldNode.setIsHovering(true);
            this.mFieldNode.layoutPorts();
        }

        public void unset() {
            this.mDrawPort.setIsActivated(false);
            this.mDrawPort.setIsHovering(false);
            this.mFieldNode.setIsHovering(false);
            this.mFieldNode.layoutPorts();
        }
    }
}

