/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;
import javax.swing.JLabel;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.AccessibleArea;

public class JGoLabel
extends AccessibleArea {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    private int mVerticalAlignment = 0;
    private int mHorizonalAligment = 0;
    private Insets mBorderSpace = new Insets(0, 8, 0, 5);
    private JGoRectangle mBoundRect;
    private JGoText mTextLabel;
    private static VolatileImage mGraphicHolder;
    private static final int MAX_TEXT_WIDTH = 250;
    private static final String ELLIPSES = "...";

    public JGoLabel() {
        this.initialize();
    }

    public JGoLabel(String string) {
        this();
        this.setText(string);
    }

    public JGoBrush getBrush() {
        return this.mBoundRect.getBrush();
    }

    public Font getFont() {
        return this.mTextLabel.getFont();
    }

    public int getFontSize() {
        return this.mTextLabel.getFontSize();
    }

    public int getHorizonalAligment() {
        return this.mHorizonalAligment;
    }

    public Insets getInsets() {
        return this.mBorderSpace;
    }

    public JGoPen getPen() {
        return this.mBoundRect.getPen();
    }

    public String getText() {
        return this.mTextLabel.getText();
    }

    public Color getTextColor() {
        return this.mTextLabel.getTextColor();
    }

    public int getVerticalAligment() {
        return this.mVerticalAlignment;
    }

    public boolean isUnderline() {
        return this.mTextLabel.isUnderline();
    }

    public void setBrush(JGoBrush jGoBrush) {
        this.mBoundRect.setBrush(jGoBrush);
    }

    public void setBold(boolean bl) {
        this.mTextLabel.setBold(bl);
    }

    public void setItalic(boolean bl) {
        this.mTextLabel.setItalic(bl);
    }

    public void setFontSize(int n) {
        this.mTextLabel.setFontSize(n);
        this.ensureLabelSize();
    }

    public void setHorizonalAligment(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid horizonal aligment; either LEFT, CENTER, RIGHT");
        }
        this.mHorizonalAligment = n;
        this.layoutLabel();
    }

    public void setInsets(Insets insets) {
        this.mBorderSpace = insets;
        this.ensureLabelSize();
    }

    public void setPen(JGoPen jGoPen) {
        this.mBoundRect.setPen(jGoPen);
    }

    public void setText(String string) {
        String string2 = this.restrictTextWidth(string);
        this.mTextLabel.setText(string2);
        this.ensureLabelSize();
        this.layoutChildren();
    }

    private String restrictTextWidth(String string) {
        if (mGraphicHolder.validate(JGoLabel.getDefaultConfiguration()) == 2) {
            mGraphicHolder = JGoLabel.createGraphicImage();
        }
        Graphics graphics = mGraphicHolder.getGraphics();
        graphics.setFont(this.mTextLabel.getFont());
        int n = graphics.getFontMetrics().stringWidth(ELLIPSES);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            n2 = graphics.getFontMetrics().stringWidth(String.valueOf(cArray[i]));
            if (n + n2 <= 250) {
                stringBuffer.append(cArray[i]);
                n += n2;
                continue;
            }
            stringBuffer.append(ELLIPSES);
            break;
        }
        return stringBuffer.toString();
    }

    public void setTextColor(Color color) {
        this.mTextLabel.setTextColor(color);
    }

    public void setUnderline(boolean bl) {
        this.mTextLabel.setUnderline(bl);
    }

    public void setVerticalAligment(int n) {
        if (n != 0 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Invalid vertical aligment; either TOP, CENTER, BOTTOM");
        }
        this.mVerticalAlignment = n;
        this.layoutLabel();
    }

    public void geometryChange(Rectangle rectangle) {
        if (rectangle.width == this.getWidth() && rectangle.height == this.getHeight()) {
            super.geometryChange(rectangle);
        } else {
            this.ensureSize();
        }
    }

    public void doStartEditing(JGoView jGoView, Point point) {
        this.mTextLabel.doStartEdit(jGoView, point);
    }

    public int getMinimumWidth() {
        return this.mTextLabel.getWidth() + this.mBorderSpace.left + this.mBorderSpace.right;
    }

    public int getMinimumHeight() {
        return this.mTextLabel.getHeight() + this.mBorderSpace.top + this.mBorderSpace.bottom;
    }

    public void resizeToMinimum() {
        this.setSize(this.getMinimumWidth(), this.getMinimumHeight());
    }

    protected void layoutChildren() {
        this.layoutLabel();
        this.mBoundRect.setBoundingRect(this.getBoundingRect());
    }

    private static GraphicsConfiguration getDefaultConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static VolatileImage createGraphicImage() {
        return JGoLabel.getDefaultConfiguration().createCompatibleVolatileImage(1, 1);
    }

    private void ensureLabelSize() {
        if (mGraphicHolder.validate(JGoLabel.getDefaultConfiguration()) == 2) {
            mGraphicHolder = JGoLabel.createGraphicImage();
        }
        Graphics graphics = mGraphicHolder.getGraphics();
        graphics.setFont(this.mTextLabel.getFont());
        int n = graphics.getFontMetrics().stringWidth(this.mTextLabel.getText());
        int n2 = graphics.getFontMetrics(this.mTextLabel.getFont()).getHeight();
        if (n != this.mTextLabel.getWidth() || n2 != this.mTextLabel.getHeight()) {
            this.mTextLabel.setSize(new Dimension(n, n2));
            this.ensureSize();
        }
    }

    private void ensureSize() {
        int n = this.getMinimumWidth();
        if (this.getWidth() < n) {
            this.setWidth(n);
            return;
        }
        int n2 = this.getMinimumHeight();
        if (this.getHeight() < n2) {
            this.setHeight(n2);
            return;
        }
        this.layoutChildren();
    }

    private void initialize() {
        this.mTextLabel = new JGoText();
        this.mTextLabel.setSelectable(false);
        this.mTextLabel.setDraggable(false);
        this.mTextLabel.setAutoResize(false);
        this.mTextLabel.setEditable(false);
        this.mTextLabel.setResizable(false);
        this.mTextLabel.setTransparent(true);
        this.mTextLabel.setAlignment(2);
        this.mBoundRect = new JGoRectangle();
        this.mBoundRect.setSelectable(false);
        this.mBoundRect.setDraggable(false);
        this.mBoundRect.setResizable(false);
        this.mBoundRect.setPen(JGoPen.make((int)65535, (int)1, (Color)Color.BLACK));
        this.addObjectAtTail((JGoObject)this.mBoundRect);
        this.addObjectAtTail((JGoObject)this.mTextLabel);
    }

    private void layoutLabel() {
        block27: {
            block0 : switch (this.mVerticalAlignment) {
                case 0: {
                    switch (this.mHorizonalAligment) {
                        case 0: {
                            int n;
                            int n2;
                            this.mTextLabel.setSpotLocation(0, (JGoObject)this, 0);
                            if (this.mBorderSpace.left > 0 && (n2 = this.mTextLabel.getLeft() - this.getLeft()) < this.mBorderSpace.left) {
                                this.mTextLabel.setLeft(this.mTextLabel.getLeft() + (this.mBorderSpace.left - n2));
                            }
                            if (this.mBorderSpace.right > 0) {
                                n2 = this.mTextLabel.getLeft() - this.getLeft();
                                n = this.getWidth() - this.mTextLabel.getWidth() - n2;
                                if (n < this.mBorderSpace.right) {
                                    this.mTextLabel.setLeft(this.mTextLabel.getLeft() - (this.mBorderSpace.right - n));
                                }
                            }
                            if (this.mBorderSpace.top > 0 && (n2 = this.mTextLabel.getTop() - this.getTop()) < this.mBorderSpace.top) {
                                this.mTextLabel.setTop(this.mTextLabel.getTop() + (this.mBorderSpace.top - n2));
                            }
                            if (this.mBorderSpace.bottom > 0) {
                                n2 = this.mTextLabel.getTop() - this.getTop();
                                n = this.getHeight() - this.mTextLabel.getHeight() - n2;
                                if (n >= this.mBorderSpace.bottom) break block0;
                                this.mTextLabel.setTop(this.mTextLabel.getTop() - (this.mBorderSpace.bottom - n));
                                break;
                            }
                            break block27;
                        }
                        case 1: {
                            this.mTextLabel.setSpotLocation(8, (JGoObject)this, 8);
                            if (this.mBorderSpace.left > 0) {
                                this.mTextLabel.setLeft(this.mTextLabel.getLeft() + this.mBorderSpace.left);
                                break;
                            }
                            break block27;
                        }
                        case 2: {
                            this.mTextLabel.setSpotLocation(4, (JGoObject)this, 4);
                            if (this.mBorderSpace.right > 0) {
                                this.mTextLabel.setLeft(this.mTextLabel.getLeft() - this.mBorderSpace.left);
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.mHorizonalAligment) {
                        case 0: {
                            this.mTextLabel.setSpotLocation(2, (JGoObject)this, 2);
                            break;
                        }
                        case 1: {
                            this.mTextLabel.setSpotLocation(1, (JGoObject)this, 1);
                            if (this.mBorderSpace.left <= 0) break;
                            this.mTextLabel.setLeft(this.mTextLabel.getLeft() + this.mBorderSpace.left);
                            break;
                        }
                        case 2: {
                            this.mTextLabel.setSpotLocation(3, (JGoObject)this, 3);
                            if (this.mBorderSpace.right <= 0) break;
                            this.mTextLabel.setLeft(this.mTextLabel.getLeft() - this.mBorderSpace.left);
                        }
                    }
                    if (this.mBorderSpace.top <= 0) break;
                    this.mTextLabel.setTop(this.mTextLabel.getTop() + this.mBorderSpace.top);
                    break;
                }
                case 4: {
                    switch (this.mHorizonalAligment) {
                        case 0: {
                            this.mTextLabel.setSpotLocation(6, (JGoObject)this, 6);
                            break;
                        }
                        case 1: {
                            this.mTextLabel.setSpotLocation(7, (JGoObject)this, 7);
                            if (this.mBorderSpace.left <= 0) break;
                            this.mTextLabel.setLeft(this.mTextLabel.getLeft() + this.mBorderSpace.left);
                            break;
                        }
                        case 2: {
                            this.mTextLabel.setSpotLocation(5, (JGoObject)this, 5);
                            if (this.mBorderSpace.right <= 0) break;
                            this.mTextLabel.setLeft(this.mTextLabel.getLeft() - this.mBorderSpace.left);
                        }
                    }
                    if (this.mBorderSpace.bottom <= 0) break;
                    this.mTextLabel.setTop(this.mTextLabel.getTop() - this.mBorderSpace.bottom);
                }
            }
        }
    }

    static {
        Font font = new JLabel().getFont();
        JGoText.setDefaultFontFaceName((String)font.getFontName());
        JGoText.setDefaultFontSize((int)font.getSize());
        mGraphicHolder = JGoLabel.createGraphicImage();
    }
}

