/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicAccumulatingMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.palette.AutoLayoutButton;
import org.netbeans.modules.soa.mapper.basicmapper.palette.BasicViewItem;
import org.netbeans.modules.soa.mapper.basicmapper.palette.CollapseAllButton;
import org.netbeans.modules.soa.mapper.basicmapper.palette.DeleteSelectionButton;
import org.netbeans.modules.soa.mapper.basicmapper.palette.ExpandAllButton;
import org.netbeans.modules.soa.mapper.basicmapper.palette.MenuCategory;
import org.netbeans.modules.soa.mapper.basicmapper.palette.MenuGroup;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdaterFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteView;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteViewCategory;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteViewItem;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteViewObjectFactory;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteCategory;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteItem;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteManager;
import org.openide.util.NbBundle;

public class BasicMapperPalette
implements IPaletteView,
IPaletteViewObjectFactory {
    private IBasicViewManager mViewManager;
    private IPaletteManager mModel;
    private IPaletteViewObjectFactory mFactory;
    private ResourceBundle mBundle;
    private Class mBundleLoader = BasicMapperPalette.class;
    private List mCategoryList;
    private List mCategoryViewList;
    private List mItemList;
    private Icon mCategroyIcon;
    private boolean mSelectedOnRequest = true;
    private static final Logger LOGGER = Logger.getLogger(BasicMapperPalette.class.getName());
    private PropertyChangeListener mPManagerListener = new PaletteManagerListener();
    private MenuGroup mMenuGroup = new MenuGroup();
    private ILiteralUpdaterFactory mLiteralUpdaterFactory;
    private JPanel mPanel;
    private JToolBar mToolBar;
    private Map mPeripheryComponents = new HashMap();

    public BasicMapperPalette(IBasicViewManager iBasicViewManager) {
        this.mToolBar = new JToolBar();
        this.mToolBar.setFloatable(false);
        this.mViewManager = iBasicViewManager;
        this.mCategoryList = new Vector();
        this.mCategoryViewList = new ArrayList();
        this.mItemList = new Vector();
        this.setFactory(this);
        this.mToolBar.add(this.mMenuGroup);
        this.mPanel = new JPanel(new BorderLayout(0, 0));
        this.mPanel.add((Component)this.mToolBar, "Center");
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public IBasicViewManager getViewManager() {
        return this.mViewManager;
    }

    public void setPaletteManager(IPaletteManager iPaletteManager) {
        this.mModel = iPaletteManager;
        if (this.mModel.isInitialized()) {
            this.initPaletteItems();
        }
        this.mModel.addPropertyChangeListener(this.mPManagerListener);
    }

    public IPaletteManager getPaletteManager() {
        return this.mModel;
    }

    public ResourceBundle getBundle() {
        if (this.mBundle == null) {
            this.mBundle = NbBundle.getBundle(this.getClass());
        }
        return this.mBundle;
    }

    public void setBundle(ResourceBundle resourceBundle, Class clazz) {
        this.mBundle = resourceBundle;
        if (clazz != null) {
            this.mBundleLoader = clazz;
        }
    }

    public Component getViewComponent() {
        return this.mPanel;
    }

    public Component getPaletteComponent() {
        return this.mToolBar;
    }

    public Component getPeripheryComponent(Object object) {
        return (Component)this.mPeripheryComponents.get(object);
    }

    public void setPeripheryComponent(Component component, Object object) {
        Component component2 = this.getPeripheryComponent(object);
        if (component2 != null) {
            this.mPanel.remove(component2);
        }
        this.mPeripheryComponents.put(object, component);
        this.mPanel.add(component, object);
    }

    public Component add(Component component) {
        return this.mToolBar.add(component, this.mToolBar.getComponentCount() - 1);
    }

    public Component add(Component component, int n) {
        if (n == this.mToolBar.getComponentCount()) {
            return this.mToolBar.add(component, n - 1);
        }
        return this.mToolBar.add(component, n);
    }

    public void add(Component component, Object object, int n) {
        this.add(component, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(IPaletteViewItem iPaletteViewItem) {
        List list = this.mItemList;
        synchronized (list) {
            Component component = iPaletteViewItem.getViewComponent();
            if (iPaletteViewItem instanceof MenuCategory) {
                this.mMenuGroup.addMenu((MenuCategory)iPaletteViewItem);
            } else {
                this.add(component);
            }
            this.mItemList.add(iPaletteViewItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(IPaletteViewItem iPaletteViewItem) {
        List list = this.mItemList;
        synchronized (list) {
            this.mItemList.remove(iPaletteViewItem);
            Component component = iPaletteViewItem.getViewComponent();
            if (component instanceof MenuCategory) {
                this.mMenuGroup.removeMenu((MenuCategory)component);
            } else {
                this.mToolBar.remove(component);
            }
        }
    }

    public int getItemCount() {
        return this.getItemCount(this.mItemList);
    }

    private int getItemCount(Collection collection) {
        int n = 0;
        for (IPaletteViewItem iPaletteViewItem : collection) {
            if (iPaletteViewItem instanceof IPaletteViewCategory) {
                n += this.getItemCount(((IPaletteViewCategory)iPaletteViewItem).getViewItems());
                continue;
            }
            ++n;
        }
        return n;
    }

    public Collection getAllItems() {
        return this.mItemList;
    }

    private Collection getAllItems(Collection collection) {
        HashSet<IPaletteViewItem> hashSet = new HashSet<IPaletteViewItem>();
        for (IPaletteViewItem iPaletteViewItem : collection) {
            if (iPaletteViewItem instanceof IPaletteViewCategory) {
                hashSet.addAll(this.getAllItems(((IPaletteViewCategory)iPaletteViewItem).getViewItems()));
                continue;
            }
            hashSet.add(iPaletteViewItem);
        }
        return hashSet;
    }

    public Collection getItems() {
        return this.mItemList;
    }

    public IPaletteViewItem findPaletteViewItem(IPaletteItem iPaletteItem) {
        return this.findPaletteViewItem(this.mItemList, iPaletteItem);
    }

    public IMethoid findMethoid(IPaletteItem iPaletteItem) {
        IPaletteViewItem iPaletteViewItem = this.createViewablePaletteItem(iPaletteItem);
        return (IMethoid)iPaletteViewItem.getTransferableObject();
    }

    private IPaletteViewItem findPaletteViewItem(Collection collection, IPaletteItem iPaletteItem) {
        for (IPaletteViewItem iPaletteViewItem : collection) {
            if (iPaletteViewItem.getItemObject() == iPaletteItem) {
                return iPaletteViewItem;
            }
            if (!(iPaletteViewItem instanceof IPaletteViewCategory) || (iPaletteViewItem = this.findPaletteViewItem(((IPaletteViewCategory)iPaletteViewItem).getViewItems(), iPaletteItem)) == null) continue;
            return iPaletteViewItem;
        }
        return null;
    }

    public IPaletteViewItem createViewablePaletteItem(IPaletteItem iPaletteItem) {
        return new BasicViewItem(iPaletteItem, this.getBundle(), this.mLiteralUpdaterFactory);
    }

    public IPaletteViewItem createViewablePaletteCategoryItem(IPaletteCategory iPaletteCategory) {
        if (this.mCategroyIcon == null) {
            String string = "down.png";
            try {
                this.mCategroyIcon = new ImageIcon(BasicMapperPalette.class.getResource(string));
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Unable to load category button icon: " + string, exception);
            }
        }
        return new MenuCategory(iPaletteCategory, this.mModel, this.mCategroyIcon, this.getBundle(), this.mBundleLoader);
    }

    public IPaletteViewItem createAutoLayoutItem() {
        return new AutoLayoutButton(this);
    }

    public IPaletteViewItem createExpandAllNodesItem() {
        return new ExpandAllButton(this);
    }

    public IPaletteViewItem createCollapseAllNodesItem() {
        return new CollapseAllButton(this);
    }

    public IPaletteViewItem createDeleteSelectedNodesItem() {
        return new DeleteSelectionButton(this);
    }

    public void addItemSeparator() {
        this.mToolBar.addSeparator();
    }

    public void setFactory(IPaletteViewObjectFactory iPaletteViewObjectFactory) {
        this.mFactory = iPaletteViewObjectFactory;
    }

    public IPaletteViewObjectFactory getFactory() {
        return this.mFactory;
    }

    public void initPaletteItems() {
        IPaletteManager iPaletteManager = this.getPaletteManager();
        IPaletteCategory[] iPaletteCategoryArray = iPaletteManager.getAllCategories();
        IPaletteItem[] iPaletteItemArray = null;
        boolean bl = false;
        for (int i = 0; i < iPaletteCategoryArray.length; ++i) {
            if (this.mCategoryList.contains(iPaletteCategoryArray[i])) continue;
            IPaletteViewItem iPaletteViewItem = this.getFactory().createViewablePaletteCategoryItem(iPaletteCategoryArray[i]);
            if (iPaletteViewItem instanceof IPaletteViewCategory) {
                this.addItem(iPaletteViewItem);
                this.mCategoryViewList.add(iPaletteViewItem);
            }
            iPaletteViewItem.getViewComponent().setEnabled(this.mToolBar.isEnabled());
            iPaletteItemArray = iPaletteManager.getCategoryItems(iPaletteCategoryArray[i]);
            if (iPaletteItemArray == null) continue;
            int[] nArray = iPaletteManager.getCategorySelectedItemIndices(iPaletteCategoryArray[i]);
            for (int j = 0; j < iPaletteItemArray.length; ++j) {
                IPaletteViewItem iPaletteViewItem2 = this.getFactory().createViewablePaletteItem(iPaletteItemArray[j]);
                if (iPaletteViewItem instanceof IPaletteViewCategory) {
                    ((IPaletteViewCategory)iPaletteViewItem).addViewItem(iPaletteViewItem2);
                } else {
                    this.addItem(iPaletteViewItem2);
                }
                iPaletteViewItem2.getViewComponent().setVisible(false);
                for (int k = 0; k < nArray.length; ++k) {
                    if (nArray[k] != j) continue;
                    iPaletteViewItem2.getViewComponent().setVisible(true);
                }
                ((Component)((Object)iPaletteViewItem2)).setEnabled(this.mToolBar.isEnabled());
                if (!(iPaletteViewItem2 instanceof AbstractButton)) continue;
                ((AbstractButton)((Object)iPaletteViewItem2)).addActionListener(new RequestNewMethoidAction((IMethoid)iPaletteViewItem2.getTransferableObject()));
            }
            if (iPaletteViewItem instanceof IPaletteViewCategory) continue;
            this.addItem(iPaletteViewItem);
        }
        MapperUtilities.activateInlineMnemonics(this.mToolBar);
    }

    public boolean getSelectedOnRequest() {
        return this.mSelectedOnRequest;
    }

    public void setSelectedOnRequest(boolean bl) {
        this.mSelectedOnRequest = bl;
    }

    public void selectedItem(IPaletteItem iPaletteItem) {
        if (!(this.mToolBar.isVisible() && this.mToolBar.isEnabled() && this.getSelectedOnRequest())) {
            return;
        }
        IPaletteViewItem iPaletteViewItem = this.findPaletteViewItem(iPaletteItem);
        if (iPaletteViewItem == null) {
            return;
        }
    }

    public void uncheckItem(IPaletteItem iPaletteItem) {
        IPaletteViewItem iPaletteViewItem = this.findPaletteViewItem(iPaletteItem);
        if (iPaletteViewItem == null) {
            return;
        }
        iPaletteViewItem.getViewComponent().setVisible(false);
    }

    public void checkItem(IPaletteItem iPaletteItem) {
        IPaletteViewItem iPaletteViewItem = this.findPaletteViewItem(iPaletteItem);
        if (iPaletteViewItem == null) {
            return;
        }
        iPaletteViewItem.getViewComponent().setVisible(true);
    }

    public void requestNewMethoidNode(IMethoid iMethoid) {
        BasicMethoidNode basicMethoidNode = null;
        basicMethoidNode = iMethoid.isAccumulative() ? new BasicAccumulatingMethoidNode(iMethoid) : new BasicMethoidNode(iMethoid);
        Point point = this.mViewManager.getCanvasView().getCanvas().getDefaultLocationForNewNode(basicMethoidNode);
        basicMethoidNode.setX(point.x);
        basicMethoidNode.setY(point.y);
        this.getViewManager().postMapperEvent(MapperUtilities.getMapperEvent(this, basicMethoidNode, "MapperEvt.ReqNewNode", "PaletteToolBar requesting new methoid: " + basicMethoidNode));
    }

    public void setEnabled(boolean bl) {
        this.mToolBar.setEnabled(bl);
        for (int i = 0; i < this.mToolBar.getComponentCount(); ++i) {
            this.mToolBar.getComponent(i).setEnabled(bl);
        }
    }

    public void close() {
        this.mModel.removePropertyChangeListener(this.mPManagerListener);
        for (IPaletteViewCategory iPaletteViewCategory : this.mCategoryViewList) {
            iPaletteViewCategory.close();
        }
    }

    public void setLiteralUpdaterFactory(ILiteralUpdaterFactory iLiteralUpdaterFactory) {
        this.mLiteralUpdaterFactory = iLiteralUpdaterFactory;
    }

    private class RequestNewMethoidAction
    implements ActionListener {
        private IMethoid mMethoid;

        public RequestNewMethoidAction(IMethoid iMethoid) {
            this.mMethoid = iMethoid;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicMapperPalette.this.mToolBar.isEnabled()) {
                BasicMapperPalette.this.requestNewMethoidNode(this.mMethoid);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private class PaletteManagerListener
    implements PropertyChangeListener {
        private PaletteManagerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LOGGER.log(Level.FINEST, "BasicMapperPalette:" + BasicMapperPalette.this + " hashcode:" + BasicMapperPalette.this.hashCode());
            LOGGER.log(Level.FINEST, "IPaletteManager new event: " + propertyChangeEvent.getPropertyName());
            if (propertyChangeEvent.getPropertyName().equals("Palette_initialized")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BasicMapperPalette.this.initPaletteItems();
                    }
                });
            } else if (propertyChangeEvent.getPropertyName().equals("Palette_selectedItem")) {
                if (propertyChangeEvent.getNewValue() instanceof IPaletteItem) {
                    BasicMapperPalette.this.selectedItem((IPaletteItem)propertyChangeEvent.getNewValue());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("Palette_checkedItem")) {
                if (propertyChangeEvent.getNewValue() instanceof IPaletteItem) {
                    BasicMapperPalette.this.checkItem((IPaletteItem)propertyChangeEvent.getNewValue());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("Palette_uncheckedItem") && propertyChangeEvent.getNewValue() instanceof IPaletteItem) {
                BasicMapperPalette.this.uncheckItem((IPaletteItem)propertyChangeEvent.getNewValue());
            }
        }
    }
}

