/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.palette;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.soa.mapper.basicmapper.palette.BasicMapperPalette;
import org.netbeans.modules.soa.mapper.basicmapper.palette.MenuGroup;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteViewCategory;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteViewItem;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteCategory;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteManager;
import org.openide.util.NbBundle;

public class MenuCategory
extends JToggleButton
implements IPaletteViewCategory {
    private static Font FONT_MENUBAR = UIManager.getFont("MenuBar.font");
    private static Font FONT_MENUITEM = UIManager.getFont("MenuItem.font");
    private static Color COLOR_MENUBAR_SHADOW = UIManager.getColor("MenuBar.shadow");
    private static Color COLOR_MENUITEM_FG = UIManager.getColor("MenuItem.foreground");
    private static Color COLOR_MENUITEM_BG = UIManager.getColor("MenuItem.background");
    private static Color COLOR_MENUITEM_SELECTION_FG = UIManager.getColor("MenuItem.selectionForeground");
    private static Color COLOR_MENUITEM_SELECTION_BG = UIManager.getColor("MenuItem.selectionBackground");
    private MenuGroup mGroup;
    private static final Object _SEPARACTOR;
    private IPaletteCategory mCategory;
    private IPaletteManager mModel;
    private List mViewItemList;
    private List mMenuItemList;
    private ButtonPopupMenu mButtonMenu;
    private Component mCurrentFocusedComponent;
    private AWTEventListener mFocusLostClickListener;
    private static final Logger LOGGER;
    Color mDisabledTextColor = null;

    public MenuCategory(IPaletteCategory iPaletteCategory, IPaletteManager iPaletteManager, Icon icon, ResourceBundle resourceBundle, Class clazz) {
        super(iPaletteCategory.getName());
        String string;
        Object object;
        this.mCategory = iPaletteCategory;
        this.mModel = iPaletteManager;
        this.mViewItemList = new LinkedList();
        this.mMenuItemList = new LinkedList();
        ImageIcon imageIcon = null;
        String string2 = (String)iPaletteCategory.getCategoryAttribute("Icon");
        if (string2 != null && (object = clazz.getResource(string = resourceBundle.getString(string2))) != null) {
            imageIcon = new ImageIcon((URL)object);
        }
        if (imageIcon == null) {
            this.setIconTextGap(1);
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(2);
            if (icon != null) {
                this.setIcon(icon);
            } else {
                try {
                    this.setIcon(new ImageIcon(this.getClass().getResource("category_10x16.png")));
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Unable to find the default category icon file: category_10x16.png", exception);
                }
            }
        } else {
            this.setIcon(imageIcon);
        }
        string = (String)iPaletteCategory.getCategoryAttribute("A11yDesc");
        if (!MapperUtilities.isEmpty(string)) {
            string = resourceBundle.getString(string);
        }
        if (MapperUtilities.isEmpty(string)) {
            string = MapperUtilities.cutAmpersand(iPaletteCategory.getName());
        }
        if (!MapperUtilities.isEmpty((String)(object = (String)iPaletteCategory.getCategoryAttribute("A11yName")))) {
            object = resourceBundle.getString((String)object);
        }
        if (MapperUtilities.isEmpty((String)object)) {
            object = MapperUtilities.cutAmpersand(iPaletteCategory.getName());
        }
        this.getAccessibleContext().setAccessibleDescription(string);
        this.getAccessibleContext().setAccessibleName((String)object);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (MenuCategory.this.isSelected()) {
                    MenuCategory.this.showButtonMenu();
                } else {
                    MenuCategory.this.mButtonMenu.hide();
                }
            }
        });
        this.setFont(FONT_MENUBAR);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 12));
        this.setIconTextGap(4);
    }

    public void setGroup(MenuGroup menuGroup) {
        this.mGroup = menuGroup;
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                MenuCategory menuCategory;
                if (MenuCategory.this.mGroup != null && (menuCategory = MenuCategory.this.mGroup.getActiveMenu()) != null && menuCategory != MenuCategory.this) {
                    MenuCategory.this.setSelected(true);
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (this.mButtonMenu == null) {
            this.createNewButtonPopupMenu(window);
        } else if (this.mButtonMenu.getOwner() != window) {
            this.createNewButtonPopupMenu(window);
        }
    }

    private void createNewButtonPopupMenu(Window window) {
        if (this.mButtonMenu != null) {
            this.mButtonMenu.hide();
            this.mButtonMenu.cleanup();
            this.mButtonMenu.dispose();
        }
        this.mButtonMenu = new ButtonPopupMenu(window);
        for (Object e : this.mMenuItemList) {
            if (e == _SEPARACTOR) {
                this.mButtonMenu.addSeparator();
                continue;
            }
            this.mButtonMenu.addButton((AbstractButton)e);
        }
    }

    public IPaletteCategory getPaletteCategory() {
        return this.mCategory;
    }

    public void showButtonMenu() {
        if (this.mButtonMenu == null) {
            throw new IllegalStateException("Can't show the menu yet because the MenuButton has not been displayed to the screen yet");
        }
        this.mButtonMenu.pack();
        this.setMenuLocation();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.getFocusLostClickListener(), 16L);
        this.mButtonMenu.show();
    }

    private AWTEventListener getFocusLostClickListener() {
        if (this.mFocusLostClickListener == null) {
            this.mFocusLostClickListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    Window window;
                    if (MenuCategory.this.mButtonMenu == null || !MenuCategory.this.mButtonMenu.isVisible()) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        return;
                    }
                    Object object = aWTEvent.getSource();
                    if (((MouseEvent)aWTEvent).getClickCount() > 0 && object instanceof Component && !(object instanceof MenuCategory) && (window = SwingUtilities.windowForComponent((Component)object)) != MenuCategory.this.mButtonMenu) {
                        MenuCategory.this.setSelected(false);
                    }
                }
            };
        }
        return this.mFocusLostClickListener;
    }

    private void setMenuLocation() {
        Dimension dimension = this.mButtonMenu.getSize();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(dimension2.width, dimension2.height - insets.bottom);
        Point point = this.getLocationOnScreen();
        Rectangle rectangle2 = new Rectangle(point.x, point.y + this.getSize().height, dimension.width, dimension.height);
        if (rectangle.contains(rectangle2)) {
            this.mButtonMenu.setLocation(rectangle2.x, rectangle2.y);
        } else {
            this.mButtonMenu.setLocation(point.x, point.y - dimension.height);
        }
    }

    public void hideButtonMenu() {
        this.setSelected(false);
    }

    public Component getViewComponent() {
        return this;
    }

    public Object getItemObject() {
        return this.mCategory;
    }

    public Object getTransferableObject() {
        return null;
    }

    public void setTransferableObject(Object object) {
    }

    public void addViewItem(IPaletteViewItem iPaletteViewItem) {
        if (this.mViewItemList.contains(iPaletteViewItem)) {
            return;
        }
        this.mViewItemList.add(iPaletteViewItem);
        this.mMenuItemList.add(iPaletteViewItem.getViewComponent());
        if (this.mButtonMenu != null) {
            this.mButtonMenu.addButton((AbstractButton)((Object)iPaletteViewItem));
        }
    }

    public void insertViewItem(IPaletteViewItem iPaletteViewItem, int n) {
        if (this.mViewItemList.contains(iPaletteViewItem)) {
            return;
        }
        this.mViewItemList.add(n, iPaletteViewItem);
        this.mMenuItemList.add(n, iPaletteViewItem.getViewComponent());
        if (this.mButtonMenu != null) {
            this.mButtonMenu.addButton((AbstractButton)iPaletteViewItem.getViewComponent(), n);
        }
    }

    public void removeViewItem(int n) {
        this.mViewItemList.remove(n);
        this.mMenuItemList.remove(n);
        if (this.mButtonMenu != null) {
            this.mButtonMenu.removeButton(n);
        }
    }

    public void removeViewItem(IPaletteViewItem iPaletteViewItem) {
        this.mViewItemList.remove(iPaletteViewItem);
        this.mMenuItemList.remove(iPaletteViewItem.getViewComponent());
        if (this.mButtonMenu != null) {
            this.mButtonMenu.removeButton((AbstractButton)iPaletteViewItem.getViewComponent());
        }
    }

    public Collection getViewItems() {
        return Collections.unmodifiableCollection(this.mViewItemList);
    }

    public IPaletteViewItem getViewItem(int n) {
        return (IPaletteViewItem)this.mViewItemList.get(n);
    }

    public int getViewItemIndex(IPaletteViewItem iPaletteViewItem) {
        return this.mViewItemList.indexOf(iPaletteViewItem);
    }

    public int getViewItemCount() {
        return this.mViewItemList.size();
    }

    public void addSeparator() {
        this.mMenuItemList.add(_SEPARACTOR);
        if (this.mButtonMenu != null) {
            this.mButtonMenu.addSeparator();
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            component.setEnabled(bl);
        }
    }

    private void init() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(4);
    }

    public void hide() {
        super.hide();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.getFocusLostClickListener());
    }

    public void close() {
        if (this.mButtonMenu != null) {
            this.mButtonMenu.hide();
            this.mButtonMenu.cleanup();
            this.mButtonMenu.dispose();
            this.mButtonMenu = null;
            this.mGroup = null;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        MenuCategory menuCategory = this;
        Dimension dimension = menuCategory.getSize();
        Rectangle rectangle = new Rectangle(dimension);
        int n = rectangle.x + rectangle.width - 10;
        int n2 = rectangle.y + rectangle.height / 2;
        Polygon polygon = new Polygon();
        for (int i = 4; i >= 0; i -= 2) {
            polygon.addPoint(n, n2);
            polygon.addPoint(n + i, n2);
            ++n2;
            ++n;
        }
        Color color = Color.black;
        if (!menuCategory.isEnabled()) {
            if (this.mDisabledTextColor == null) {
                this.mDisabledTextColor = UIManager.getColor("Button.disabledText");
            }
            color = this.mDisabledTextColor;
        }
        graphics.setColor(color);
        graphics.drawPolygon(polygon);
        graphics.fillPolygon(polygon);
    }

    static {
        COLOR_MENUBAR_SHADOW = COLOR_MENUBAR_SHADOW == null ? Color.GRAY : COLOR_MENUBAR_SHADOW;
        COLOR_MENUITEM_FG = COLOR_MENUITEM_FG == null ? Color.BLACK : COLOR_MENUITEM_FG;
        COLOR_MENUITEM_BG = COLOR_MENUITEM_BG == null ? Color.WHITE : COLOR_MENUITEM_BG;
        COLOR_MENUITEM_SELECTION_FG = COLOR_MENUITEM_SELECTION_FG == null ? Color.WHITE : COLOR_MENUITEM_SELECTION_FG;
        COLOR_MENUITEM_SELECTION_BG = COLOR_MENUITEM_SELECTION_BG == null ? Color.LIGHT_GRAY : COLOR_MENUITEM_SELECTION_BG;
        _SEPARACTOR = new Object();
        LOGGER = Logger.getLogger(BasicMapperPalette.class.getName());
    }

    private class ButtonPopupMenu
    extends JWindow {
        private JPanel mButtonList;
        private int mButtonHeight;
        private ComponentListener mComponentListener;
        private ActionListener mActionListener;
        private FocusListener mFocusListener;
        private Action mNextFocusAction;
        private Action mPrevFocusAction;
        private Action mNextMenuAction;
        private Action mPrevMenuAction;
        private Action mHideAction;
        private Action mDefaultButtonAction;
        private MouseMotionListener mButtonFocusListener;

        public ButtonPopupMenu(Window window) {
            super(window);
            this.mActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuCategory.this.setSelected(false);
                }
            };
            this.mFocusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    Object object = focusEvent.getSource();
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    Component component = keyboardFocusManager.getFocusOwner();
                    if (component != null && component instanceof JButton) {
                        if (MenuCategory.this.mCurrentFocusedComponent != component && MenuCategory.this.mCurrentFocusedComponent != null) {
                            MenuCategory.this.mCurrentFocusedComponent.setForeground(COLOR_MENUITEM_FG);
                        }
                        MenuCategory.this.mCurrentFocusedComponent = component;
                        MenuCategory.this.mCurrentFocusedComponent.setForeground(COLOR_MENUITEM_SELECTION_FG);
                    }
                    ButtonPopupMenu.this.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    ButtonPopupMenu.this.repaint();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                            Component component2 = SwingUtilities.getRoot(component);
                            if (component2 != ButtonPopupMenu.this) {
                                MenuCategory.this.setSelected(false);
                            }
                        }
                    });
                }
            };
            this.mNextFocusAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    Component component = keyboardFocusManager.getFocusOwner();
                    if (component == null) {
                        ButtonPopupMenu.this.repaint();
                        return;
                    }
                    for (int i = 0; i < ButtonPopupMenu.this.mButtonList.getComponentCount(); ++i) {
                        if (component != ButtonPopupMenu.this.mButtonList.getComponent(i)) continue;
                        keyboardFocusManager.focusNextComponent();
                        return;
                    }
                }
            };
            this.mPrevFocusAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    Component component = keyboardFocusManager.getFocusOwner();
                    if (component == null) {
                        ButtonPopupMenu.this.repaint();
                        return;
                    }
                    for (int i = 0; i < ButtonPopupMenu.this.mButtonList.getComponentCount(); ++i) {
                        if (component != ButtonPopupMenu.this.mButtonList.getComponent(i)) continue;
                        keyboardFocusManager.focusPreviousComponent();
                        return;
                    }
                }
            };
            this.mNextMenuAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuGroup menuGroup;
                    MenuCategory menuCategory;
                    Container container = MenuCategory.this.getParent();
                    if (container instanceof MenuGroup && (menuCategory = (menuGroup = (MenuGroup)container).getNextMenu(MenuCategory.this)) != null) {
                        MenuCategory.this.setSelected(false);
                        menuCategory.setSelected(true);
                    }
                }
            };
            this.mPrevMenuAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuGroup menuGroup;
                    MenuCategory menuCategory;
                    Container container = MenuCategory.this.getParent();
                    if (container instanceof MenuGroup && (menuCategory = (menuGroup = (MenuGroup)container).getPreviousMenu(MenuCategory.this)) != null) {
                        MenuCategory.this.setSelected(false);
                        menuCategory.setSelected(true);
                    }
                }
            };
            this.mHideAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuCategory.this.setSelected(false);
                }
            };
            this.mDefaultButtonAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    Component component = keyboardFocusManager.getFocusOwner();
                    if (component == null) {
                        return;
                    }
                    for (int i = 0; i < ButtonPopupMenu.this.mButtonList.getComponentCount(); ++i) {
                        Component component2 = ButtonPopupMenu.this.mButtonList.getComponent(i);
                        if (component != component2) continue;
                        ((AbstractButton)component2).doClick(0);
                        return;
                    }
                }
            };
            this.mButtonFocusListener = new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (mouseEvent.getSource() instanceof JButton) {
                        Component component = (Component)mouseEvent.getSource();
                        if (MenuCategory.this.mCurrentFocusedComponent != component && MenuCategory.this.mCurrentFocusedComponent != null) {
                            MenuCategory.this.mCurrentFocusedComponent.setForeground(COLOR_MENUITEM_FG);
                        }
                        MenuCategory.this.mCurrentFocusedComponent = component;
                        MenuCategory.this.mCurrentFocusedComponent.setForeground(COLOR_MENUITEM_SELECTION_FG);
                        component.requestFocus();
                    }
                }
            };
            this.mButtonList = new MenuButtonList();
            this.mButtonList.setBackground(COLOR_MENUITEM_BG);
            this.mButtonList.setBorder(BorderFactory.createLineBorder(COLOR_MENUBAR_SHADOW));
            this.mButtonList.setLayout(new GridBagLayout());
            Color color = this.mButtonList.getBackground();
            this.mButtonList.addFocusListener(this.mFocusListener);
            this.addFocusListener(this.mFocusListener);
            this.getContentPane().add(this.mButtonList);
            this.registerDefaultKeyActionBindings();
            this.mComponentListener = new ComponentListener(){

                public void componentHidden(ComponentEvent componentEvent) {
                    MenuCategory.this.setSelected(false);
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    MenuCategory.this.setSelected(false);
                }

                public void componentResized(ComponentEvent componentEvent) {
                    MenuCategory.this.setSelected(false);
                }

                public void componentShown(ComponentEvent componentEvent) {
                    MenuCategory.this.setSelected(false);
                }
            };
            this.getOwner().addComponentListener(this.mComponentListener);
            JButton jButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"LBL_Category_Configuration_Item"));
            this.mButtonHeight = jButton.getPreferredSize().height + 2;
        }

        public void hide() {
            super.hide();
            if (MenuCategory.this.mGroup != null && MenuCategory.this.mGroup.getActiveMenu() == MenuCategory.this) {
                MenuCategory.this.mGroup.setActiveMenu(null);
            }
        }

        public void show() {
            super.show();
            if (this.mButtonList.getComponentCount() > 0) {
                this.mButtonList.getComponent(0).requestFocus();
            }
            if (MenuCategory.this.mGroup != null) {
                MenuCategory.this.mGroup.setActiveMenu(MenuCategory.this);
            }
        }

        public void addButton(AbstractButton abstractButton) {
            this.addButton(abstractButton, this.mButtonList.getComponentCount() - 2);
        }

        public void addButton(AbstractButton abstractButton, int n) {
            if (n < 0) {
                n = 0;
            } else if (n > this.mButtonList.getComponentCount() - 2) {
                throw new IndexOutOfBoundsException("component count: " + (this.mButtonList.getComponentCount() - 2) + " insert index: " + n);
            }
            this.addButton(n, abstractButton);
        }

        private void addButton(int n, AbstractButton abstractButton) {
            this.initButton(abstractButton);
            this.addComponent(n, abstractButton);
            if (this.mButtonHeight > 0) {
                Dimension dimension = new Dimension(abstractButton.getPreferredSize().width + 2, this.mButtonHeight);
                abstractButton.setPreferredSize(dimension);
                abstractButton.setMinimumSize(dimension);
            }
        }

        public void removeButton(AbstractButton abstractButton) {
            this.mButtonList.remove(abstractButton);
            this.unInitButton(abstractButton);
        }

        public void removeButton(int n) {
            AbstractButton abstractButton = (AbstractButton)this.mButtonList.getComponent(n);
            this.mButtonList.remove(n);
            this.unInitButton(abstractButton);
        }

        public void addSeparator() {
            JSeparator jSeparator = new JSeparator(0);
            this.addComponent(this.mButtonList.getComponentCount() - 1, jSeparator);
        }

        public void removeAll() {
            int n = this.mButtonList.getComponentCount() - 1;
            while (n >= 0) {
                if (this.mButtonList.getComponent(n) instanceof AbstractButton) {
                    this.removeButton(n--);
                    continue;
                }
                this.mButtonList.remove(n--);
            }
        }

        private void addComponent(int n, Component component) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.mButtonList.add(component, gridBagConstraints, n);
        }

        private void initButton(AbstractButton abstractButton) {
            abstractButton.setFont(FONT_MENUITEM);
            abstractButton.setBorderPainted(false);
            abstractButton.setContentAreaFilled(false);
            abstractButton.addFocusListener(this.mFocusListener);
            abstractButton.addMouseMotionListener(this.mButtonFocusListener);
            abstractButton.addActionListener(this.mActionListener);
        }

        private void unInitButton(AbstractButton abstractButton) {
            abstractButton.removeFocusListener(this.mFocusListener);
            abstractButton.removeMouseMotionListener(this.mButtonFocusListener);
            abstractButton.removeActionListener(this.mActionListener);
        }

        private void registerDefaultKeyActionBindings() {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
            this.getRootPane().getActionMap().put("up", this.mPrevFocusAction);
            this.getRootPane().getInputMap(2).put(keyStroke, "up");
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
            this.getRootPane().getActionMap().put("down", this.mNextFocusAction);
            this.getRootPane().getInputMap(2).put(keyStroke2, "down");
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
            this.getRootPane().getActionMap().put("esc", this.mHideAction);
            this.getRootPane().getInputMap(2).put(keyStroke3, "esc");
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke(10, 0);
            this.getRootPane().getActionMap().put("enter", this.mDefaultButtonAction);
            this.getRootPane().getInputMap(2).put(keyStroke4, "enter");
            KeyStroke keyStroke5 = KeyStroke.getKeyStroke(39, 0);
            this.getRootPane().getActionMap().put("right", this.mNextMenuAction);
            this.getRootPane().getInputMap(2).put(keyStroke5, "right");
            KeyStroke keyStroke6 = KeyStroke.getKeyStroke(37, 0);
            this.getRootPane().getActionMap().put("left", this.mPrevMenuAction);
            this.getRootPane().getInputMap(2).put(keyStroke6, "left");
        }

        public void cleanup() {
            if (this.mButtonList != null) {
                this.removeAll();
                this.getOwner().removeComponentListener(this.mComponentListener);
                this.mButtonList.removeFocusListener(this.mFocusListener);
                this.mButtonList = null;
                this.mPrevFocusAction = null;
                this.mNextFocusAction = null;
                this.mHideAction = null;
                this.mDefaultButtonAction = null;
                this.mNextMenuAction = null;
                this.mPrevMenuAction = null;
            }
        }
    }

    private class MenuButtonList
    extends JPanel {
        private MenuButtonList() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (MenuCategory.this.mCurrentFocusedComponent != null) {
                graphics.setColor(COLOR_MENUITEM_SELECTION_BG);
                graphics.fillRect(0, MenuCategory.this.mCurrentFocusedComponent.getY(), this.getWidth(), MenuCategory.this.mCurrentFocusedComponent.getHeight());
            }
        }
    }
}

