/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.tree;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mapper.basicmapper.BasicViewController;
import org.netbeans.modules.soa.mapper.basicmapper.MapperLink;
import org.netbeans.modules.soa.mapper.basicmapper.dnd.ComponentDnDHandler;
import org.netbeans.modules.soa.mapper.basicmapper.util.LocalObjectTransferable;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.IMapperView;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperView;
import org.netbeans.modules.soa.mapper.common.basicmapper.dnd.IBasicDragController;
import org.netbeans.modules.soa.mapper.common.basicmapper.dnd.IDnDHandler;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IBasicTreeViewSelectionPathController;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasController;

public abstract class AbstractTreeViewController
extends BasicViewController
implements IDnDHandler,
IBasicTreeViewSelectionPathController {
    private static final Logger LOGGER = Logger.getLogger(AbstractTreeViewController.class.getName());
    private ComponentDnDHandler mDndHandler;
    private LocalObjectTransferable mTransferable;
    private final DragGestureListener mDragGestureListener = new GestureListener();
    private final DragSourceListener mDragSourceListener = new DragListener();
    private final DropTargetListener mDropTargetListener = new DropListener();
    private IMapperTreeNode mOriginatingNode;
    private TreePath mDragLinkSourcePath;
    private Cursor mOriginalDragCursor;
    private MapperTreeNodeLinkDragPair mDragPair;

    public AbstractTreeViewController() {
        this.mTransferable = new LocalObjectTransferable();
        this.mDndHandler = new ComponentDnDHandler();
        this.mDndHandler.setHandler(this);
        this.setDnDHandler(this);
    }

    public void setView(IMapperView iMapperView) {
        if (!(iMapperView instanceof IMapperTreeView)) {
            throw new IllegalArgumentException("TreeViewController.setView expecting IMapperTreeView. Got: " + iMapperView.getClass().getName());
        }
        super.setView(iMapperView);
        this.mDndHandler.setComponent(((IMapperTreeView)iMapperView).getTree());
    }

    public DragGestureListener getDragGestureListener() {
        return this.mDragGestureListener;
    }

    public DragSourceListener getDragSourceListener() {
        return this.mDragSourceListener;
    }

    public DropTargetListener getDropTargetListener() {
        return this.mDropTargetListener;
    }

    public int getDragAction() {
        return 3;
    }

    public Cursor getDragCursor() {
        return DragSource.DefaultCopyDrop;
    }

    public void releaseHandler() {
        this.mDndHandler.setComponent(null);
    }

    public Point getSelectionPathPoint() {
        Point point;
        Rectangle rectangle;
        IMapperTreeView iMapperTreeView = (IMapperTreeView)this.getView();
        JTree jTree = iMapperTreeView.getTree();
        TreePath treePath = jTree.getSelectionPath();
        if (this.mDragLinkSourcePath == null) {
            this.mDragLinkSourcePath = jTree.getSelectionPath();
        }
        if ((rectangle = iMapperTreeView.getShowingPathRectBound(this.mDragLinkSourcePath)) != null && (point = iMapperTreeView.getTreeNodePoint(rectangle)) != null) {
            return new Point(this.getDragPortOriginX(), point.y + 2 - iMapperTreeView.getViewOffset().y);
        }
        return null;
    }

    private MapperTreeNodeLinkDragPair getDragPair() {
        if (this.mDragPair == null) {
            this.mDragPair = new MapperTreeNodeLinkDragPair();
        }
        return this.mDragPair;
    }

    private void cleanupDragAndDrop() {
        if (this.mOriginatingNode != null) {
            this.mOriginatingNode.setHighlightLink(false);
            this.getViewModel().removeNode(this.mOriginatingNode);
            this.mOriginatingNode = null;
        }
        if (this.getDragPair() != null) {
            if (this.getDragPair().getTreeNode() != null) {
                this.getDragPair().getTreeNode().setHighlightLink(false);
            }
            this.getViewModel().removeNode(this.getDragPair().getTreeNode());
            this.mDragPair = null;
        }
        IBasicDragController iBasicDragController = this.getMapperDragController();
        iBasicDragController.setOriginatingDragNode(null);
        iBasicDragController.setTransferObject(null);
        iBasicDragController.clearDragLink();
        this.mDragLinkSourcePath = null;
        iBasicDragController.setLinkDragSourceContext(null);
    }

    protected abstract boolean handleJGoObjectDrop(DropTargetDropEvent var1);

    protected abstract boolean handleJLocalObjectDrop(DropTargetDropEvent var1, Object var2);

    protected abstract Object getDragObject(DragGestureEvent var1);

    protected abstract void setLinkOnNode(IMapperLink var1, IMapperTreeNode var2);

    protected abstract void setOppositeLinkOnNode(IMapperLink var1, IMapperTreeNode var2);

    protected abstract IMapperTreeNode getOriginatingTreeNodeFromLink(IMapperLink var1);

    protected abstract boolean isNodeAlreadyLinked(IMapperNode var1);

    protected abstract int getDragPortOriginX();

    private class MapperTreeNodeLinkDragPair {
        private IMapperTreeNode mTreeNode;
        private IMapperLink mLink;

        private MapperTreeNodeLinkDragPair() {
        }

        public IMapperTreeNode getTreeNode() {
            return this.mTreeNode;
        }

        public void removeDragNode() {
            if (this.mLink != null) {
                AbstractTreeViewController.this.setLinkOnNode(this.mLink, null);
                this.mTreeNode.removeLink(this.mLink);
                this.mTreeNode.setHighlightLink(false);
            }
            AbstractTreeViewController.this.getViewModel().removeNode(this.mTreeNode);
            this.mTreeNode = null;
            this.mLink = null;
        }

        public void setDragNode(IMapperTreeNode iMapperTreeNode) {
            this.mTreeNode = iMapperTreeNode;
            if (this.mLink == null) {
                this.mLink = new MapperLink();
            }
            this.mTreeNode.setHighlightLink(true);
            AbstractTreeViewController.this.setLinkOnNode(this.mLink, this.mTreeNode);
            this.mTreeNode.addLink(this.mLink);
            AbstractTreeViewController.this.getViewModel().addNode(this.mTreeNode);
        }
    }

    protected class GestureListener
    implements DragGestureListener {
        protected GestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point;
            IMapperTreeView iMapperTreeView = (IMapperTreeView)AbstractTreeViewController.this.getView();
            JTree jTree = iMapperTreeView.getTree();
            if (!(dragGestureEvent.getComponent() == jTree && jTree.isEnabled() && jTree.isVisible() && iMapperTreeView.isMapable())) {
                return;
            }
            Object object = AbstractTreeViewController.this.getDragObject(dragGestureEvent);
            if (object != null && (point = AbstractTreeViewController.this.getSelectionPathPoint()) != null) {
                AbstractTreeViewController.this.getMapperDragController().setTransferObject(object);
                AbstractTreeViewController.this.getMapperDragController().setDragLink(point, AbstractTreeViewController.this);
                AbstractTreeViewController.this.mTransferable.setTransferData(object);
                dragGestureEvent.startDrag(AbstractTreeViewController.this.getDnDHandler().getDragCursor(), AbstractTreeViewController.this.mTransferable);
            }
        }
    }

    protected class DragListener
    extends DragSourceAdapter {
        protected DragListener() {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            AbstractTreeViewController.this.cleanupDragAndDrop();
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            AbstractTreeViewController.this.getMapperDragController().setLinkDragSourceContext(dragSourceDragEvent.getDragSourceContext());
        }
    }

    protected class DropListener
    extends DropTargetAdapter {
        private static final int EXPAND_WAIT_INTERVAL = 1000;
        private static final int COLLAPSE_WAIT_INTERVAL = 2000;
        private Thread thread;
        private TreePath hoverPath;
        private final MouseListener MSE_LISTENER = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }

            public void mouseExited(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }
        };
        private final MouseMotionListener MSE_MOTION_LISTENER = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                DropListener.this.interrupt();
                DropListener.this.hoverPath = null;
            }
        };

        protected DropListener() {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Object object;
            Point point = dropTargetDragEvent.getLocation();
            JTree jTree = ((IMapperTreeView)AbstractTreeViewController.this.getView()).getTree();
            int n = jTree.getRowForLocation(point.x, point.y);
            boolean bl = false;
            if (n >= 0) {
                jTree.setSelectionRow(n);
                object = jTree.getPathForLocation(point.x, point.y);
                if (object != null && !((TreePath)object).equals(this.hoverPath)) {
                    this.hoverPath = object;
                    bl = true;
                } else {
                    this.hoverPath = object;
                }
            } else {
                this.hoverPath = null;
            }
            object = AbstractTreeViewController.this.getMapperDragController();
            Object object2 = object.getTransferObject();
            if (object2 instanceof IMapperLink) {
                if (AbstractTreeViewController.this.getOriginatingTreeNodeFromLink((IMapperLink)object2) != null) {
                    this.handleDragOverTreeLink(AbstractTreeViewController.this.getDragPair());
                    this.handleDragOverCanvasLink(dropTargetDragEvent, (IBasicDragController)object);
                }
            } else if (object2 instanceof ICanvasController) {
                this.handleDragOverTreeLink(AbstractTreeViewController.this.getDragPair());
                this.handleDragOverCanvasLink(dropTargetDragEvent, (IBasicDragController)object);
            }
            if (bl) {
                this.interrupt();
                this.addMouseListeners(jTree);
                this.thread = new ExpandThread(this.hoverPath);
                this.thread.start();
            }
        }

        private void handleDragOverTreeLink(MapperTreeNodeLinkDragPair mapperTreeNodeLinkDragPair) {
            if (this.hoverPath == null && mapperTreeNodeLinkDragPair.getTreeNode() != null) {
                mapperTreeNodeLinkDragPair.removeDragNode();
            }
            if (this.hoverPath != null) {
                IMapperTreeNode iMapperTreeNode = ((IMapperTreeView)AbstractTreeViewController.this.getView()).getMapperTreeNode(this.hoverPath);
                boolean bl = iMapperTreeNode.equals(mapperTreeNodeLinkDragPair.getTreeNode());
                if (!bl && !AbstractTreeViewController.this.isNodeAlreadyLinked(iMapperTreeNode)) {
                    IMapperTreeNode iMapperTreeNode2 = (IMapperTreeNode)iMapperTreeNode.clone();
                    mapperTreeNodeLinkDragPair.removeDragNode();
                    mapperTreeNodeLinkDragPair.setDragNode(iMapperTreeNode2);
                } else if (!bl) {
                    mapperTreeNodeLinkDragPair.removeDragNode();
                }
            }
        }

        private void handleDragOverCanvasLink(DropTargetDragEvent dropTargetDragEvent, IBasicDragController iBasicDragController) {
            Point point = null;
            IMapperTreeView iMapperTreeView = (IMapperTreeView)AbstractTreeViewController.this.getView();
            if (this.hoverPath != null) {
                IMapperTreeNode iMapperTreeNode = iMapperTreeView.getMapperTreeNode(this.hoverPath);
                TreePath treePath = iMapperTreeNode.getPath();
                Rectangle rectangle = iMapperTreeView.getShowingPathRectBound(treePath);
                Point point2 = iMapperTreeView.getTreeNodePoint(rectangle);
                if (point2 != null) {
                    point = new Point(AbstractTreeViewController.this.getDragPortOriginX(), point2.y + 2 - iMapperTreeView.getViewOffset().y);
                }
            } else {
                point = new Point(AbstractTreeViewController.this.getDragPortOriginX(), dropTargetDragEvent.getLocation().y - iMapperTreeView.getViewOffset().y);
            }
            if (point != null) {
                iBasicDragController.setDragLinkEndLocation(point);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            Object object;
            if (AbstractTreeViewController.this.getDragPair() != null) {
                AbstractTreeViewController.this.getDragPair().removeDragNode();
                AbstractTreeViewController.this.mDragPair = null;
            }
            if ((object = AbstractTreeViewController.this.getMapperDragController().getTransferObject()) instanceof IMapperLink) {
                if (AbstractTreeViewController.this.mOriginatingNode != null) {
                    AbstractTreeViewController.this.getViewModel().removeNode(AbstractTreeViewController.this.mOriginatingNode);
                    AbstractTreeViewController.this.mOriginatingNode = null;
                }
                AbstractTreeViewController.this.getMapperDragController().resetDragLinkEndLocation();
            } else if (object instanceof ICanvasController) {
                AbstractTreeViewController.this.getMapperDragController().getLinkDragSourceContext().setCursor(AbstractTreeViewController.this.mOriginalDragCursor);
                AbstractTreeViewController.this.mOriginalDragCursor = null;
            }
            this.interrupt();
            this.hoverPath = null;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DragSourceContext dragSourceContext;
            Object object = AbstractTreeViewController.this.getMapperDragController().getTransferObject();
            if (object instanceof IMapperLink) {
                IMapperLink iMapperLink = (IMapperLink)object;
                IMapperTreeNode iMapperTreeNode = AbstractTreeViewController.this.getOriginatingTreeNodeFromLink(iMapperLink);
                if (iMapperTreeNode != null) {
                    IMapperNode iMapperNode = null;
                    if (iMapperLink.getStartNode() != null) {
                        iMapperNode = iMapperLink.getStartNode();
                    } else if (iMapperLink.getEndNode() != null) {
                        iMapperNode = iMapperLink.getEndNode();
                    }
                    if (!MapperUtilities.isLinkAlreadyConnected(iMapperLink, iMapperNode)) {
                        MapperLink mapperLink = new MapperLink();
                        AbstractTreeViewController.this.mOriginatingNode = (IMapperTreeNode)iMapperTreeNode.clone();
                        AbstractTreeViewController.this.setOppositeLinkOnNode(mapperLink, AbstractTreeViewController.this.mOriginatingNode);
                        AbstractTreeViewController.this.mOriginatingNode.addLink(mapperLink);
                        AbstractTreeViewController.this.getViewModel().addNode(AbstractTreeViewController.this.mOriginatingNode);
                    }
                }
            } else if (object instanceof ICanvasController && (dragSourceContext = AbstractTreeViewController.this.getMapperDragController().getLinkDragSourceContext()) != null) {
                AbstractTreeViewController.this.mOriginalDragCursor = dragSourceContext.getCursor();
                dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
            }
            this.interrupt();
            this.hoverPath = null;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            AbstractTreeViewController.this.cleanupDragAndDrop();
            if (AbstractTreeViewController.this.getView() instanceof IBasicMapperView && !((IBasicMapperView)AbstractTreeViewController.this.getView()).isMapable()) {
                Toolkit.getDefaultToolkit().beep();
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Point point = dropTargetDropEvent.getLocation();
            JTree jTree = ((IMapperTreeView)AbstractTreeViewController.this.getView()).getTree();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            if (treePath != null && AbstractTreeViewController.this.getDnDCustomizer() != null && !AbstractTreeViewController.this.getDnDCustomizer().isMappable(treePath)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            if (dropTargetDropEvent.getTransferable().isDataFlavorSupported(MapperUtilities.getJGoSelectionDataFlavor())) {
                dropTargetDropEvent.dropComplete(AbstractTreeViewController.this.handleJGoObjectDrop(dropTargetDropEvent));
            } else if (dropTargetDropEvent.getTransferable().isDataFlavorSupported(MapperUtilities.getJVMLocalObjectDataFlavor())) {
                try {
                    dropTargetDropEvent.dropComplete(AbstractTreeViewController.this.handleJLocalObjectDrop(dropTargetDropEvent, dropTargetDropEvent.getTransferable().getTransferData(MapperUtilities.getJVMLocalObjectDataFlavor())));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                    dropTargetDropEvent.rejectDrop();
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace(System.err);
                    dropTargetDropEvent.rejectDrop();
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        private void interrupt() {
            try {
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Tree drag interrupt exception", exception);
            }
        }

        private void addMouseListeners(JTree jTree) {
            jTree.addMouseListener(this.MSE_LISTENER);
            jTree.addMouseMotionListener(this.MSE_MOTION_LISTENER);
        }

        private void removeMouseListeners(JTree jTree) {
            jTree.removeMouseListener(this.MSE_LISTENER);
            jTree.removeMouseMotionListener(this.MSE_MOTION_LISTENER);
        }

        class ExpandThread
        extends Thread {
            private TreePath mHoverTreePath;

            ExpandThread(TreePath treePath) {
                this.mHoverTreePath = treePath;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        while (true) {
                            JTree jTree;
                            boolean bl;
                            if (bl = (jTree = ((IMapperTreeView)AbstractTreeViewController.this.getView()).getTree()).isExpanded(this.mHoverTreePath)) {
                                ExpandThread.sleep(2000L);
                            } else {
                                ExpandThread.sleep(1000L);
                            }
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    if (bl) {
                                        jTree.collapsePath(ExpandThread.this.mHoverTreePath);
                                    } else {
                                        jTree.expandPath(ExpandThread.this.mHoverTreePath);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        JTree jTree = ((IMapperTreeView)AbstractTreeViewController.this.getView()).getTree();
                        DropListener.this.removeMouseListeners(jTree);
                    }
                }
                catch (Throwable throwable) {
                    JTree jTree = ((IMapperTreeView)AbstractTreeViewController.this.getView()).getTree();
                    DropListener.this.removeMouseListeners(jTree);
                    throw throwable;
                }
            }
        }
    }
}

