/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.gtk;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import org.netbeans.modules.soa.mapper.common.gtk.PaletteButton;
import org.netbeans.modules.soa.mapper.common.util.SbynStrings;
import org.netbeans.modules.soa.mapper.common.util.SbynSwingUtil;

public class BasicPaletteMap {
    private static BasicPaletteMap mInstance = null;
    private ResourceBundle mResourceBundle = null;
    private Map mButtonMap = new HashMap();
    private Map mKeyButtonMap = new HashMap();
    private Map mActionListeners = new HashMap();
    private Map mMouseListeners = new HashMap();
    private Map mIconClassMap = new HashMap();
    private Map mIconKeyMap = new HashMap();

    private BasicPaletteMap() {
        this.initialize();
    }

    public static BasicPaletteMap getInstance() {
        if (mInstance == null) {
            mInstance = new BasicPaletteMap();
        }
        return mInstance;
    }

    public PaletteButton getButton(Object object) {
        if (this.mKeyButtonMap.get(object) == null) {
            return (PaletteButton)this.mButtonMap.get(object);
        }
        return (PaletteButton)this.mKeyButtonMap.get(object);
    }

    public Icon getIcon(Object object) {
        return (Icon)this.mIconClassMap.get(object);
    }

    public Icon getIcon(String string) {
        return (Icon)this.mIconKeyMap.get(string);
    }

    public String getActionListenerClassName(Object object) {
        return (String)this.mActionListeners.get(object);
    }

    public String getMouseListenerClassName(Object object) {
        return (String)this.mMouseListeners.get(object);
    }

    public String getString(String string) {
        String string2 = "PALETTE_BUTTON." + string;
        return this.getLocalizedString(string2);
    }

    private void initialize() {
        this.mResourceBundle = ResourceBundle.getBundle("emanager_palette");
        this.populateButtonMap();
    }

    private String getLocalizedString(String string) {
        String string2 = null;
        try {
            string2 = this.mResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    private void populateButtonMap() {
        String string = this.getLocalizedString("PALETTE_ALL_itemlist");
        String[] stringArray = SbynStrings.tokenize(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.createButton(stringArray[i]);
        }
    }

    public void createButton(String string) {
        String string2 = "PALETTE_BUTTON." + string;
        String string3 = this.getLocalizedString(string2 + ".icon");
        Icon icon = SbynSwingUtil.getIcon(string3);
        String string4 = this.getLocalizedString(string2 + ".paletteIcon");
        Icon icon2 = null;
        icon2 = string4 == null || string4.trim().length() == 0 ? icon : SbynSwingUtil.getIcon(string4);
        String string5 = this.getLocalizedString(string2 + ".toolTip");
        String string6 = this.getLocalizedString(string2 + ".typeId");
        String string7 = this.getLocalizedString(string2 + ".draggable");
        String string8 = this.getLocalizedString(string2 + ".defaultName");
        String string9 = this.getLocalizedString(string2 + ".componentClassName");
        String string10 = this.getLocalizedString(string2 + ".actionListener");
        String string11 = this.getLocalizedString(string2 + ".mouseListener");
        String string12 = this.getLocalizedString(string2 + ".isGroup");
        String string13 = this.getLocalizedString(string2 + ".labelIcon");
        String string14 = this.getLocalizedString(string2 + ".margin");
        String[] stringArray = null;
        if (string14 != null) {
            stringArray = SbynStrings.tokenize(string14, ",");
        }
        String string15 = this.getLocalizedString(string2 + ".componentPopup");
        String string16 = this.getLocalizedString(string2 + ".canvasNodeAction");
        String string17 = this.getLocalizedString(string2 + ".key");
        String string18 = this.getLocalizedString(string2 + ".passthrough");
        Insets insets = null;
        if (stringArray != null && stringArray.length == 4) {
            insets = new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }
        String[] stringArray2 = null;
        String string19 = this.getLocalizedString(string2 + ".upperMargin");
        if (string19 != null) {
            stringArray2 = SbynStrings.tokenize(string19, ",");
        }
        String[] stringArray3 = null;
        String string20 = this.getLocalizedString(string2 + ".lowerMargin");
        if (string20 != null) {
            stringArray3 = SbynStrings.tokenize(string20, ",");
        }
        Component component = null;
        Component component2 = null;
        int n = 0;
        int n2 = 0;
        if (stringArray2 != null && stringArray2.length == 2) {
            n = Integer.parseInt(stringArray2[0]);
            n2 = Integer.parseInt(stringArray2[1]);
            component = Box.createRigidArea(new Dimension(n, n2));
        }
        if (stringArray3 != null && stringArray3.length == 2) {
            n = Integer.parseInt(stringArray3[0]);
            n2 = Integer.parseInt(stringArray3[1]);
            component2 = Box.createRigidArea(new Dimension(n, n2));
        }
        int n3 = Integer.parseInt(string6);
        boolean bl = Boolean.valueOf(string7);
        PaletteButton paletteButton = new PaletteButton(icon, icon2, insets, string5, n3);
        paletteButton.setDraggable(bl);
        paletteButton.addData("defaultName", string8);
        paletteButton.addData("componentClassName", string9);
        paletteButton.addData("isGroup", string12);
        paletteButton.addData("labelIcon", string13);
        paletteButton.addData("componentPopup", string15);
        String string21 = this.getLocalizedString(string2 + ".componentAuxPopup");
        paletteButton.addData("componentAuxPopup", string21);
        paletteButton.addData("canvasNodeAction", string16);
        paletteButton.addData("key", string17);
        if (string18 != null && string18.length() == 0) {
            string18 = null;
        }
        paletteButton.addData("passthrough", string18);
        if (string10 != null && !string10.trim().equals("")) {
            this.mActionListeners.put(paletteButton, string10);
            if (string11 != null && !string11.trim().equals("")) {
                this.mMouseListeners.put(paletteButton, string11);
            }
        }
        this.mButtonMap.put(string9, paletteButton);
        this.mKeyButtonMap.put(string17, paletteButton);
        this.mIconClassMap.put(string9, icon2);
        this.mIconKeyMap.put(string17, icon2);
    }
}

