/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.soa.mapper.common.palette.PaletteList;

public class PaletteListUI
extends BasicListUI {
    private int mRowCount;
    private int mColumnCount;
    private int mLastDimension;
    private int mCheckBoxSize = 25;

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        ListModel<Object> listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || listModel.getSize() == 0) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        int n2 = this.convertYToRow(rectangle2.y);
        int n3 = this.convertYToRow(rectangle2.y + rectangle2.height - 1);
        int n4 = this.convertXToColumn(rectangle2.x);
        int n5 = this.convertXToColumn(rectangle2.x + rectangle2.width - 1);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.mRowCount - 1;
        }
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.mColumnCount - 1;
        }
        if ((rectangle = this.getCellBounds(this.list, n = this.convertCellToIndex(n4, n2), n)) == null) {
            return;
        }
        int n6 = this.list.getLeadSelectionIndex();
        int n7 = rectangle.y;
        for (int i = n4; i <= n5; ++i) {
            int n8;
            for (int j = n2; j <= n3 && (n8 = this.convertCellToIndex(i, j)) != -1; ++j) {
                rectangle.height = this.getRowHeight(j);
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                this.paintCell(graphics, n8, rectangle, listCellRenderer, listModel, listSelectionModel, n6);
                rectangle.y += rectangle.height;
            }
            rectangle.y = n7;
            rectangle.width = this.getColumnWidth(i);
            rectangle.x += rectangle.width;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        return new Dimension(this.mColumnCount * this.cellWidth + insets.left + insets.right, this.mRowCount * this.cellHeight + insets.top + insets.bottom);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new PaletteListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertCellToIndex(this.convertXToColumn(point.x), this.convertYToRow(point.y));
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        int n2 = this.convertColumnToX(this.convertIndexToColumn(n));
        int n3 = this.convertRowToY(this.convertIndexToRow(n));
        return n3 == -1 || n2 == -1 ? null : new Point(n2, n3);
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = this.convertRowToY(this.convertIndexToRow(n3));
        int n6 = this.convertRowToY(this.convertIndexToRow(n4));
        int n7 = this.convertColumnToX(this.convertIndexToColumn(n3));
        int n8 = this.convertColumnToX(this.convertIndexToColumn(n4));
        if (n5 == -1 || n6 == -1 || n7 == -1 || n8 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n9 = n7;
        int n10 = n5;
        int n11 = n8 + this.getColumnWidth(this.convertIndexToColumn(n4)) - n7;
        int n12 = n6 + this.getRowHeight(this.convertIndexToRow(n4)) - n5;
        return new Rectangle(n9, n10, n11, n12);
    }

    protected int getRowHeight(int n) {
        if (n < 0 || n >= this.mRowCount) {
            return -1;
        }
        return this.cellHeight;
    }

    protected int getColumnWidth(int n) {
        if (n < 0 || n >= this.mColumnCount) {
            return -1;
        }
        return this.cellWidth;
    }

    protected int convertIndexToRow(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        if (((PaletteList)this.list).getAlignStyle() == 1) {
            return this.mRowCount <= 0 ? -1 : n % this.mRowCount;
        }
        return this.mColumnCount <= 0 ? -1 : n / this.mColumnCount;
    }

    protected int convertIndexToColumn(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        if (((PaletteList)this.list).getAlignStyle() == 1) {
            return this.mRowCount <= 0 ? -1 : n / this.mRowCount;
        }
        return this.mColumnCount <= 0 ? -1 : n % this.mColumnCount;
    }

    protected int convertCellToIndex(int n, int n2) {
        if (n < 0 || n >= this.mColumnCount || n2 < 0 || n2 >= this.mRowCount) {
            return -1;
        }
        int n3 = ((PaletteList)this.list).getAlignStyle() == 1 ? n * this.mRowCount + n2 : n2 * this.mColumnCount + n;
        return n3 < this.list.getModel().getSize() ? n3 : -1;
    }

    protected int convertYToRow(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.cellHeight == 0 ? -1 : (n - this.list.getInsets().top) / this.cellHeight;
        return n2 >= 0 && n2 < this.mRowCount ? n2 : -1;
    }

    protected int convertXToColumn(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.cellWidth == 0 ? -1 : (n - this.list.getInsets().left) / this.cellWidth;
        return n2 >= 0 && n2 < this.mColumnCount ? n2 : -1;
    }

    protected int convertRowToY(int n) {
        if (n < 0 || n >= this.mRowCount) {
            return -1;
        }
        return this.list.getInsets().top + n * this.cellHeight;
    }

    protected int convertColumnToX(int n) {
        if (n < 0 || n >= this.mColumnCount) {
            return -1;
        }
        return this.list.getInsets().left + n * this.cellWidth;
    }

    protected boolean isOnCheckBox(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = this.cellWidth == 0 ? -1 : (n - this.list.getInsets().left) % this.cellWidth;
        return n2 >= 0 && n2 < this.mCheckBoxSize;
    }

    protected void maybeUpdateLayoutState() {
        int n;
        int n2 = n = ((PaletteList)this.list).getAlignStyle() == 1 ? this.list.getHeight() : this.list.getWidth();
        if (this.mLastDimension != n) {
            this.mLastDimension = n;
            this.updateLayoutState();
        } else {
            super.maybeUpdateLayoutState();
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        this.cellWidth = n2 != -1 ? n2 : -1;
        this.cellHeight = n != -1 ? n : -1;
        this.cellHeight = n != -1 ? n : -1;
        this.cellHeight = n2 != -1 ? n2 : -1;
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n3 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                for (int i = 0; i < n3; ++i) {
                    Object e = listModel.getElementAt(i);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n != -1) continue;
                    this.cellHeight = Math.max(dimension.height, this.cellHeight);
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeight == -1) {
                    this.cellHeight = 0;
                }
            }
        }
        if (this.updateAlignment()) {
            this.list.revalidate();
        } else {
            this.list.invalidate();
        }
    }

    private boolean updateAlignment() {
        int n = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (((PaletteList)this.list).getAlignStyle() == 1) {
            int n2 = this.list.getHeight() - (insets.top + insets.bottom);
            this.mRowCount = this.cellHeight <= 0 ? 0 : (n2 < this.cellHeight ? 1 : n2 / this.cellHeight);
            this.mRowCount = Math.min(n, this.mRowCount);
            int n3 = this.mColumnCount;
            this.mColumnCount = this.mRowCount == 0 ? 0 : (n + this.mRowCount - 1) / this.mRowCount;
            return n3 != this.mColumnCount;
        }
        int n4 = this.list.getWidth() - (insets.left + insets.right);
        this.mColumnCount = this.cellWidth <= 0 ? 0 : (n4 < this.cellWidth ? 1 : n4 / this.cellWidth);
        this.mColumnCount = Math.min(n, this.mColumnCount);
        int n5 = this.mRowCount;
        this.mRowCount = this.mColumnCount == 0 ? 0 : (n + this.mColumnCount - 1) / this.mColumnCount;
        return n5 != this.mRowCount;
    }

    protected MouseInputListener createMouseInputListener() {
        return new AlignedListMouseInputHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new AlignedListSelectionHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return new AlignedListDataHandler();
    }

    private void repaintList(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n = n == -1 ? 0 : n;
        int n7 = n2 = n2 == -1 ? this.list.getModel().getSize() - 1 : n2;
        if (((PaletteList)this.list).getAlignStyle() == 1) {
            n3 = Math.max(0, this.convertColumnToX(this.convertIndexToColumn(n)));
            int n8 = this.convertIndexToColumn(n2);
            n5 = Math.min(this.list.getWidth(), this.convertColumnToX(n8) + this.getColumnWidth(n8)) - n3;
            n6 = this.list.getHeight();
        } else {
            n4 = Math.max(0, this.convertRowToY(this.convertIndexToRow(n)));
            int n9 = this.convertIndexToRow(n2);
            n6 = Math.min(this.list.getHeight(), this.convertRowToY(n9) + this.getRowHeight(n9)) - n4;
            n5 = this.list.getWidth();
        }
        this.list.revalidate();
        this.list.repaint(n3, n4, n5, n6);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new AlignedListPropertyChangeHandler();
    }

    public class AlignedListPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public AlignedListPropertyChangeHandler() {
            super(PaletteListUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("rolloverIndex")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                int n2 = (Integer)propertyChangeEvent.getOldValue();
                PaletteListUI.this.repaintList(Math.min(n, n2), Math.max(n, n2));
            } else if (string.equals("alignStyle")) {
                PaletteListUI.this.redrawList();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    public class AlignedListDataHandler
    extends BasicListUI.ListDataHandler {
        public AlignedListDataHandler() {
            super(PaletteListUI.this);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            PaletteListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = PaletteListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n, true);
            }
            PaletteListUI.this.repaintList(n, PaletteListUI.this.list.getModel().getSize() - 1);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            PaletteListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = PaletteListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
            PaletteListUI.this.repaintList(Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1()), PaletteListUI.this.list.getModel().getSize() - 1);
        }
    }

    public class AlignedListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PaletteListUI.this.maybeUpdateLayoutState();
            PaletteListUI.this.repaintList(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
        }
    }

    public class AlignedListMouseInputHandler
    extends BasicListUI.MouseInputHandler {
        public AlignedListMouseInputHandler() {
            super(PaletteListUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!PaletteListUI.this.list.isEnabled()) {
                return;
            }
            if (!PaletteListUI.this.list.hasFocus()) {
                PaletteListUI.this.list.requestFocus();
            }
            if ((n = PaletteListUI.this.convertCellToIndex(PaletteListUI.this.convertXToColumn(mouseEvent.getX()), PaletteListUI.this.convertYToRow(mouseEvent.getY()))) != -1) {
                PaletteListUI.this.list.setValueIsAdjusting(true);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseEntered(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!PaletteListUI.this.list.isEnabled()) {
                return;
            }
            ((PaletteList)PaletteListUI.this.list).setRolloverIndex(PaletteListUI.this.locationToIndex(PaletteListUI.this.list, mouseEvent.getPoint()));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!PaletteListUI.this.list.isEnabled()) {
                return;
            }
            ((PaletteList)PaletteListUI.this.list).setRolloverIndex(-1);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = PaletteListUI.this.convertCellToIndex(PaletteListUI.this.convertXToColumn(mouseEvent.getX()), PaletteListUI.this.convertYToRow(mouseEvent.getY()));
            if (n < 0) {
                return;
            }
            if (PaletteListUI.this.isOnCheckBox(mouseEvent.getX())) {
                ((PaletteList)PaletteListUI.this.list).setCheckedItem(n);
            } else {
                int n2 = ((PaletteList)PaletteListUI.this.list).getCurSelectedIndex();
                ((PaletteList)PaletteListUI.this.list).setCurSelectedIndex(n);
                if (n2 != n) {
                    PaletteListUI.this.repaintList(n2, n2);
                }
                PaletteListUI.this.repaintList(n, n);
            }
            PaletteListUI.this.list.setValueIsAdjusting(false);
        }
    }
}

