/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;

@JRubyClass(name={"Array"})
public class RubyArray
extends RubyObject
implements List {
    private static ObjectAllocator ARRAY_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyArray(ruby, rubyClass);
        }
    };
    public static final int ARRAY_DEFAULT_SIZE = 16;
    private IRubyObject[] values;
    private static final int TMPLOCK_ARR_F = 512;
    private static final int TMPLOCK_OR_FROZEN_ARR_F = 516;
    private volatile boolean isShared = false;
    private int begin = 0;
    private int realLength = 0;

    public static RubyClass createArrayClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Array", ruby.getObject(), ARRAY_ALLOCATOR);
        ruby.setArray(rubyClass);
        rubyClass.index = 3;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyArray;
            }
        };
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyArray.class);
        return rubyClass;
    }

    public int getNativeTypeIndex() {
        return 3;
    }

    @JRubyMethod(name={"[]"}, rest=true, frame=true, meta=true)
    public static IRubyObject create(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyArray rubyArray = (RubyArray)((RubyClass)iRubyObject).allocate();
        rubyArray.callInit(IRubyObject.NULL_ARRAY, block);
        if (iRubyObjectArray.length > 0) {
            rubyArray.alloc(iRubyObjectArray.length);
            System.arraycopy(iRubyObjectArray, 0, rubyArray.values, 0, iRubyObjectArray.length);
            rubyArray.realLength = iRubyObjectArray.length;
        }
        return rubyArray;
    }

    public static final RubyArray newArray(Ruby ruby, long l) {
        return new RubyArray(ruby, l);
    }

    public static final RubyArray newArrayLight(Ruby ruby, long l) {
        return new RubyArray(ruby, l, false);
    }

    public static final RubyArray newArray(Ruby ruby) {
        return new RubyArray(ruby, 16L);
    }

    public static final RubyArray newArrayLight(Ruby ruby) {
        RubyArray rubyArray = new RubyArray(ruby, false);
        rubyArray.alloc(16);
        return rubyArray;
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject iRubyObject) {
        return new RubyArray(ruby, new IRubyObject[]{iRubyObject});
    }

    public static RubyArray newArrayLight(Ruby ruby, IRubyObject iRubyObject) {
        return new RubyArray(ruby, new IRubyObject[]{iRubyObject}, false);
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return new RubyArray(ruby, new IRubyObject[]{iRubyObject, iRubyObject2});
    }

    public static RubyArray newEmptyArray(Ruby ruby) {
        return new RubyArray(ruby, NULL_ARRAY);
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray = new RubyArray(ruby, iRubyObjectArray.length);
        System.arraycopy(iRubyObjectArray, 0, rubyArray.values, 0, iRubyObjectArray.length);
        rubyArray.realLength = iRubyObjectArray.length;
        return rubyArray;
    }

    public static RubyArray newArrayNoCopy(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        return new RubyArray(ruby, iRubyObjectArray);
    }

    public static RubyArray newArrayNoCopy(Ruby ruby, IRubyObject[] iRubyObjectArray, int n) {
        return new RubyArray(ruby, iRubyObjectArray, n);
    }

    public static RubyArray newArrayNoCopyLight(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray = new RubyArray(ruby, false);
        rubyArray.values = iRubyObjectArray;
        rubyArray.realLength = iRubyObjectArray.length;
        return rubyArray;
    }

    public static RubyArray newArray(Ruby ruby, Collection collection) {
        RubyArray rubyArray = new RubyArray(ruby, collection.size());
        collection.toArray(rubyArray.values);
        rubyArray.realLength = rubyArray.values.length;
        return rubyArray;
    }

    private RubyArray(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        super(ruby, ruby.getArray());
        this.values = iRubyObjectArray;
        this.realLength = iRubyObjectArray.length;
    }

    private RubyArray(Ruby ruby, IRubyObject[] iRubyObjectArray, boolean bl) {
        super(ruby, ruby.getArray(), bl);
        this.values = iRubyObjectArray;
        this.realLength = iRubyObjectArray.length;
    }

    private RubyArray(Ruby ruby, IRubyObject[] iRubyObjectArray, int n) {
        super(ruby, ruby.getArray());
        this.values = iRubyObjectArray;
        this.begin = n;
        this.realLength = iRubyObjectArray.length - n;
        this.isShared = true;
    }

    private RubyArray(Ruby ruby, long l) {
        super(ruby, ruby.getArray());
        this.checkLength(l);
        this.alloc((int)l);
    }

    private RubyArray(Ruby ruby, long l, boolean bl) {
        super(ruby, ruby.getArray(), bl);
        this.checkLength(l);
        this.alloc((int)l);
    }

    public RubyArray(Ruby ruby, long l, IRubyObject[] iRubyObjectArray) {
        super(ruby, ruby.getArray());
        this.checkLength(l);
        int n = (int)l;
        this.alloc(n);
        if (n > 0 && iRubyObjectArray.length > 0) {
            System.arraycopy(iRubyObjectArray, 0, this.values, 0, n);
        }
        this.realLength = n;
    }

    private RubyArray(Ruby ruby, boolean bl) {
        super(ruby, ruby.getArray(), bl);
    }

    private RubyArray(Ruby ruby) {
        super(ruby, ruby.getArray());
        this.alloc(16);
    }

    public RubyArray(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.alloc(16);
    }

    private RubyArray(Ruby ruby, RubyClass rubyClass, int n) {
        super(ruby, rubyClass);
        this.alloc(n);
    }

    private RubyArray(Ruby ruby, RubyClass rubyClass, long l) {
        super(ruby, rubyClass);
        this.checkLength(l);
        this.alloc((int)l);
    }

    private RubyArray(Ruby ruby, RubyClass rubyClass, long l, boolean bl) {
        super(ruby, rubyClass, bl);
        this.checkLength(l);
        this.alloc((int)l);
    }

    private RubyArray(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, rubyClass, bl);
    }

    private RubyArray(Ruby ruby, RubyClass rubyClass, RubyArray rubyArray) {
        super(ruby, rubyClass);
        this.realLength = rubyArray.realLength;
        this.alloc(this.realLength);
        System.arraycopy(rubyArray.values, rubyArray.begin, this.values, 0, this.realLength);
    }

    private final IRubyObject[] reserve(int n) {
        return new IRubyObject[n];
    }

    private final void alloc(int n) {
        this.values = new IRubyObject[n];
    }

    private final void realloc(int n) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        System.arraycopy(this.values, 0, iRubyObjectArray, 0, n > this.realLength ? this.realLength : n);
        this.values = iRubyObjectArray;
    }

    private final void checkLength(long l) {
        if (l < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        if (l >= Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("array size too big");
        }
    }

    public List getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public int getLength() {
        return this.realLength;
    }

    public IRubyObject[] toJavaArray() {
        IRubyObject[] iRubyObjectArray = this.reserve(this.realLength);
        System.arraycopy(this.values, this.begin, iRubyObjectArray, 0, this.realLength);
        return iRubyObjectArray;
    }

    public IRubyObject[] toJavaArrayUnsafe() {
        return !this.isShared ? this.values : this.toJavaArray();
    }

    public IRubyObject[] toJavaArrayMaybeUnsafe() {
        return !this.isShared && this.begin == 0 && this.values.length == this.realLength ? this.values : this.toJavaArray();
    }

    private final RubyArray makeShared(int n, int n2, RubyClass rubyClass) {
        return this.makeShared(n, n2, rubyClass, rubyClass.getRuntime().isObjectSpaceEnabled());
    }

    private final RubyArray makeShared(int n, int n2, RubyClass rubyClass, boolean bl) {
        RubyArray rubyArray = new RubyArray(this.getRuntime(), rubyClass, bl);
        this.isShared = true;
        rubyArray.values = this.values;
        rubyArray.isShared = true;
        rubyArray.begin = n;
        rubyArray.realLength = n2;
        return rubyArray;
    }

    private final void modifyCheck() {
        if ((this.flags & 0x204) != 0) {
            if ((this.flags & 4) != 0) {
                throw this.getRuntime().newFrozenError("array");
            }
            if ((this.flags & 0x200) != 0) {
                throw this.getRuntime().newTypeError("can't modify array during iteration");
            }
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify array");
        }
    }

    private final void modify() {
        this.modifyCheck();
        if (this.isShared) {
            IRubyObject[] iRubyObjectArray = this.reserve(this.realLength);
            this.isShared = false;
            System.arraycopy(this.values, this.begin, iRubyObjectArray, 0, this.realLength);
            this.begin = 0;
            this.values = iRubyObjectArray;
        }
    }

    @JRubyMethod(name={"initialize"}, required=0, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        int n = iRubyObjectArray.length;
        Ruby ruby = this.getRuntime();
        if (n == 0) {
            this.modifyCheck();
            this.realLength = 0;
            if (block.isGiven()) {
                ruby.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
            }
            return this;
        }
        if (n == 1 && !(iRubyObjectArray[0] instanceof RubyFixnum) && !(iRubyObject = iRubyObjectArray[0].checkArrayType()).isNil()) {
            this.replace(iRubyObject);
            return this;
        }
        long l = RubyNumeric.num2long(iRubyObjectArray[0]);
        if (l < 0L) {
            throw ruby.newArgumentError("negative array size");
        }
        if (l >= Integer.MAX_VALUE) {
            throw ruby.newArgumentError("array size too big");
        }
        int n2 = (int)l;
        this.modify();
        if (n2 > this.values.length) {
            this.values = this.reserve(n2);
        }
        if (block.isGiven()) {
            if (n == 2) {
                ruby.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
            }
            for (int i = 0; i < n2; ++i) {
                this.store(i, block.yield(threadContext, new RubyFixnum(ruby, i)));
                this.realLength = i + 1;
            }
        } else {
            Arrays.fill(this.values, 0, n2, n == 2 ? iRubyObjectArray[1] : ruby.getNil());
            this.realLength = n2;
        }
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        return this.replace(iRubyObject);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public IRubyObject replace(IRubyObject iRubyObject) {
        this.modifyCheck();
        RubyArray rubyArray = iRubyObject.convertToArray();
        if (this == iRubyObject) {
            return this;
        }
        rubyArray.isShared = true;
        this.isShared = true;
        this.values = rubyArray.values;
        this.realLength = rubyArray.realLength;
        this.begin = rubyArray.begin;
        return this;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.realLength == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        return this.join(this.getRuntime().getCurrentContext(), this.getRuntime().getGlobalVariables().get("$,"));
    }

    public boolean includes(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n;
        for (int i = n = this.begin; i < n + this.realLength; ++i) {
            if (!RubyArray.equalInternal(threadContext, this.values[i], iRubyObject)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext threadContext) {
        int n;
        int n2 = this.realLength;
        Ruby ruby = this.getRuntime();
        for (int i = n = this.begin; i < n + this.realLength; ++i) {
            n2 = n2 << 1 | (n2 < 0 ? 1 : 0);
            n2 = (int)((long)n2 ^ RubyNumeric.num2long(this.values[i].callMethod(threadContext, MethodIndex.HASH, "hash")));
        }
        return ruby.newFixnum(n2);
    }

    public final IRubyObject store(long l, IRubyObject iRubyObject) {
        if (l < 0L && (l += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (l - (long)this.realLength) + " out of array");
        }
        this.modify();
        if (l >= (long)this.realLength) {
            if (l >= (long)this.values.length) {
                long l2 = this.values.length >> 1;
                if (l2 < 16L) {
                    l2 = 16L;
                }
                if ((l2 += l) >= Integer.MAX_VALUE) {
                    throw this.getRuntime().newArgumentError("index too big");
                }
                this.realloc((int)l2);
            }
            if (l != (long)this.realLength) {
                Arrays.fill(this.values, this.realLength, (int)l + 1, this.getRuntime().getNil());
            }
            this.realLength = (int)l + 1;
        }
        this.values[(int)l] = iRubyObject;
        return iRubyObject;
    }

    private final IRubyObject elt(long l) {
        if (this.emptyOrOutsideRange(l)) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + (int)l];
    }

    private final IRubyObject elt(int n) {
        if (this.emptyOrOutsideRange(n)) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + n];
    }

    private boolean emptyOrOutsideRange(long l) {
        return this.realLength == 0 || l < 0L || l >= (long)this.realLength;
    }

    private final IRubyObject elt_f(long l) {
        if (this.emptyOrTooHigh(l)) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + (int)l];
    }

    private final IRubyObject elt_f(int n) {
        if (this.emptyOrTooHigh(n)) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + n];
    }

    private boolean emptyOrTooHigh(long l) {
        return this.realLength == 0 || l >= (long)this.realLength;
    }

    public final IRubyObject entry(long l) {
        return l < 0L ? this.elt(l + (long)this.realLength) : this.elt_f(l);
    }

    public final IRubyObject entry(int n) {
        return n < 0 ? this.elt(n + this.realLength) : this.elt_f(n);
    }

    public final IRubyObject eltInternal(int n) {
        return this.values[this.begin + n];
    }

    public final IRubyObject eltInternalSet(int n, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = iRubyObject;
        this.values[this.begin + n] = iRubyObject2;
        return iRubyObject2;
    }

    public IRubyObject fetch(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.fetch(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.fetch(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"fetch"}, frame=true)
    public IRubyObject fetch(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        long l = RubyNumeric.num2long(iRubyObject);
        if (l < 0L) {
            l += (long)this.realLength;
        }
        if (l < 0L || l >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(threadContext, iRubyObject);
            }
            throw this.getRuntime().newIndexError("index " + l + " out of array");
        }
        return this.values[this.begin + (int)l];
    }

    @JRubyMethod(name={"fetch"}, frame=true)
    public IRubyObject fetch(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        long l;
        if (block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
        }
        if ((l = RubyNumeric.num2long(iRubyObject)) < 0L) {
            l += (long)this.realLength;
        }
        if (l < 0L || l >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(threadContext, iRubyObject);
            }
            return iRubyObject2;
        }
        return this.values[this.begin + (int)l];
    }

    private static RubyArray aryToAry(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyArray) {
            return (RubyArray)iRubyObject;
        }
        if (iRubyObject.respondsTo("to_ary")) {
            return iRubyObject.convertToArray();
        }
        RubyArray rubyArray = new RubyArray(iRubyObject.getRuntime(), false);
        rubyArray.alloc(1);
        rubyArray.values[0] = iRubyObject;
        rubyArray.realLength = 1;
        return rubyArray;
    }

    private final void splice(long l, long l2, IRubyObject iRubyObject) {
        int n;
        RubyArray rubyArray;
        if (l2 < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + l2 + ")");
        }
        if (l < 0L && (l += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (l -= (long)this.realLength) + " out of array");
        }
        if (iRubyObject == null || iRubyObject.isNil()) {
            rubyArray = null;
            n = 0;
        } else {
            rubyArray = RubyArray.aryToAry(iRubyObject);
            n = rubyArray.realLength;
        }
        this.modify();
        if (l >= (long)this.realLength) {
            l2 = l + (long)n;
            if (l2 >= (long)this.values.length) {
                int n2 = this.values.length + (this.values.length >> 1);
                this.realloc(l2 > (long)n2 ? (int)l2 : n2);
            }
            Arrays.fill(this.values, this.realLength, (int)l, this.getRuntime().getNil());
            this.realLength = (int)l2;
        } else {
            long l3;
            if (l + l2 > (long)this.realLength) {
                l2 = (long)this.realLength - l;
            }
            if ((l3 = (long)(this.realLength + n) - l2) >= (long)this.values.length) {
                int n3 = this.values.length + (this.values.length >> 1);
                this.realloc(l3 > (long)n3 ? (int)l3 : n3);
            }
            if (l2 != (long)n) {
                System.arraycopy(this.values, (int)(l + l2), this.values, (int)l + n, this.realLength - (int)(l + l2));
                this.realLength = (int)l3;
            }
        }
        if (n > 0) {
            System.arraycopy(rubyArray.values, rubyArray.begin, this.values, (int)l, n);
        }
    }

    private final void spliceOne(long l, long l2, IRubyObject iRubyObject) {
        if (l2 < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + l2 + ")");
        }
        if (l < 0L && (l += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (l -= (long)this.realLength) + " out of array");
        }
        this.modify();
        if (l >= (long)this.realLength) {
            l2 = l + 1L;
            if (l2 >= (long)this.values.length) {
                int n = this.values.length + (this.values.length >> 1);
                this.realloc(l2 > (long)n ? (int)l2 : n);
            }
            Arrays.fill(this.values, this.realLength, (int)l, this.getRuntime().getNil());
            this.realLength = (int)l2;
        } else {
            int n;
            if (l + l2 > (long)this.realLength) {
                l2 = (long)this.realLength - l;
            }
            if ((n = this.realLength + 1 - (int)l2) >= this.values.length) {
                int n2 = this.values.length + (this.values.length >> 1);
                this.realloc(n > n2 ? n : n2);
            }
            if (l2 != 1L) {
                System.arraycopy(this.values, (int)(l + l2), this.values, (int)l + 1, this.realLength - (int)(l + l2));
                this.realLength = n;
            }
        }
        this.values[(int)l] = iRubyObject;
    }

    @JRubyMethod
    public IRubyObject insert(IRubyObject iRubyObject) {
        return this;
    }

    @JRubyMethod
    public IRubyObject insert(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        long l = RubyNumeric.num2long(iRubyObject);
        if (l == -1L) {
            l = this.realLength;
        }
        if (l < 0L) {
            ++l;
        }
        this.spliceOne(l, 0L, iRubyObject2);
        return this;
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true)
    public IRubyObject insert(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1) {
            return this;
        }
        long l = RubyNumeric.num2long(iRubyObjectArray[0]);
        if (l == -1L) {
            l = this.realLength;
        }
        if (l < 0L) {
            ++l;
        }
        RubyArray rubyArray = new RubyArray(this.getRuntime(), false);
        rubyArray.values = iRubyObjectArray;
        rubyArray.begin = 1;
        rubyArray.realLength = iRubyObjectArray.length - 1;
        this.splice(l, 0L, rubyArray);
        return this;
    }

    public final RubyArray aryDup() {
        RubyArray rubyArray = new RubyArray(this.getRuntime(), this.getMetaClass(), this);
        rubyArray.flags |= this.flags & 8;
        return rubyArray;
    }

    @JRubyMethod(name={"transpose"})
    public RubyArray transpose() {
        RubyArray rubyArray = null;
        int n = this.realLength;
        if (n == 0) {
            return this.aryDup();
        }
        Ruby ruby = this.getRuntime();
        int n2 = -1;
        int n3 = this.begin + n;
        for (int i = this.begin; i < n3; ++i) {
            int n4;
            RubyArray rubyArray2 = this.elt(i).convertToArray();
            if (n2 < 0) {
                n2 = rubyArray2.realLength;
                rubyArray = new RubyArray(ruby, n2);
                for (n4 = 0; n4 < n2; ++n4) {
                    rubyArray.store(n4, new RubyArray(ruby, n));
                }
            } else if (n2 != rubyArray2.realLength) {
                throw ruby.newIndexError("element size differs (" + rubyArray2.realLength + " should be " + n2 + ")");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                ((RubyArray)rubyArray.elt(n4)).store(i - this.begin, rubyArray2.elt(n4));
            }
        }
        return rubyArray;
    }

    private final IRubyObject values_at(long l, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray = new RubyArray(this.getRuntime(), iRubyObjectArray.length);
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i] instanceof RubyFixnum) {
                rubyArray.append(this.entry(((RubyFixnum)iRubyObjectArray[i]).getLongValue()));
                continue;
            }
            if (iRubyObjectArray[i] instanceof RubyRange) {
                long[] lArray = ((RubyRange)iRubyObjectArray[i]).begLen(l, 0);
                if (lArray == null) continue;
                int n = (int)lArray[0];
                int n2 = (int)lArray[1];
                int n3 = this.begin + n2;
                for (int j = this.begin; j < n3; ++j) {
                    rubyArray.append(this.entry(j + n));
                }
                continue;
            }
            rubyArray.append(this.entry(RubyNumeric.num2long(iRubyObjectArray[i])));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(IRubyObject[] iRubyObjectArray) {
        return this.values_at(this.realLength, iRubyObjectArray);
    }

    public IRubyObject subseq(long l, long l2) {
        if (l > (long)this.realLength || l < 0L || l2 < 0L) {
            return this.getRuntime().getNil();
        }
        if (l + l2 > (long)this.realLength && (l2 = (long)this.realLength - l) < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0);
        }
        return this.makeShared(this.begin + (int)l, (int)l2, this.getMetaClass());
    }

    public IRubyObject subseqLight(long l, long l2) {
        if (l > (long)this.realLength || l < 0L || l2 < 0L) {
            return this.getRuntime().getNil();
        }
        if (l + l2 > (long)this.realLength && (l2 = (long)this.realLength - l) < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0L, false);
        }
        return this.makeShared(this.begin + (int)l, (int)l2, this.getMetaClass(), false);
    }

    @JRubyMethod(name={"length"}, alias={"size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.realLength);
    }

    @JRubyMethod(name={"<<"}, required=1)
    public RubyArray append(IRubyObject iRubyObject) {
        this.modify();
        if (this.realLength == this.values.length) {
            if (this.realLength == Integer.MAX_VALUE) {
                throw this.getRuntime().newArgumentError("index too big");
            }
            long l = this.values.length + (this.values.length >> 1);
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            } else if (l < 16L) {
                l = 16L;
            }
            this.realloc((int)l);
        }
        this.values[this.realLength++] = iRubyObject;
        return this;
    }

    @JRubyMethod(name={"push"}, rest=true)
    public RubyArray push_m(IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.append(iRubyObjectArray[i]);
        }
        return this;
    }

    @JRubyMethod(name={"pop"})
    public IRubyObject pop() {
        this.modifyCheck();
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        if (!this.isShared) {
            int n = this.begin + --this.realLength;
            IRubyObject iRubyObject = this.values[n];
            this.values[n] = null;
            return iRubyObject;
        }
        return this.values[this.begin + --this.realLength];
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift() {
        this.modify();
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        IRubyObject iRubyObject = this.values[this.begin];
        this.values[this.begin] = null;
        this.isShared = true;
        ++this.begin;
        --this.realLength;
        return iRubyObject;
    }

    public RubyArray unshift(IRubyObject iRubyObject) {
        this.modify();
        if (this.realLength == this.values.length) {
            int n = this.values.length >> 1;
            if (n < 16) {
                n = 16;
            }
            this.realloc(n += this.values.length);
        }
        System.arraycopy(this.values, 0, this.values, 1, this.realLength);
        ++this.realLength;
        this.values[0] = iRubyObject;
        return this;
    }

    @JRubyMethod(name={"unshift"}, rest=true)
    public RubyArray unshift_m(IRubyObject[] iRubyObjectArray) {
        long l = this.realLength;
        if (iRubyObjectArray.length == 0) {
            return this;
        }
        this.store(l + (long)iRubyObjectArray.length - 1L, this.getRuntime().getNil());
        System.arraycopy(this.values, 0, this.values, iRubyObjectArray.length, (int)l);
        System.arraycopy(iRubyObjectArray, 0, this.values, 0, iRubyObjectArray.length);
        return this;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getRuntime().newBoolean(this.includes(threadContext, iRubyObject));
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.isFrozen() || (this.flags & 0x200) != 0);
    }

    public IRubyObject aref(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.aref(iRubyObjectArray[0]);
            }
            case 2: {
                return this.aref(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.entry(((RubyFixnum)iRubyObject).getLongValue());
        }
        if (iRubyObject instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        if (iRubyObject instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObject).begLen(this.realLength, 0);
            if (lArray == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(lArray[0], lArray[1]);
        }
        return this.entry(RubyNumeric.num2long(iRubyObject));
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        long l = RubyNumeric.num2long(iRubyObject);
        if (l < 0L) {
            l += (long)this.realLength;
        }
        return this.subseq(l, RubyNumeric.num2long(iRubyObject2));
    }

    public IRubyObject aset(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 2: {
                return this.aset(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.aset(iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        throw this.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + " for 2)");
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum) {
            this.store(((RubyFixnum)iRubyObject).getLongValue(), iRubyObject2);
            return iRubyObject2;
        }
        if (iRubyObject instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObject).begLen(this.realLength, 1);
            this.splice(lArray[0], lArray[1], iRubyObject2);
            return iRubyObject2;
        }
        if (iRubyObject instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        this.store(RubyNumeric.num2long(iRubyObject), iRubyObject2);
        return iRubyObject2;
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (iRubyObject instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        if (iRubyObject2 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as subarray length");
        }
        this.splice(RubyNumeric.num2long(iRubyObject), RubyNumeric.num2long(iRubyObject2), iRubyObject3);
        return iRubyObject3;
    }

    @JRubyMethod(name={"at"}, required=1)
    public IRubyObject at(IRubyObject iRubyObject) {
        return this.entry(RubyNumeric.num2long(iRubyObject));
    }

    @JRubyMethod(name={"concat"}, required=1)
    public RubyArray concat(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.convertToArray();
        if (rubyArray.realLength > 0) {
            this.splice(this.realLength, 0L, rubyArray);
        }
        return this;
    }

    private IRubyObject inspectAry(ThreadContext threadContext) {
        ByteList byteList = new ByteList();
        byteList.append(91);
        boolean bl = this.isTaint();
        for (int i = 0; i < this.realLength; ++i) {
            RubyString rubyString;
            if (i > 0) {
                byteList.append(44).append(32);
            }
            if ((rubyString = RubyArray.inspect(threadContext, this.values[this.begin + i])).isTaint()) {
                bl = true;
            }
            byteList.append(rubyString.getByteList());
        }
        byteList.append(93);
        RubyString rubyString = this.getRuntime().newString(byteList);
        if (bl) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.realLength == 0) {
            return this.getRuntime().newString("[]");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("[...]");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectAry(this.getRuntime().getCurrentContext());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public IRubyObject first(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.first(iRubyObjectArray[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin];
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(IRubyObject iRubyObject) {
        long l = RubyNumeric.num2long(iRubyObject);
        if (l > (long)this.realLength) {
            l = this.realLength;
        } else if (l < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin, (int)l, this.getRuntime().getArray());
    }

    public IRubyObject last(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.last();
            }
            case 1: {
                return this.last(iRubyObjectArray[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + this.realLength - 1];
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(IRubyObject iRubyObject) {
        long l = RubyNumeric.num2long(iRubyObject);
        if (l > (long)this.realLength) {
            l = this.realLength;
        } else if (l < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin + this.realLength - (int)l, (int)l, this.getRuntime().getArray());
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext threadContext, Block block) {
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(threadContext, this.values[this.begin + i]);
        }
        return this;
    }

    @JRubyMethod(name={"each_index"}, frame=true)
    public IRubyObject each_index(ThreadContext threadContext, Block block) {
        Ruby ruby = this.getRuntime();
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(threadContext, ruby.newFixnum(i));
        }
        return this;
    }

    @JRubyMethod(name={"reverse_each"}, frame=true)
    public IRubyObject reverse_each(ThreadContext threadContext, Block block) {
        int n = this.realLength;
        while (n-- > 0) {
            block.yield(threadContext, this.values[this.begin + n]);
            if (this.realLength >= n) continue;
            n = this.realLength;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectJoin(ThreadContext threadContext, RubyArray rubyArray, IRubyObject iRubyObject) {
        Ruby ruby = this.getRuntime();
        if (ruby.isInspecting(this)) {
            return rubyArray.join(threadContext, iRubyObject);
        }
        try {
            ruby.registerInspecting(this);
            RubyString rubyString = rubyArray.join(threadContext, iRubyObject);
            return rubyString;
        }
        finally {
            ruby.unregisterInspecting(this);
        }
    }

    public RubyString join(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        if (this.realLength == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        boolean bl = this.isTaint() || iRubyObject.isTaint();
        long l = 1L;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            iRubyObject2 = this.values[i].checkStringType();
            l += iRubyObject2.isNil() ? 10L : (long)((RubyString)iRubyObject2).getByteList().length();
        }
        RubyString rubyString = null;
        if (!iRubyObject.isNil()) {
            rubyString = iRubyObject.convertToString();
            iRubyObject = rubyString;
            l += (long)(rubyString.getByteList().length() * (this.realLength - 1));
        }
        iRubyObject2 = new ByteList((int)l);
        Ruby ruby = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject iRubyObject3 = this.values[i];
            if (!(iRubyObject3 instanceof RubyString)) {
                iRubyObject3 = iRubyObject3 instanceof RubyArray ? (ruby.isInspecting(iRubyObject3) ? ruby.newString("[...]") : this.inspectJoin(threadContext, (RubyArray)iRubyObject3, iRubyObject)) : RubyString.objAsString(threadContext, iRubyObject3);
            }
            if (i > this.begin && !iRubyObject.isNil()) {
                iRubyObject2.append(rubyString.getByteList());
            }
            iRubyObject2.append(iRubyObject3.asString().getByteList());
            if (!iRubyObject3.isTaint()) continue;
            bl = true;
        }
        RubyString rubyString2 = ruby.newString((ByteList)iRubyObject2);
        if (bl) {
            rubyString2.setTaint(true);
        }
        return rubyString2;
    }

    @JRubyMethod(name={"join"}, optional=1)
    public RubyString join_m(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        int n = iRubyObjectArray.length;
        IRubyObject iRubyObject = n == 1 ? iRubyObjectArray[0] : this.getRuntime().getGlobalVariables().get("$,");
        return this.join(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        if (this.getMetaClass() != this.getRuntime().getArray()) {
            RubyArray rubyArray = new RubyArray(this.getRuntime(), this.getRuntime().isObjectSpaceEnabled());
            this.isShared = true;
            rubyArray.isShared = true;
            rubyArray.values = this.values;
            rubyArray.realLength = this.realLength;
            rubyArray.begin = this.begin;
            return rubyArray;
        }
        return this;
    }

    @JRubyMethod(name={"to_ary"})
    public IRubyObject to_ary() {
        return this;
    }

    public RubyArray convertToArray() {
        return this;
    }

    public IRubyObject checkArrayType() {
        return this;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyArray)) {
            if (!iRubyObject.respondsTo("to_ary")) {
                return this.getRuntime().getFalse();
            }
            if (RubyArray.equalInternal(threadContext, iRubyObject.callMethod(threadContext, "to_ary"), this)) {
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        RubyArray rubyArray = (RubyArray)iRubyObject;
        if (this.realLength != rubyArray.realLength) {
            return this.getRuntime().getFalse();
        }
        Ruby ruby = this.getRuntime();
        for (long i = 0L; i < (long)this.realLength; ++i) {
            if (RubyArray.equalInternal(threadContext, this.elt(i), rubyArray.elt(i))) continue;
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public RubyBoolean eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        RubyArray rubyArray = (RubyArray)iRubyObject;
        if (this.realLength != rubyArray.realLength) {
            return this.getRuntime().getFalse();
        }
        Ruby ruby = this.getRuntime();
        for (int i = 0; i < this.realLength; ++i) {
            if (RubyArray.eqlInternal(threadContext, this.elt(i), rubyArray.elt(i))) continue;
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang() {
        this.modify();
        int n = 0;
        int n2 = 0;
        int n3 = n + this.realLength;
        while (n2 < n3) {
            if (this.values[n2].isNil()) {
                ++n2;
                continue;
            }
            this.values[n++] = this.values[n2++];
        }
        if (this.realLength == n) {
            return this.getRuntime().getNil();
        }
        this.realloc(n);
        this.realLength = n;
        return this;
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact() {
        RubyArray rubyArray = this.aryDup();
        rubyArray.compact_bang();
        return rubyArray;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p() {
        return this.realLength == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear() {
        this.modifyCheck();
        if (this.isShared) {
            this.alloc(16);
            this.isShared = true;
        } else if (this.values.length > 32) {
            this.alloc(32);
        } else {
            for (int i = 0; i < this.realLength; ++i) {
                this.values[this.begin + i] = null;
            }
        }
        this.begin = 0;
        this.realLength = 0;
        return this;
    }

    @JRubyMethod(name={"fill"}, optional=3, frame=true)
    public IRubyObject fill(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        Object object;
        IRubyObject iRubyObject = null;
        IRubyObject iRubyObject2 = null;
        IRubyObject iRubyObject3 = null;
        int n = iRubyObjectArray.length;
        if (block.isGiven()) {
            Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 0, 2);
            iRubyObject = null;
            iRubyObject2 = n > 0 ? iRubyObjectArray[0] : null;
            iRubyObject3 = n > 1 ? iRubyObjectArray[1] : null;
            ++n;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 1, 3);
            iRubyObject = iRubyObjectArray[0];
            iRubyObject2 = n > 1 ? iRubyObjectArray[1] : null;
            iRubyObject3 = n > 2 ? iRubyObjectArray[2] : null;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 1: {
                n2 = 0;
                n4 = this.realLength;
                break;
            }
            case 2: {
                if (iRubyObject2 instanceof RubyRange) {
                    object = ((RubyRange)iRubyObject2).begLen(this.realLength, 1);
                    n2 = (int)object[0];
                    n4 = (int)object[1];
                    break;
                }
            }
            case 3: {
                int n5 = n2 = iRubyObject2.isNil() ? 0 : RubyNumeric.num2int(iRubyObject2);
                if (n2 < 0 && (n2 = this.realLength + n2) < 0) {
                    n2 = 0;
                }
                n4 = iRubyObject3 == null || iRubyObject3.isNil() ? this.realLength - n2 : RubyNumeric.num2int(iRubyObject3);
            }
        }
        this.modify();
        if (n4 < 0) {
            return this;
        }
        if (n4 > Integer.MAX_VALUE - n2) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        n3 = n2 + n4;
        if (n3 > this.realLength) {
            if (n3 >= this.values.length) {
                this.realloc(n3);
            }
            Arrays.fill(this.values, this.realLength, n3, this.getRuntime().getNil());
            this.realLength = n3;
        }
        if (block.isGiven()) {
            object = this.getRuntime();
            for (int i = n2; i < n3; ++i) {
                IRubyObject iRubyObject4 = block.yield(threadContext, ((Ruby)object).newFixnum(i));
                if (i < this.realLength) {
                    this.values[i] = iRubyObject4;
                    continue;
                }
                break;
            }
        } else if (n4 > 0) {
            Arrays.fill(this.values, n2, n2 + n4, iRubyObject);
        }
        return this;
    }

    @JRubyMethod(name={"index"}, required=1)
    public IRubyObject index(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!RubyArray.equalInternal(threadContext, this.values[i], iRubyObject)) continue;
            return ruby.newFixnum(i - this.begin);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"rindex"}, required=1)
    public IRubyObject rindex(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = this.getRuntime();
        int n = this.realLength;
        while (n-- > 0) {
            if (n > this.realLength) {
                n = this.realLength;
                continue;
            }
            if (!RubyArray.equalInternal(threadContext, this.values[this.begin + n], iRubyObject)) continue;
            return this.getRuntime().newFixnum(n);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"indexes", "indices"}, required=1, rest=true)
    public IRubyObject indexes(IRubyObject[] iRubyObjectArray) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Array#indexes is deprecated; use Array#values_at", "Array#indexes", "Array#values_at");
        RubyArray rubyArray = new RubyArray(this.getRuntime(), iRubyObjectArray.length);
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            iRubyObjectArray2[0] = iRubyObjectArray[i];
            rubyArray.append(this.aref(iRubyObjectArray2));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"reverse!"})
    public IRubyObject reverse_bang() {
        this.modify();
        if (this.realLength > 1) {
            int n = 0;
            int n2 = n + this.realLength - 1;
            while (n < n2) {
                IRubyObject iRubyObject = this.values[n];
                this.values[n++] = this.values[n2];
                this.values[n2--] = iRubyObject;
            }
        }
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public IRubyObject reverse() {
        return this.aryDup().reverse_bang();
    }

    @JRubyMethod(name={"collect", "map"}, frame=true)
    public RubyArray collect(ThreadContext threadContext, Block block) {
        Ruby ruby = this.getRuntime();
        if (!block.isGiven()) {
            return new RubyArray(this.getRuntime(), ruby.getArray(), this);
        }
        RubyArray rubyArray = new RubyArray(ruby, this.realLength);
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            rubyArray.append(block.yield(threadContext, this.values[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"collect!", "map!"}, frame=true)
    public RubyArray collect_bang(ThreadContext threadContext, Block block) {
        this.modify();
        int n = this.realLength;
        for (int i = 0; i < n; ++i) {
            this.store(i, block.yield(threadContext, this.values[this.begin + i]));
        }
        return this;
    }

    @JRubyMethod(name={"select"}, frame=true)
    public RubyArray select(ThreadContext threadContext, Block block) {
        Ruby ruby = this.getRuntime();
        RubyArray rubyArray = new RubyArray(ruby, this.realLength);
        if (this.isShared) {
            for (int i = this.begin; i < this.begin + this.realLength; ++i) {
                if (!block.yield(threadContext, this.values[i]).isTrue()) continue;
                rubyArray.append(this.elt(i - this.begin));
            }
        } else {
            for (int i = 0; i < this.realLength; ++i) {
                if (!block.yield(threadContext, this.values[i]).isTrue()) continue;
                rubyArray.append(this.elt(i));
            }
        }
        return rubyArray;
    }

    @JRubyMethod(name={"delete"}, required=1, frame=true)
    public IRubyObject delete(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        int n;
        int n2 = 0;
        Ruby ruby = this.getRuntime();
        for (n = 0; n < this.realLength; ++n) {
            IRubyObject iRubyObject2 = this.values[this.begin + n];
            if (RubyArray.equalInternal(threadContext, iRubyObject2, iRubyObject)) continue;
            if (n != n2) {
                this.store(n2, iRubyObject2);
            }
            ++n2;
        }
        if (this.realLength == n2) {
            if (block.isGiven()) {
                return block.yield(threadContext, iRubyObject);
            }
            return ruby.getNil();
        }
        this.modify();
        if (this.realLength > n2) {
            for (n = n2; n < this.realLength; ++n) {
                this.values[this.begin + n] = null;
            }
            this.realLength = n2;
            if (n2 << 1 < this.values.length && this.values.length > 16) {
                this.realloc(n2 << 1);
            }
        }
        return iRubyObject;
    }

    private final IRubyObject delete_at(int n) {
        int n2 = this.realLength;
        if (n >= n2) {
            return this.getRuntime().getNil();
        }
        if (n < 0) {
            n += n2;
        }
        if (n < 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        IRubyObject iRubyObject = this.values[n];
        System.arraycopy(this.values, n + 1, this.values, n, n2 - (n + 1));
        --this.realLength;
        this.values[this.realLength] = null;
        return iRubyObject;
    }

    @JRubyMethod(name={"delete_at"}, required=1)
    public IRubyObject delete_at(IRubyObject iRubyObject) {
        return this.delete_at((int)RubyNumeric.num2long(iRubyObject));
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public IRubyObject reject(ThreadContext threadContext, Block block) {
        RubyArray rubyArray = this.aryDup();
        rubyArray.reject_bang(threadContext, block);
        return rubyArray;
    }

    @JRubyMethod(name={"reject!"}, frame=true)
    public IRubyObject reject_bang(ThreadContext threadContext, Block block) {
        int n;
        int n2 = 0;
        this.modify();
        for (n = 0; n < this.realLength; ++n) {
            IRubyObject iRubyObject = this.values[n];
            if (block.yield(threadContext, iRubyObject).isTrue()) continue;
            if (n != n2) {
                this.store(n2, iRubyObject);
            }
            ++n2;
        }
        if (this.realLength == n2) {
            return this.getRuntime().getNil();
        }
        if (n2 < this.realLength) {
            for (n = n2; n < this.realLength; ++n) {
                this.values[n] = null;
            }
            this.realLength = n2;
        }
        return this;
    }

    @JRubyMethod(name={"delete_if"}, frame=true)
    public IRubyObject delete_if(ThreadContext threadContext, Block block) {
        this.reject_bang(threadContext, block);
        return this;
    }

    @JRubyMethod(name={"zip"}, optional=1, rest=true, frame=true)
    public IRubyObject zip(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            iRubyObjectArray[i] = iRubyObjectArray[i].convertToArray();
        }
        Ruby ruby = this.getRuntime();
        if (block.isGiven()) {
            for (int i = 0; i < this.realLength; ++i) {
                RubyArray rubyArray = new RubyArray(ruby, iRubyObjectArray.length + 1);
                rubyArray.append(this.elt(i));
                for (int j = 0; j < iRubyObjectArray.length; ++j) {
                    rubyArray.append(((RubyArray)iRubyObjectArray[j]).elt(i));
                }
                block.yield(threadContext, rubyArray);
            }
            return ruby.getNil();
        }
        int n = this.realLength;
        RubyArray rubyArray = new RubyArray(ruby, n);
        for (int i = 0; i < n; ++i) {
            RubyArray rubyArray2 = new RubyArray(ruby, iRubyObjectArray.length + 1);
            rubyArray2.append(this.elt(i));
            for (int j = 0; j < iRubyObjectArray.length; ++j) {
                rubyArray2.append(((RubyArray)iRubyObjectArray[j]).elt(i));
            }
            rubyArray.append(rubyArray2);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.convertToArray();
        int n = this.realLength;
        if (n > rubyArray.realLength) {
            n = rubyArray.realLength;
        }
        Ruby ruby = this.getRuntime();
        for (int i = 0; i < n; ++i) {
            IRubyObject iRubyObject2 = this.elt(i).callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", rubyArray.elt(i));
            if (iRubyObject2 instanceof RubyFixnum && ((RubyFixnum)iRubyObject2).getLongValue() == 0L) continue;
            return iRubyObject2;
        }
        n = this.realLength - rubyArray.realLength;
        if (n == 0) {
            return RubyFixnum.zero(ruby);
        }
        if (n > 0) {
            return RubyFixnum.one(ruby);
        }
        return RubyFixnum.minus_one(ruby);
    }

    public IRubyObject slice_bang(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.slice_bang(iRubyObjectArray[0]);
            }
            case 2: {
                return this.slice_bang(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObject).begLen(this.realLength, 1);
            long l = lArray[0];
            long l2 = lArray[1];
            if (l < 0L) {
                l = (long)this.realLength + l;
            }
            iRubyObject = this.subseq(l, l2);
            this.splice(l, l2, null);
            return iRubyObject;
        }
        return this.delete_at((int)RubyNumeric.num2long(iRubyObject));
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        long l = RubyNumeric.num2long(iRubyObject);
        long l2 = RubyNumeric.num2long(iRubyObject2);
        if (l < 0L) {
            l = (long)this.realLength + l;
        }
        iRubyObject2 = this.subseq(l, l2);
        this.splice(l, l2, null);
        return iRubyObject2;
    }

    @JRubyMethod(name={"assoc"}, required=1)
    public IRubyObject assoc(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject iRubyObject2 = this.values[i];
            if (!(iRubyObject2 instanceof RubyArray)) continue;
            RubyArray rubyArray = (RubyArray)iRubyObject2;
            if (rubyArray.realLength <= 0 || !RubyArray.equalInternal(threadContext, rubyArray.values[rubyArray.begin], iRubyObject)) continue;
            return rubyArray;
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"rassoc"}, required=1)
    public IRubyObject rassoc(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject iRubyObject2 = this.values[i];
            if (!(iRubyObject2 instanceof RubyArray)) continue;
            RubyArray rubyArray = (RubyArray)iRubyObject2;
            if (rubyArray.realLength <= 1 || !RubyArray.equalInternal(threadContext, rubyArray.values[rubyArray.begin + 1], iRubyObject)) continue;
            return rubyArray;
        }
        return ruby.getNil();
    }

    private final int flatten(ThreadContext threadContext, int n, RubyArray rubyArray, RubyArray rubyArray2) {
        int n2 = n + rubyArray.realLength;
        IRubyObject iRubyObject = rubyArray.id();
        if (rubyArray2.includes(threadContext, iRubyObject)) {
            throw this.getRuntime().newArgumentError("tried to flatten recursive array");
        }
        rubyArray2.append(iRubyObject);
        this.splice(n, 1L, rubyArray);
        for (int i = n; i < n2; ++i) {
            IRubyObject iRubyObject2 = this.elt(i).checkArrayType();
            if (iRubyObject2.isNil()) continue;
            int n3 = this.flatten(threadContext, i, (RubyArray)iRubyObject2, rubyArray2);
            i += n3;
            n2 += n3;
        }
        rubyArray2.pop();
        return n2 - n - 1;
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext threadContext) {
        RubyArray rubyArray = null;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject iRubyObject = this.values[this.begin + i];
            IRubyObject iRubyObject2 = iRubyObject.checkArrayType();
            if (iRubyObject2.isNil()) continue;
            if (rubyArray == null) {
                rubyArray = new RubyArray(this.getRuntime(), false);
                rubyArray.values = this.reserve(16);
            }
            i += this.flatten(threadContext, i, (RubyArray)iRubyObject2, rubyArray);
        }
        if (rubyArray == null) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext threadContext) {
        RubyArray rubyArray = this.aryDup();
        rubyArray.flatten_bang(threadContext);
        return rubyArray;
    }

    @JRubyMethod(name={"nitems"})
    public IRubyObject nitems() {
        int n = 0;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (this.values[i].isNil()) continue;
            ++n;
        }
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.convertToArray();
        int n = this.realLength + rubyArray.realLength;
        RubyArray rubyArray2 = new RubyArray(this.getRuntime(), n);
        System.arraycopy(this.values, this.begin, rubyArray2.values, 0, this.realLength);
        System.arraycopy(rubyArray.values, rubyArray.begin, rubyArray2.values, this.realLength, rubyArray.realLength);
        rubyArray2.realLength = n;
        return rubyArray2;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_times(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = iRubyObject.checkStringType();
        if (!iRubyObject2.isNil()) {
            return this.join(threadContext, iRubyObject2);
        }
        long l = RubyNumeric.num2long(iRubyObject);
        if (l == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0);
        }
        if (l < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (Long.MAX_VALUE / l < (long)this.realLength) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        RubyArray rubyArray = new RubyArray(this.getRuntime(), this.getMetaClass(), l *= (long)this.realLength);
        rubyArray.realLength = (int)l;
        int n = 0;
        while ((long)n < l) {
            System.arraycopy(this.values, this.begin, rubyArray.values, n, this.realLength);
            n += this.realLength;
        }
        rubyArray.infectBy(this);
        return rubyArray;
    }

    private final RubyHash makeHash(RubyArray rubyArray) {
        int n;
        int n2;
        RubyHash rubyHash = new RubyHash(this.getRuntime(), false);
        for (n2 = n = this.begin; n2 < n + this.realLength; ++n2) {
            rubyHash.fastASet(this.values[n2], NEVER);
        }
        if (rubyArray != null) {
            for (n2 = n = rubyArray.begin; n2 < n + rubyArray.realLength; ++n2) {
                rubyHash.fastASet(rubyArray.values[n2], NEVER);
            }
        }
        return rubyHash;
    }

    @JRubyMethod(name={"uniq!"})
    public IRubyObject uniq_bang() {
        RubyHash rubyHash = this.makeHash(null);
        if (this.realLength == rubyHash.size()) {
            return this.getRuntime().getNil();
        }
        int n = 0;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject iRubyObject = this.elt(i);
            if (!rubyHash.fastDelete(iRubyObject)) continue;
            this.store(n++, iRubyObject);
        }
        this.realLength = n;
        return this;
    }

    @JRubyMethod(name={"uniq"})
    public IRubyObject uniq() {
        RubyArray rubyArray = this.aryDup();
        rubyArray.uniq_bang();
        return rubyArray;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_diff(IRubyObject iRubyObject) {
        int n;
        RubyHash rubyHash = iRubyObject.convertToArray().makeHash(null);
        RubyArray rubyArray = new RubyArray(this.getRuntime());
        for (int i = n = this.begin; i < n + this.realLength; ++i) {
            if (rubyHash.fastARef(this.values[i]) != null) continue;
            rubyArray.append(this.elt(i - n));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"&"}, required=1)
    public IRubyObject op_and(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.convertToArray();
        RubyHash rubyHash = rubyArray.makeHash(null);
        RubyArray rubyArray2 = new RubyArray(this.getRuntime(), this.realLength < rubyArray.realLength ? (long)this.realLength : (long)rubyArray.realLength);
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject iRubyObject2 = this.elt(i);
            if (!rubyHash.fastDelete(iRubyObject2)) continue;
            rubyArray2.append(iRubyObject2);
        }
        return rubyArray2;
    }

    @JRubyMethod(name={"|"}, required=1)
    public IRubyObject op_or(IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        int n;
        RubyArray rubyArray = iRubyObject.convertToArray();
        RubyHash rubyHash = this.makeHash(rubyArray);
        RubyArray rubyArray2 = new RubyArray(this.getRuntime(), this.realLength + rubyArray.realLength);
        for (n = 0; n < this.realLength; ++n) {
            iRubyObject2 = this.elt(n);
            if (!rubyHash.fastDelete(iRubyObject2)) continue;
            rubyArray2.append(iRubyObject2);
        }
        for (n = 0; n < rubyArray.realLength; ++n) {
            iRubyObject2 = rubyArray.elt(n);
            if (!rubyHash.fastDelete(iRubyObject2)) continue;
            rubyArray2.append(iRubyObject2);
        }
        return rubyArray2;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public RubyArray sort(Block block) {
        RubyArray rubyArray = this.aryDup();
        rubyArray.sort_bang(block);
        return rubyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"sort!"}, frame=true)
    public RubyArray sort_bang(Block block) {
        this.modify();
        if (this.realLength > 1) {
            this.flags |= 0x200;
            try {
                if (block.isGiven()) {
                    Arrays.sort(this.values, 0, this.realLength, new BlockComparator(block));
                } else {
                    Arrays.sort(this.values, 0, this.realLength, new DefaultComparator());
                }
            }
            finally {
                this.flags &= 0xFFFFFDFF;
            }
        }
        return this;
    }

    public static void marshalTo(RubyArray rubyArray, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyArray);
        marshalStream.writeInt(rubyArray.getList().size());
        Iterator iterator = rubyArray.getList().iterator();
        while (iterator.hasNext()) {
            marshalStream.dumpObject((IRubyObject)iterator.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubyArray rubyArray = unmarshalStream.getRuntime().newArray();
        unmarshalStream.registerLinkTarget(rubyArray);
        int n = unmarshalStream.unmarshalInt();
        for (int i = 0; i < n; ++i) {
            rubyArray.append(unmarshalStream.unmarshalObject());
        }
        return rubyArray;
    }

    @JRubyMethod(name={"pack"}, required=1)
    public RubyString pack(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = RubyString.objAsString(threadContext, iRubyObject);
        return Pack.pack(this.getRuntime(), this, rubyString.getByteList());
    }

    public Class getJavaClass() {
        return List.class;
    }

    public int size() {
        return this.realLength;
    }

    public boolean isEmpty() {
        return this.realLength == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.realLength];
        for (int i = this.begin; i < this.realLength; ++i) {
            objectArray[i - this.begin] = JavaUtil.convertRubyToJava(this.values[i]);
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        if (objectArray2.length < this.realLength) {
            Class<?> clazz = objectArray2.getClass().getComponentType();
            objectArray2 = (Object[])Array.newInstance(clazz, this.realLength);
        }
        int n = this.realLength - this.begin;
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = JavaUtil.convertRubyToJava(this.values[i + this.begin]);
        }
        return objectArray2;
    }

    public boolean add(Object object) {
        this.append(JavaUtil.convertJavaToRuby(this.getRuntime(), object));
        return true;
    }

    public boolean remove(Object object) {
        IRubyObject iRubyObject = this.delete(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToRuby(this.getRuntime(), object), Block.NULL_BLOCK);
        return !iRubyObject.isNil();
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.indexOf(iterator.next()) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return !collection.isEmpty();
    }

    public boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            this.add(n2, iterator.next());
            ++n2;
        }
        return !collection.isEmpty();
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        for (Object e : this) {
            if (collection.contains(e)) continue;
            this.remove(e);
            bl = true;
        }
        return bl;
    }

    public Object get(int n) {
        return JavaUtil.convertRubyToJava(this.elt(n), Object.class);
    }

    public Object set(int n, Object object) {
        return this.store(n, JavaUtil.convertJavaToRuby(this.getRuntime(), object));
    }

    public void add(int n, Object object) {
        this.insert(new IRubyObject[]{RubyFixnum.newFixnum(this.getRuntime(), n), JavaUtil.convertJavaToRuby(this.getRuntime(), object)});
    }

    public Object remove(int n) {
        return JavaUtil.convertRubyToJava(this.delete_at(n), Object.class);
    }

    public int indexOf(Object object) {
        int n = this.begin;
        if (object == null) {
            for (int i = n; i < n + this.realLength; ++i) {
                if (this.values[i] != null) continue;
                return i;
            }
        } else {
            IRubyObject iRubyObject = JavaUtil.convertJavaToRuby(this.getRuntime(), object);
            for (int i = n; i < n + this.realLength; ++i) {
                if (!iRubyObject.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.begin;
        if (object == null) {
            for (int i = n + this.realLength - 1; i >= n; --i) {
                if (this.values[i] != null) continue;
                return i;
            }
        } else {
            IRubyObject iRubyObject = JavaUtil.convertJavaToRuby(this.getRuntime(), object);
            for (int i = n + this.realLength - 1; i >= n; --i) {
                if (!iRubyObject.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return new RubyArrayConversionIterator();
    }

    public ListIterator listIterator() {
        return new RubyArrayConversionListIterator();
    }

    public ListIterator listIterator(int n) {
        return new RubyArrayConversionListIterator(n);
    }

    public List subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject iRubyObject = this.subseq(n, n2 - n + 1);
        return iRubyObject.isNil() ? null : (List)((Object)iRubyObject);
    }

    public void clear() {
        this.rb_clear();
    }

    final class RubyArrayConversionListIterator
    extends RubyArrayConversionIterator
    implements ListIterator {
        public RubyArrayConversionListIterator() {
        }

        public RubyArrayConversionListIterator(int n) {
            this.index = n;
        }

        public boolean hasPrevious() {
            return this.index >= 0;
        }

        public Object previous() {
            this.last = --this.index;
            return JavaUtil.convertRubyToJava(RubyArray.this.elt(this.index), Object.class);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object object) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.store(this.last, JavaUtil.convertJavaToRuby(RubyArray.this.getRuntime(), object));
        }

        public void add(Object object) {
            RubyArray.this.insert(new IRubyObject[]{RubyFixnum.newFixnum(RubyArray.this.getRuntime(), this.index++), JavaUtil.convertJavaToRuby(RubyArray.this.getRuntime(), object)});
            this.last = -1;
        }
    }

    public class RubyArrayConversionIterator
    implements Iterator {
        protected int index = 0;
        protected int last = -1;

        public boolean hasNext() {
            return this.index < RubyArray.this.realLength;
        }

        public Object next() {
            IRubyObject iRubyObject = RubyArray.this.elt(this.index);
            this.last = this.index++;
            return JavaUtil.convertRubyToJava(iRubyObject, Object.class);
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.delete_at(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }
    }

    static final class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof RubyFixnum && object2 instanceof RubyFixnum) {
                return this.compareFixnums(object, object2);
            }
            if (object instanceof RubyString && object2 instanceof RubyString) {
                return ((RubyString)object).op_cmp((RubyString)object2);
            }
            return this.compareOthers((IRubyObject)object, (IRubyObject)object2);
        }

        private int compareFixnums(Object object, Object object2) {
            long l;
            long l2 = ((RubyFixnum)object).getLongValue();
            if (l2 > (l = ((RubyFixnum)object2).getLongValue())) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }

        private int compareOthers(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
            int n = RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2);
            return n;
        }
    }

    final class BlockComparator
    implements Comparator {
        private Block block;

        public BlockComparator(Block block) {
            this.block = block;
        }

        public int compare(Object object, Object object2) {
            ThreadContext threadContext = RubyArray.this.getRuntime().getCurrentContext();
            IRubyObject iRubyObject = (IRubyObject)object;
            IRubyObject iRubyObject2 = (IRubyObject)object2;
            IRubyObject iRubyObject3 = this.block.yield(threadContext, RubyArray.this.getRuntime().newArray(iRubyObject, iRubyObject2), null, null, true);
            int n = RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2);
            return n;
        }
    }
}

