/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Sprintf;

@JRubyClass(name={"NameError"}, parent="StandardError")
public class RubyNameError
extends RubyException {
    private IRubyObject name;
    private static ObjectAllocator NAMEERROR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyNameError(ruby, rubyClass);
        }
    };

    public static RubyClass createNameErrorClass(Ruby ruby, RubyClass rubyClass) {
        RubyClass rubyClass2 = ruby.defineClass("NameError", rubyClass, NAMEERROR_ALLOCATOR);
        rubyClass2.defineAnnotatedMethods(RubyNameError.class);
        return rubyClass2;
    }

    public static RubyClass createNameErrorMessageClass(Ruby ruby, RubyClass rubyClass) {
        RubyClass rubyClass2 = rubyClass.defineClassUnder("Message", ruby.getObject(), RubyNameErrorMessage.NAMEERRORMESSAGE_ALLOCATOR);
        rubyClass2.defineAnnotatedMethods(RubyNameErrorMessage.class);
        return rubyClass2;
    }

    protected RubyNameError(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, rubyClass.getName());
    }

    public RubyNameError(Ruby ruby, RubyClass rubyClass, String string) {
        this(ruby, rubyClass, string, null);
    }

    public RubyNameError(Ruby ruby, RubyClass rubyClass, String string, String string2) {
        super(ruby, rubyClass, string);
        this.name = string2 == null ? ruby.getNil() : ruby.newString(string2);
    }

    @JRubyMethod(name={"exception"}, rest=true, meta=true)
    public static RubyException newRubyNameError(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        RubyException rubyException = (RubyException)rubyClass.allocate();
        rubyException.callInit(iRubyObjectArray, Block.NULL_BLOCK);
        return rubyException;
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length > 1) {
            this.name = iRubyObjectArray[iRubyObjectArray.length - 1];
            int n = iRubyObjectArray.length > 2 ? iRubyObjectArray.length - 2 : iRubyObjectArray.length - 1;
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[n];
            System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, n);
            iRubyObjectArray = iRubyObjectArray2;
        } else {
            this.name = this.getRuntime().getNil();
        }
        super.initialize(iRubyObjectArray, block);
        return this;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.message.getMetaClass().getName());
        }
        RubyString rubyString = this.message.convertToString();
        if (rubyString != this.message) {
            this.message = rubyString;
        }
        if (this.isTaint()) {
            this.message.setTaint(true);
        }
        return this.message;
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name() {
        return this.name;
    }

    @JRubyClass(name={"NameError::Message"}, parent="Object")
    public static final class RubyNameErrorMessage
    extends RubyObject {
        static ObjectAllocator NAMEERRORMESSAGE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                RubyObject rubyObject = new RubyObject(ruby, ruby.getObject());
                return new RubyNameErrorMessage(ruby, rubyObject, rubyObject, Visibility.PRIVATE, CallType.VARIABLE);
            }
        };
        private final IRubyObject object;
        private final IRubyObject method;
        private final Visibility visibility;
        private final CallType callType;

        RubyNameErrorMessage(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2, Visibility visibility, CallType callType) {
            super(ruby, ruby.getNameErrorMessage(), false);
            this.object = iRubyObject;
            this.method = iRubyObject2;
            this.visibility = visibility;
            this.callType = callType;
        }

        @JRubyMethod(name={"_load"}, meta=true)
        public static IRubyObject load(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject2;
        }

        @JRubyMethod(name={"_dump"})
        public IRubyObject dump(ThreadContext threadContext, IRubyObject iRubyObject) {
            return this.to_str(threadContext);
        }

        @JRubyMethod(name={"to_str"})
        public IRubyObject to_str(ThreadContext threadContext) {
            String string = null;
            if (this.visibility == Visibility.PRIVATE) {
                string = "private method `%s' called for %s";
            } else if (this.visibility == Visibility.PROTECTED) {
                string = "protected method `%s' called for %s";
            } else if (this.callType == CallType.VARIABLE) {
                string = "undefined local variable or method `%s' for %s";
            } else if (this.callType == CallType.SUPER) {
                string = "super: no superclass method `%s'";
            }
            if (string == null) {
                string = "undefined method `%s' for %s";
            }
            String string2 = null;
            if (this.object.isNil()) {
                string2 = "nil";
            } else if (this.object instanceof RubyBoolean && this.object.isTrue()) {
                string2 = "true";
            } else if (this.object instanceof RubyBoolean && !this.object.isTrue()) {
                string2 = "false";
            } else {
                try {
                    string2 = RubyObject.inspect(threadContext, this.object).toString();
                }
                catch (JumpException jumpException) {
                    // empty catch block
                }
                if (string2 == null || string2.length() > 65) {
                    string2 = this.object.anyToString().toString();
                }
            }
            if (string2.length() == 0 || string2.length() > 0 && string2.charAt(0) != '#') {
                string2 = string2 + ":" + this.object.getMetaClass().getRealClass().getName();
            }
            Ruby ruby = this.getRuntime();
            RubyArray rubyArray = ruby.newArray(this.method, ruby.newString(string2));
            RubyString rubyString = ruby.newString(((Object)Sprintf.sprintf(ruby.newString(string), (IRubyObject)rubyArray)).toString());
            if (this.object.isTaint()) {
                rubyString.setTaint(true);
            }
            return rubyString;
        }
    }
}

