/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.encoding.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"StringScanner"})
public class RubyStringScanner
extends RubyObject {
    private RubyString str;
    private int pos = 0;
    private int lastPos = -1;
    private Region regs;
    private int beg = -1;
    private int end = -1;
    private int scannerFlags;
    private static final int MATCHED_STR_SCN_F = 2048;
    private static ObjectAllocator STRINGSCANNER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyStringScanner(ruby, rubyClass);
        }
    };
    private static final int INSPECT_LENGTH = 5;

    public static RubyClass createScannerClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("StringScanner", ruby.getObject(), STRINGSCANNER_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyStringScanner.class);
        ThreadContext threadContext = ruby.getCurrentContext();
        rubyClass.setConstant("Version", ruby.newString("0.7.0").freeze(threadContext));
        rubyClass.setConstant("Id", ruby.newString("$Id: strscan.c 13506 2007-09-24 08:56:24Z nobu $").freeze(threadContext));
        RubyClass rubyClass2 = ruby.getStandardError();
        RubyClass rubyClass3 = rubyClass.defineClassUnder("Error", rubyClass2, rubyClass2.getAllocator());
        RubyClass rubyClass4 = ruby.getObject();
        if (!rubyClass4.isConstantDefined("ScanError")) {
            rubyClass4.defineConstant("ScanError", rubyClass3);
        }
        return rubyClass;
    }

    private void clearMatched() {
        this.scannerFlags &= 0xFFFFF7FF;
    }

    private void setMatched() {
        this.scannerFlags |= 0x800;
    }

    private boolean isMatched() {
        return (this.scannerFlags & 0x800) != 0;
    }

    private void check() {
        if (this.str == null) {
            throw this.getRuntime().newArgumentError("uninitialized StringScanner object");
        }
    }

    protected RubyStringScanner(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        this.str = iRubyObjectArray[0].convertToString();
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        if (!(iRubyObject instanceof RubyStringScanner)) {
            throw this.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected StringScanner)");
        }
        RubyStringScanner rubyStringScanner = (RubyStringScanner)iRubyObject;
        this.str = rubyStringScanner.str;
        this.pos = rubyStringScanner.pos;
        this.lastPos = rubyStringScanner.lastPos;
        this.scannerFlags = rubyStringScanner.scannerFlags;
        this.regs = rubyStringScanner.regs != null ? rubyStringScanner.regs.clone() : null;
        this.beg = rubyStringScanner.beg;
        this.end = rubyStringScanner.end;
        return this;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset() {
        this.check();
        this.pos = 0;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate() {
        this.check();
        this.pos = this.str.getByteList().realSize;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear() {
        this.check();
        this.getRuntime().getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#clear is obsolete; use #terminate instead", "StringScanner#clear", "#terminate");
        return this.terminate();
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return this.str;
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.str = (RubyString)iRubyObject.convertToString().strDup(threadContext.getRuntime()).freeze(threadContext);
        this.pos = 0;
        this.clearMatched();
        return iRubyObject;
    }

    @JRubyMethod(name={"concat", "<<"}, required=1)
    public IRubyObject concat(IRubyObject iRubyObject) {
        this.check();
        this.str.append(iRubyObject);
        return this;
    }

    @JRubyMethod(name={"pos", "pointer"})
    public RubyFixnum pos() {
        this.check();
        return RubyFixnum.newFixnum(this.getRuntime(), this.pos);
    }

    @JRubyMethod(name={"pos=", "pointer="})
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        this.check();
        int n = RubyNumeric.num2int(iRubyObject);
        int n2 = this.str.getByteList().realSize;
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n > n2) {
            throw this.getRuntime().newRangeError("index out of range.");
        }
        this.pos = n;
        return RubyFixnum.newFixnum(this.getRuntime(), n);
    }

    private IRubyObject extractRange(Ruby ruby, int n, int n2) {
        int n3 = this.str.getByteList().realSize;
        if (n > n3) {
            return this.getRuntime().getNil();
        }
        if (n2 > n3) {
            n2 = n3;
        }
        return this.str.makeShared(ruby, n, n2 - n);
    }

    private IRubyObject extractBegLen(Ruby ruby, int n, int n2) {
        assert (n2 >= 0);
        int n3 = this.str.getByteList().realSize;
        if (n > n3) {
            return this.getRuntime().getNil();
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return this.str.makeShared(ruby, n, n2);
    }

    private IRubyObject scan(IRubyObject iRubyObject, boolean bl, boolean bl2, boolean bl3) {
        if (!(iRubyObject instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected Regexp)");
        }
        this.check();
        Regex regex = ((RubyRegexp)iRubyObject).getPattern();
        this.clearMatched();
        int n = this.str.getByteList().realSize - this.pos;
        if (n < 0) {
            return this.getRuntime().getNil();
        }
        ByteList byteList = this.str.getByteList();
        Matcher matcher = regex.matcher(byteList.bytes, byteList.begin + this.pos, byteList.begin + byteList.realSize);
        int n2 = bl3 ? matcher.match(byteList.begin + this.pos, byteList.begin + byteList.realSize, 0) : matcher.search(byteList.begin + this.pos, byteList.begin + byteList.realSize, 0);
        this.regs = matcher.getRegion();
        if (this.regs == null) {
            this.beg = matcher.getBegin();
            this.end = matcher.getEnd();
        } else {
            this.beg = this.regs.beg[0];
            this.end = this.regs.end[0];
        }
        if (n2 < 0) {
            return this.getRuntime().getNil();
        }
        this.setMatched();
        this.lastPos = this.pos;
        if (bl) {
            this.pos += this.end;
        }
        return bl2 ? this.extractBegLen(this.getRuntime(), this.lastPos, this.end) : RubyFixnum.newFixnum(this.getRuntime(), this.end);
    }

    @JRubyMethod(name={"scan"}, required=1)
    public IRubyObject scan(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, true, true, true);
    }

    @JRubyMethod(name={"match?"}, required=1)
    public IRubyObject match_p(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, false, false, true);
    }

    @JRubyMethod(name={"skip"}, required=1)
    public IRubyObject skip(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, true, false, true);
    }

    @JRubyMethod(name={"check"}, required=1)
    public IRubyObject check(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, false, true, true);
    }

    @JRubyMethod(name={"scan_full"}, required=3)
    public IRubyObject scan_full(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.scan(iRubyObject, iRubyObject2.isTrue(), iRubyObject3.isTrue(), true);
    }

    @JRubyMethod(name={"scan_until"}, required=1)
    public IRubyObject scan_until(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, true, true, false);
    }

    @JRubyMethod(name={"exist?"}, required=1)
    public IRubyObject exist_p(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, false, false, false);
    }

    @JRubyMethod(name={"skip_until"}, required=1)
    public IRubyObject skip_until(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, true, false, false);
    }

    @JRubyMethod(name={"check_until"}, required=1)
    public IRubyObject check_until(IRubyObject iRubyObject) {
        return this.scan(iRubyObject, false, true, false);
    }

    @JRubyMethod(name={"search_full"}, required=3)
    public IRubyObject search_full(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.scan(iRubyObject, iRubyObject2.isTrue(), iRubyObject3.isTrue(), false);
    }

    private void adjustRegisters() {
        this.beg = 0;
        this.end = this.pos - this.lastPos;
        this.regs = null;
    }

    @JRubyMethod(name={"getch"})
    public IRubyObject getch(ThreadContext threadContext) {
        this.check();
        this.clearMatched();
        Ruby ruby = threadContext.getRuntime();
        ByteList byteList = this.str.getByteList();
        if (this.pos >= byteList.realSize) {
            return ruby.getNil();
        }
        Encoding encoding = ruby.getKCode().getEncoding();
        int n = encoding.isSingleByte() ? 1 : encoding.length(byteList.bytes[byteList.begin + this.pos]);
        if (this.pos + n > byteList.realSize) {
            n = byteList.realSize - this.pos;
        }
        this.lastPos = this.pos;
        this.pos += n;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(ruby, this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"get_byte"})
    public IRubyObject get_byte(ThreadContext threadContext) {
        this.check();
        this.clearMatched();
        if (this.pos >= this.str.getByteList().realSize) {
            return this.getRuntime().getNil();
        }
        this.lastPos = this.pos++;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(threadContext.getRuntime(), this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext threadContext) {
        threadContext.getRuntime().getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#getbyte is obsolete; use #get_byte instead", "StringScanner#getbyte", "#get_byte");
        return this.get_byte(threadContext);
    }

    @JRubyMethod(name={"peek"}, required=1)
    public IRubyObject peek(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.check();
        int n = RubyNumeric.num2int(iRubyObject);
        if (n < 0) {
            throw threadContext.getRuntime().newArgumentError("negative string size (or size too big)");
        }
        ByteList byteList = this.str.getByteList();
        if (this.pos >= byteList.realSize) {
            return RubyString.newEmptyString(this.getRuntime()).infectBy(this.str);
        }
        if (this.pos + n > byteList.realSize) {
            n = byteList.realSize - this.pos;
        }
        return this.extractBegLen(threadContext.getRuntime(), this.pos, n);
    }

    @JRubyMethod(name={"peep"}, required=1)
    public IRubyObject peep(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.getRuntime().getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#peep is obsolete; use #peek instead", "StringScanner#peep", "#peek");
        return this.peek(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan() {
        this.check();
        Ruby ruby = this.getRuntime();
        if (!this.isMatched()) {
            RubyClass rubyClass = ruby.fastGetClass("StringScanner").fastGetClass("Error");
            throw new RaiseException(RubyException.newException(ruby, rubyClass, "unscan failed: previous match had failed"));
        }
        this.pos = this.lastPos;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"beginning_of_line?"}, alias={"bol?"})
    public IRubyObject bol_p() {
        this.check();
        ByteList byteList = this.str.getByteList();
        if (this.pos > byteList.realSize) {
            return this.getRuntime().getNil();
        }
        if (this.pos == 0) {
            return this.getRuntime().getTrue();
        }
        return byteList.bytes[byteList.begin + this.pos - 1] == 10 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eos?"})
    public RubyBoolean eos_p(ThreadContext threadContext) {
        this.check();
        return this.pos >= this.str.getByteList().realSize ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext threadContext) {
        this.getRuntime().getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#empty? is obsolete; use #eos? instead", "StringScanner#empty?", "#eos?");
        return this.eos_p(threadContext);
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p(ThreadContext threadContext) {
        this.check();
        return this.pos >= this.str.getByteList().realSize ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p(ThreadContext threadContext) {
        this.check();
        return this.isMatched() ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched(ThreadContext threadContext) {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(threadContext.getRuntime(), this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.end - this.beg);
    }

    @JRubyMethod(name={"matchedsize"})
    public IRubyObject matchedsize() {
        this.getRuntime().getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#matchedsize is obsolete; use #matched_size instead", "StringScanner#matchedize", "#matched_size");
        return this.matched_size();
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n;
        this.check();
        if (!this.isMatched()) {
            return threadContext.getRuntime().getNil();
        }
        int n2 = RubyNumeric.num2int(iRubyObject);
        int n3 = n = this.regs == null ? 1 : this.regs.numRegs;
        if (n2 < 0) {
            n2 += n;
        }
        if (n2 < 0 || n2 >= n) {
            return threadContext.getRuntime().getNil();
        }
        if (this.regs == null) {
            assert (n2 == 0);
            if (this.beg == -1) {
                return this.getRuntime().getNil();
            }
            return this.extractRange(threadContext.getRuntime(), this.lastPos + this.beg, this.lastPos + this.end);
        }
        if (this.regs.beg[n2] == -1) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(threadContext.getRuntime(), this.lastPos + this.regs.beg[n2], this.lastPos + this.regs.end[n2]);
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext threadContext) {
        this.check();
        if (!this.isMatched()) {
            return threadContext.getRuntime().getNil();
        }
        return this.extractRange(threadContext.getRuntime(), 0, this.lastPos + this.beg);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext threadContext) {
        this.check();
        if (!this.isMatched()) {
            return threadContext.getRuntime().getNil();
        }
        return this.extractRange(threadContext.getRuntime(), this.lastPos + this.end, this.str.getByteList().realSize);
    }

    @JRubyMethod(name={"rest"})
    public IRubyObject rest(ThreadContext threadContext) {
        this.check();
        ByteList byteList = this.str.getByteList();
        if (this.pos >= byteList.realSize) {
            return RubyString.newEmptyString(threadContext.getRuntime()).infectBy(this.str);
        }
        return this.extractRange(threadContext.getRuntime(), this.pos, byteList.realSize);
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size() {
        this.check();
        ByteList byteList = this.str.getByteList();
        if (this.pos >= byteList.realSize) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), byteList.realSize - this.pos);
    }

    @JRubyMethod(name={"restsize"})
    public RubyFixnum restsize() {
        this.getRuntime().getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#restsize is obsolete; use #rest_size instead", "StringScanner#restsize", "#rest_size");
        return this.rest_size();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.str == null) {
            return this.inspect("(uninitialized)");
        }
        if (this.pos >= this.str.getByteList().realSize) {
            return this.inspect("fin");
        }
        if (this.pos == 0) {
            return this.inspect(this.pos + "/" + this.str.getByteList().realSize + " @ " + this.inspect2());
        }
        return this.inspect(this.pos + "/" + this.str.getByteList().realSize + " " + this.inspect1() + " @ " + this.inspect2());
    }

    private IRubyObject inspect(String string) {
        RubyString rubyString = this.getRuntime().newString("#<" + this.getMetaClass() + " " + string + ">");
        if (this.str != null) {
            rubyString.infectBy(this.str);
        }
        return rubyString;
    }

    private IRubyObject inspect1() {
        if (this.pos == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        if (this.pos > 5) {
            return RubyString.newString(this.getRuntime(), "...".getBytes()).append(this.str.substr(this.pos - 5, 5)).inspect();
        }
        return this.str.substr(0, this.pos).inspect();
    }

    private IRubyObject inspect2() {
        if (this.pos >= this.str.getByteList().realSize) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        int n = this.str.getByteList().realSize - this.pos;
        if (n > 5) {
            return ((RubyString)this.str.substr(this.pos, 5)).cat("...".getBytes()).inspect();
        }
        return this.str.substr(this.pos, n).inspect();
    }

    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject iRubyObject) {
        return iRubyObject;
    }
}

