/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.math.BigInteger;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BignumNode
extends Node
implements ILiteralNode {
    private BigInteger value;

    public BignumNode(ISourcePosition iSourcePosition, BigInteger bigInteger) {
        super(iSourcePosition, NodeType.BIGNUMNODE);
        this.value = bigInteger;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitBignumNode(this);
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setValue(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyBignum.newBignum(ruby, this.value);
    }
}

