/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockPassNode
extends Node {
    private final Node bodyNode;
    private Node argsNode;

    public BlockPassNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.BLOCKPASSNODE);
        this.bodyNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitBlockPassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public void setArgsNode(Node node) {
        this.argsNode = node;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.bodyNode == null ? ruby.getNil() : this.bodyNode.interpret(ruby, threadContext, iRubyObject, block);
    }
}

