/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ast.CallNoArgBlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class CallNoArgNode
extends CallNode {
    public CallNoArgNode(ISourcePosition iSourcePosition, Node node, String string) {
        super(iSourcePosition, node, string, null, null);
    }

    public CallNoArgNode(ISourcePosition iSourcePosition, Node node, Node node2, String string) {
        super(iSourcePosition, node, string, node2, null);
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.callAdapter.call(threadContext, this.getReceiverNode().interpret(ruby, threadContext, iRubyObject, block));
    }

    public Node setIterNode(Node node) {
        return new CallNoArgBlockNode(this.getPosition(), this.getReceiverNode(), this.getName(), this.getArgsNode(), (IterNode)node);
    }

    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.getReceiverNode().definition(ruby, threadContext, iRubyObject, block) != null) {
            try {
                IRubyObject iRubyObject2 = this.getReceiverNode().interpret(ruby, threadContext, iRubyObject, block);
                RubyClass rubyClass = iRubyObject2.getMetaClass();
                DynamicMethod dynamicMethod = rubyClass.searchMethod(this.getName());
                Visibility visibility = dynamicMethod.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || rubyClass.getRealClass().isInstance(iRubyObject))) {
                    return !dynamicMethod.isUndefined() ? "method" : null;
                }
            }
            catch (JumpException jumpException) {
                // empty catch block
            }
        }
        return null;
    }
}

