/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefsNode
extends MethodDefNode
implements INameNode {
    private final Node receiverNode;

    public DefsNode(ISourcePosition iSourcePosition, Node node, ArgumentNode argumentNode, ArgsNode argsNode, StaticScope staticScope, Node node2) {
        super(iSourcePosition, argumentNode, argsNode, staticScope, node2, NodeType.DEFSNODE);
        assert (node != null) : "receiverNode is not null";
        this.receiverNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDefsNode(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        String string = this.getName();
        if (ruby.getSafeLevel() >= 4 && !iRubyObject2.isTaint()) {
            throw ruby.newSecurityError("Insecure; can't define singleton method.");
        }
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubySymbol) {
            throw ruby.newTypeError("can't define singleton method \"" + string + "\" for " + iRubyObject2.getMetaClass().getBaseName());
        }
        if (iRubyObject2.isFrozen()) {
            throw ruby.newFrozenError("object");
        }
        RubyClass rubyClass = iRubyObject2.getSingletonClass();
        if (ruby.getSafeLevel() >= 4 && rubyClass.getMethods().get(string) != null) {
            throw ruby.newSecurityError("redefining method prohibited.");
        }
        this.scope.determineModule();
        Node node = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod defaultMethod = new DefaultMethod(rubyClass, this.scope, node, this.argsNode, Visibility.PUBLIC, this.getPosition());
        rubyClass.addMethod(string, defaultMethod);
        iRubyObject2.callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
        return ruby.getNil();
    }
}

