/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.SharedScopeBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForNode
extends IterNode {
    public final CallSite callAdapter = MethodIndex.getCallSite("each");
    private Node iterNode;

    public ForNode(ISourcePosition iSourcePosition, Node node, Node node2, Node node3) {
        super(iSourcePosition, node, null, node2, NodeType.FORNODE);
        assert (node3 != null) : "iterNode is not null";
        this.iterNode = node3;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitForNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Block block2 = SharedScopeBlock.newInterpretedSharedScopeClosure(threadContext, this, threadContext.getCurrentScope(), iRubyObject);
        try {
            while (true) {
                try {
                    String string = threadContext.getFile();
                    int n = threadContext.getLine();
                    IRubyObject iRubyObject2 = null;
                    try {
                        iRubyObject2 = this.iterNode.interpret(ruby, threadContext, iRubyObject, block);
                    }
                    finally {
                        threadContext.setFile(string);
                        threadContext.setLine(n);
                    }
                    return this.callAdapter.call(threadContext, iRubyObject2, block2);
                }
                catch (JumpException.RetryJump retryJump) {
                    continue;
                }
                break;
            }
        }
        catch (JumpException.BreakJump breakJump) {
            return (IRubyObject)breakJump.getValue();
        }
    }
}

