/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashNode
extends Node {
    private final ListNode listNode;

    public HashNode(ISourcePosition iSourcePosition, ListNode listNode) {
        super(iSourcePosition, NodeType.HASHNODE);
        this.listNode = listNode;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitHashNode(this);
    }

    public ListNode getListNode() {
        return this.listNode;
    }

    @Override
    public List<Node> childNodes() {
        return HashNode.createList(this.listNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyHash rubyHash = RubyHash.newHash(ruby);
        if (this.listNode != null) {
            int n = this.listNode.size();
            int n2 = 0;
            while (n2 < n) {
                IRubyObject iRubyObject2 = this.listNode.get(n2++).interpret(ruby, threadContext, iRubyObject, block);
                IRubyObject iRubyObject3 = this.listNode.get(n2++).interpret(ruby, threadContext, iRubyObject, block);
                rubyHash.fastASet(iRubyObject2, iRubyObject3);
            }
        }
        return rubyHash;
    }
}

