/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndefNode
extends Node {
    private String name;

    public UndefNode(ISourcePosition iSourcePosition, String string) {
        super(iSourcePosition, NodeType.UNDEFNODE);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitUndefNode(this);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = threadContext.getRubyClass();
        if (rubyModule == null) {
            throw ruby.newTypeError("No class to undef method '" + this.name + "'.");
        }
        rubyModule.undef(threadContext, this.name);
        return ruby.getNil();
    }
}

