/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IArityNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSuperNode
extends Node
implements IArityNode,
BlockAcceptingNode {
    private Node iterNode;

    public ZSuperNode(ISourcePosition iSourcePosition) {
        super(iSourcePosition, NodeType.ZSUPERNODE);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitZSuperNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.optional();
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? ZSuperNode.createList(this.iterNode) : EMPTY_LIST;
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node node) {
        this.iterNode = node;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, this.iterNode);
        return RuntimeHelpers.callZSuper(ruby, threadContext, block2, iRubyObject);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        String string = threadContext.getFrameName();
        RubyModule rubyModule = threadContext.getFrameKlazz();
        if (string != null && rubyModule != null && rubyModule.getSuperClass().isMethodBound(string, false)) {
            return "super";
        }
        return null;
    }
}

