/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor.rewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.CommentNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.ast.visitor.rewriter.ClassBodyWriter;
import org.jruby.ast.visitor.rewriter.DefaultFormatHelper;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.ReWriterFactory;
import org.jruby.ast.visitor.rewriter.utils.Operators;
import org.jruby.ast.visitor.rewriter.utils.ReWriterContext;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReWriteVisitor
implements NodeVisitor {
    protected final ReWriterContext config;
    protected final ReWriterFactory factory;

    public ReWriteVisitor(Writer writer, String string) {
        this(new ReWriterContext(new PrintWriter(writer), string, (FormatHelper)new DefaultFormatHelper()));
    }

    public ReWriteVisitor(OutputStream outputStream, String string) {
        this(new ReWriterContext(new PrintWriter(outputStream, true), string, (FormatHelper)new DefaultFormatHelper()));
    }

    public ReWriteVisitor(ReWriterContext reWriterContext) {
        this.config = reWriterContext;
        this.factory = new ReWriterFactory(reWriterContext);
    }

    public void flushStream() {
        this.config.getOutput().flush();
    }

    protected void print(String string) {
        this.config.getOutput().print(string);
    }

    protected void print(char c) {
        this.config.getOutput().print(c);
    }

    protected void print(BigInteger bigInteger) {
        this.config.getOutput().print(bigInteger);
    }

    protected void print(int n) {
        this.config.getOutput().print(n);
    }

    protected void print(long l) {
        this.config.getOutput().print(l);
    }

    protected void print(double d) {
        this.config.getOutput().print(d);
    }

    private void enterCall() {
        this.config.getCallDepth().enterCall();
    }

    private void leaveCall() {
        this.config.getCallDepth().leaveCall();
    }

    private boolean inCall() {
        return this.config.getCallDepth().inCall();
    }

    protected void printNewlineAndIndentation() {
        if (this.config.hasHereDocument()) {
            this.config.fetchHereDocument().print();
        }
        this.print(this.config.getFormatHelper().getLineDelimiter());
        this.config.getIndentor().printIndentation(this.config.getOutput());
    }

    private static boolean isReceiverACallNode(CallNode callNode) {
        return callNode.getReceiverNode() instanceof CallNode || callNode.getReceiverNode() instanceof FCallNode;
    }

    private void printCommentsBefore(Node node) {
        for (CommentNode commentNode : node.getComments()) {
            if (ReWriteVisitor.getStartLine(commentNode) >= ReWriteVisitor.getStartLine(node)) continue;
            this.visitNode(commentNode);
            this.print(commentNode.getContent());
            this.printNewlineAndIndentation();
        }
    }

    protected boolean printCommentsAfter(Node node) {
        boolean bl = false;
        for (CommentNode commentNode : node.getComments()) {
            if (ReWriteVisitor.getStartLine(commentNode) < ReWriteVisitor.getEndLine(node)) continue;
            this.print(' ');
            this.visitNode(commentNode);
            this.print(commentNode.getContent());
            bl = true;
        }
        return bl;
    }

    public void visitNode(Node node) {
        if (node == null || node.isInvisible()) {
            return;
        }
        this.printCommentsBefore(node);
        if (node instanceof ArgumentNode) {
            this.print(((ArgumentNode)node).getName());
        } else {
            node.accept(this);
        }
        this.printCommentsAfter(node);
        this.config.setLastPosition(node.getPosition());
    }

    public void visitIter(Iterator iterator) {
        while (iterator.hasNext()) {
            this.visitNode((Node)iterator.next());
        }
    }

    private void visitIterAndSkipFirst(Iterator iterator) {
        iterator.next();
        this.visitIter(iterator);
    }

    private static boolean isStartOnNewLine(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        return ReWriteVisitor.getStartLine(node) < ReWriteVisitor.getStartLine(node2);
    }

    private boolean needsParentheses(Node node) {
        return node != null && (node.childNodes().size() > 1 || this.inCall() || ReWriteVisitor.firstChild(node) instanceof HashNode) || ReWriteVisitor.firstChild(node) instanceof NewlineNode || ReWriteVisitor.firstChild(node) instanceof IfNode;
    }

    private void printCallArguments(Node node, Node node2) {
        boolean bl;
        if (node != null && node.childNodes().size() < 1 && node2 == null) {
            return;
        }
        if (node != null && node.childNodes().size() == 1 && ReWriteVisitor.firstChild(node) instanceof HashNode && node2 == null) {
            HashNode hashNode = (HashNode)ReWriteVisitor.firstChild(node);
            if (hashNode.getListNode().childNodes().size() < 1) {
                this.print("({})");
            } else {
                this.print(' ');
                this.printHashNodeContent(hashNode);
            }
            return;
        }
        boolean bl2 = bl = this.needsParentheses(node) || node == null && node2 != null && node2 instanceof BlockPassNode || node != null && node.childNodes().size() > 0 && node2 != null;
        if (bl) {
            this.print('(');
        } else if (node != null) {
            this.print(this.config.getFormatHelper().beforeCallArguments());
        }
        if (ReWriteVisitor.firstChild(node) instanceof NewlineNode) {
            this.config.setSkipNextNewline(true);
        }
        this.enterCall();
        if (node instanceof SplatNode) {
            this.visitNode(node);
        } else if (node != null) {
            this.visitAndPrintWithSeparator(node.childNodes().iterator());
        }
        if (node2 instanceof BlockPassNode) {
            if (node != null) {
                this.print(this.config.getFormatHelper().getListSeparator());
            }
            this.print('&');
            this.visitNode(((BlockPassNode)node2).getBodyNode());
        }
        if (bl) {
            this.print(')');
        } else {
            this.print(this.config.getFormatHelper().afterCallArguments());
        }
        this.leaveCall();
    }

    public void visitAndPrintWithSeparator(Iterator<Node> iterator) {
        while (iterator.hasNext()) {
            Node node = iterator.next();
            this.factory.createIgnoreCommentsReWriteVisitor().visitNode(node);
            if (iterator.hasNext()) {
                this.print(this.config.getFormatHelper().getListSeparator());
            }
            if (!node.hasComments()) continue;
            this.factory.createReWriteVisitor().visitIter(node.getComments().iterator());
            this.printNewlineAndIndentation();
        }
    }

    @Override
    public Instruction visitAliasNode(AliasNode aliasNode) {
        this.print("alias ");
        this.print(aliasNode.getNewName());
        this.print(' ');
        this.print(aliasNode.getOldName());
        this.printCommentsAtEnd(aliasNode);
        return null;
    }

    private boolean sourceRangeEquals(int n, int n2, String string) {
        return n2 <= this.config.getSource().length() && this.sourceSubStringEquals(n, n2 - n, string);
    }

    private boolean sourceRangeContains(ISourcePosition iSourcePosition, String string) {
        return iSourcePosition.getStartOffset() < this.config.getSource().length() && iSourcePosition.getEndOffset() < this.config.getSource().length() + 1 && this.config.getSource().substring(iSourcePosition.getStartOffset(), iSourcePosition.getEndOffset()).indexOf(string) > -1;
    }

    @Override
    public Instruction visitAndNode(AndNode andNode) {
        this.enterCall();
        this.visitNode(andNode.getFirstNode());
        if (this.sourceRangeContains(andNode.getPosition(), "&&")) {
            this.print(" && ");
        } else {
            this.print(" and ");
        }
        this.visitNode(andNode.getSecondNode());
        this.leaveCall();
        return null;
    }

    private ArrayList<Node> collectAllArguments(ArgsNode argsNode) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (argsNode.getArgs() != null) {
            arrayList.addAll(argsNode.getArgs().childNodes());
        }
        if (argsNode.getOptArgs() != null) {
            arrayList.addAll(argsNode.getOptArgs().childNodes());
        }
        if (argsNode.getRestArgNode() != null) {
            arrayList.add(new ConstNode(argsNode.getRestArgNode().getPosition(), '*' + argsNode.getRestArgNode().getName()));
        }
        if (argsNode.getBlockArgNode() != null) {
            arrayList.add(argsNode.getBlockArgNode());
        }
        return arrayList;
    }

    private boolean hasNodeCommentsAtEnd(Node node) {
        for (CommentNode commentNode : node.getComments()) {
            if (ReWriteVisitor.getStartLine(commentNode) != ReWriteVisitor.getStartLine(node)) continue;
            return true;
        }
        return false;
    }

    private void printCommentsInArgs(Node node, boolean bl) {
        if (this.hasNodeCommentsAtEnd(node) && bl) {
            this.print(",");
        }
        if (this.printCommentsAfter(node) && bl) {
            this.printNewlineAndIndentation();
        } else if (bl) {
            this.print(this.config.getFormatHelper().getListSeparator());
        }
    }

    @Override
    public Instruction visitArgsNode(ArgsNode argsNode) {
        Iterator<Node> iterator = this.collectAllArguments(argsNode).iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node instanceof ArgumentNode) {
                this.print(((ArgumentNode)node).getName());
                this.printCommentsInArgs(node, iterator.hasNext());
            } else {
                this.visitNode(node);
                if (iterator.hasNext()) {
                    this.print(this.config.getFormatHelper().getListSeparator());
                }
            }
            if (iterator.hasNext()) continue;
            this.print(this.config.getFormatHelper().afterMethodArguments());
        }
        return null;
    }

    @Override
    public Instruction visitArgsCatNode(ArgsCatNode argsCatNode) {
        this.print("[");
        this.visitAndPrintWithSeparator(argsCatNode.getFirstNode().childNodes().iterator());
        this.print(this.config.getFormatHelper().getListSeparator());
        this.print("*");
        this.visitNode(argsCatNode.getSecondNode());
        this.print("]");
        return null;
    }

    @Override
    public Instruction visitArrayNode(ArrayNode arrayNode) {
        this.print('[');
        this.enterCall();
        this.visitAndPrintWithSeparator(arrayNode.childNodes().iterator());
        this.leaveCall();
        this.print(']');
        return null;
    }

    @Override
    public Instruction visitBackRefNode(BackRefNode backRefNode) {
        this.print('$');
        this.print(backRefNode.getType());
        return null;
    }

    @Override
    public Instruction visitBeginNode(BeginNode beginNode) {
        this.print("begin");
        this.visitNodeInIndentation(beginNode.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Instruction visitBignumNode(BignumNode bignumNode) {
        this.print(bignumNode.getValue());
        return null;
    }

    @Override
    public Instruction visitBlockArgNode(BlockArgNode blockArgNode) {
        this.print('&');
        this.print(blockArgNode.getName());
        return null;
    }

    @Override
    public Instruction visitBlockNode(BlockNode blockNode) {
        this.visitIter(blockNode.childNodes().iterator());
        return null;
    }

    public static int getLocalVarIndex(Node node) {
        return node instanceof LocalVarNode ? ((LocalVarNode)node).getIndex() : -1;
    }

    @Override
    public Instruction visitBlockPassNode(BlockPassNode blockPassNode) {
        this.visitNode(blockPassNode.getBodyNode());
        return null;
    }

    @Override
    public Instruction visitBreakNode(BreakNode breakNode) {
        this.print("break");
        return null;
    }

    @Override
    public Instruction visitConstDeclNode(ConstDeclNode constDeclNode) {
        this.printAsgnNode(constDeclNode);
        return null;
    }

    @Override
    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode classVarAsgnNode) {
        this.printAsgnNode(classVarAsgnNode);
        return null;
    }

    @Override
    public Instruction visitClassVarDeclNode(ClassVarDeclNode classVarDeclNode) {
        this.printAsgnNode(classVarDeclNode);
        return null;
    }

    @Override
    public Instruction visitClassVarNode(ClassVarNode classVarNode) {
        this.print(classVarNode.getName());
        return null;
    }

    private boolean isNumericNode(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode);
    }

    private boolean isNameAnOperator(String string) {
        return Operators.contain(string);
    }

    private boolean printSpaceInsteadOfDot(CallNode callNode) {
        return this.isNameAnOperator(callNode.getName()) && callNode.getArgsNode().childNodes().size() <= 1;
    }

    protected void printAssignmentOperator() {
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
    }

    private Instruction printIndexAssignment(AttrAssignNode attrAssignNode) {
        this.enterCall();
        this.visitNode(attrAssignNode.getReceiverNode());
        this.leaveCall();
        this.print('[');
        this.visitNode(ReWriteVisitor.firstChild(attrAssignNode.getArgsNode()));
        this.print("]");
        this.printAssignmentOperator();
        if (attrAssignNode.getArgsNode().childNodes().size() > 1) {
            this.visitNode(attrAssignNode.getArgsNode().childNodes().get(1));
        }
        return null;
    }

    private Instruction printIndexAccess(CallNode callNode) {
        this.enterCall();
        this.visitNode(callNode.getReceiverNode());
        this.leaveCall();
        this.print('[');
        if (callNode.getArgsNode() != null) {
            this.visitAndPrintWithSeparator(callNode.getArgsNode().childNodes().iterator());
        }
        this.print("]");
        return null;
    }

    private Instruction printNegativNumericNode(CallNode callNode) {
        this.print('-');
        this.visitNode(callNode.getReceiverNode());
        return null;
    }

    private boolean isNegativeNumericNode(CallNode callNode) {
        return this.isNumericNode(callNode.getReceiverNode()) && callNode.getName().equals("-@");
    }

    private void printCallReceiverNode(CallNode callNode) {
        if (callNode.getReceiverNode() instanceof HashNode) {
            this.print('(');
        }
        if (ReWriteVisitor.isReceiverACallNode(callNode) && !this.printSpaceInsteadOfDot(callNode)) {
            this.enterCall();
            this.visitNewlineInParentheses(callNode.getReceiverNode());
            this.leaveCall();
        } else {
            this.visitNewlineInParentheses(callNode.getReceiverNode());
        }
        if (callNode.getReceiverNode() instanceof HashNode) {
            this.print(')');
        }
    }

    protected boolean inMultipleAssignment() {
        return false;
    }

    @Override
    public Instruction visitCallNode(CallNode callNode) {
        if (this.isNegativeNumericNode(callNode)) {
            return this.printNegativNumericNode(callNode);
        }
        if (callNode.getName().equals("[]")) {
            return this.printIndexAccess(callNode);
        }
        this.printCallReceiverNode(callNode);
        this.print(this.printSpaceInsteadOfDot(callNode) ? (char)' ' : '.');
        if (this.inMultipleAssignment() && callNode.getName().endsWith("=")) {
            this.print(callNode.getName().substring(0, callNode.getName().length() - 1));
        } else {
            this.print(callNode.getName());
        }
        if (this.isNameAnOperator(callNode.getName())) {
            if (ReWriteVisitor.firstChild(callNode.getArgsNode()) instanceof NewlineNode) {
                this.print(' ');
            }
            this.config.getCallDepth().disableCallDepth();
        }
        this.printCallArguments(callNode.getArgsNode(), callNode.getIterNode());
        if (this.isNameAnOperator(callNode.getName())) {
            this.config.getCallDepth().enableCallDepth();
        }
        if (!(callNode.getIterNode() instanceof BlockPassNode)) {
            this.visitNode(callNode.getIterNode());
        }
        return null;
    }

    @Override
    public Instruction visitCaseNode(CaseNode caseNode) {
        this.print("case ");
        this.visitNode(caseNode.getCaseNode());
        this.visitNode(caseNode.getFirstWhenNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    private boolean printCommentsIn(Node node) {
        boolean bl = false;
        for (CommentNode commentNode : node.getComments()) {
            if (ReWriteVisitor.getStartLine(commentNode) <= ReWriteVisitor.getStartLine(node) || ReWriteVisitor.getEndLine(commentNode) >= ReWriteVisitor.getEndLine(node)) continue;
            bl = true;
            this.visitNode(commentNode);
            this.print(commentNode.getContent());
            this.printNewlineAndIndentation();
        }
        return bl;
    }

    @Override
    public Instruction visitClassNode(ClassNode classNode) {
        this.print("class ");
        this.visitNode(classNode.getCPath());
        if (classNode.getSuperNode() != null) {
            this.print(" < ");
            this.visitNode(classNode.getSuperNode());
        }
        new ClassBodyWriter(this, classNode.getBodyNode()).write();
        this.printNewlineAndIndentation();
        this.printCommentsIn(classNode);
        this.print("end");
        return null;
    }

    @Override
    public Instruction visitColon2Node(Colon2Node colon2Node) {
        if (colon2Node.getLeftNode() != null) {
            this.visitNode(colon2Node.getLeftNode());
            this.print("::");
        }
        this.print(colon2Node.getName());
        return null;
    }

    @Override
    public Instruction visitColon3Node(Colon3Node colon3Node) {
        this.print("::");
        this.print(colon3Node.getName());
        return null;
    }

    @Override
    public Instruction visitConstNode(ConstNode constNode) {
        this.print(constNode.getName());
        return null;
    }

    @Override
    public Instruction visitDAsgnNode(DAsgnNode dAsgnNode) {
        this.printAsgnNode(dAsgnNode);
        return null;
    }

    @Override
    public Instruction visitDRegxNode(DRegexpNode dRegexpNode) {
        this.config.getPrintQuotesInString().set(false);
        this.print(this.getFirstRegexpEnclosure(dRegexpNode));
        this.factory.createDRegxReWriteVisitor().visitIter(dRegexpNode.childNodes().iterator());
        this.print(this.getSecondRegexpEnclosure(dRegexpNode));
        this.printRegexpOptions(dRegexpNode.getOptions());
        this.config.getPrintQuotesInString().revert();
        return null;
    }

    private Instruction createHereDocument(DStrNode dStrNode) {
        this.config.getPrintQuotesInString().set(false);
        this.print("<<-EOF");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = this.config.getOutput();
        this.config.setOutput(new PrintWriter(stringWriter));
        Iterator<Node> iterator = dStrNode.childNodes().iterator();
        while (iterator.hasNext()) {
            this.factory.createHereDocReWriteVisitor().visitNode(iterator.next());
            if (!iterator.hasNext()) continue;
            this.config.setSkipNextNewline(true);
        }
        this.config.setOutput(printWriter);
        this.config.depositHereDocument(stringWriter.getBuffer().toString());
        this.config.getPrintQuotesInString().revert();
        return null;
    }

    @Override
    public Instruction visitDStrNode(DStrNode dStrNode) {
        if (ReWriteVisitor.firstChild(dStrNode) instanceof StrNode && this.stringIsHereDocument((StrNode)ReWriteVisitor.firstChild(dStrNode))) {
            return this.createHereDocument(dStrNode);
        }
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(dStrNode));
        }
        this.config.getPrintQuotesInString().set(false);
        this.leaveCall();
        for (Node node : dStrNode.childNodes()) {
            this.visitNode(node);
        }
        this.enterCall();
        this.config.getPrintQuotesInString().revert();
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(dStrNode));
        }
        return null;
    }

    @Override
    public Instruction visitDSymbolNode(DSymbolNode dSymbolNode) {
        this.print(':');
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForSym(dSymbolNode));
        }
        this.config.getPrintQuotesInString().set(false);
        this.leaveCall();
        for (Node node : dSymbolNode.childNodes()) {
            this.visitNode(node);
        }
        this.enterCall();
        this.config.getPrintQuotesInString().revert();
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForSym(dSymbolNode));
        }
        return null;
    }

    @Override
    public Instruction visitDVarNode(DVarNode dVarNode) {
        this.print(dVarNode.getName());
        return null;
    }

    @Override
    public Instruction visitDXStrNode(DXStrNode dXStrNode) {
        this.config.getPrintQuotesInString().set(false);
        this.print("%x{");
        this.visitIter(dXStrNode.childNodes().iterator());
        this.print('}');
        this.config.getPrintQuotesInString().revert();
        return null;
    }

    @Override
    public Instruction visitDefinedNode(DefinedNode definedNode) {
        this.print("defined? ");
        this.enterCall();
        this.visitNode(definedNode.getExpressionNode());
        this.leaveCall();
        return null;
    }

    private boolean hasArguments(Node node) {
        if (node instanceof ArgsNode) {
            ArgsNode argsNode = (ArgsNode)node;
            return argsNode.getArgs() != null || argsNode.getOptArgs() != null || argsNode.getBlockArgNode() != null || argsNode.getRestArgNode() != null;
        }
        return !(node instanceof ArrayNode) || !node.childNodes().isEmpty();
    }

    protected void printCommentsAtEnd(Node node) {
        for (CommentNode commentNode : node.getComments()) {
            if (ReWriteVisitor.getStartLine(node) != ReWriteVisitor.getStartLine(commentNode)) continue;
            this.print(' ');
            this.visitNode(commentNode);
            this.print(commentNode.getContent());
        }
    }

    private void printDefNode(Node node, String string, Node node2, StaticScope staticScope, Node node3) {
        this.print(string);
        this.config.getLocalVariables().addLocalVariable(staticScope);
        if (this.hasArguments(node2)) {
            this.print(this.config.getFormatHelper().beforeMethodArguments());
            this.visitNode(node2);
        }
        this.printCommentsAtEnd(node);
        this.visitNode(node3);
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.printCommentsIn(node);
        this.print("end");
    }

    @Override
    public Instruction visitDefnNode(DefnNode defnNode) {
        this.config.getIndentor().indent();
        this.print("def ");
        this.printDefNode(defnNode, defnNode.getName(), defnNode.getArgsNode(), defnNode.getScope(), defnNode.getBodyNode());
        return null;
    }

    @Override
    public Instruction visitDefsNode(DefsNode defsNode) {
        this.config.getIndentor().indent();
        this.print("def ");
        this.visitNode(defsNode.getReceiverNode());
        this.print('.');
        this.printDefNode(defsNode, defsNode.getName(), defsNode.getArgsNode(), defsNode.getScope(), defsNode.getBodyNode());
        return null;
    }

    @Override
    public Instruction visitDotNode(DotNode dotNode) {
        this.enterCall();
        this.visitNode(dotNode.getBeginNode());
        this.print("..");
        if (dotNode.isExclusive()) {
            this.print('.');
        }
        this.visitNode(dotNode.getEndNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Instruction visitEnsureNode(EnsureNode ensureNode) {
        this.visitNode(ensureNode.getBodyNode());
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.print("ensure");
        this.visitNodeInIndentation(ensureNode.getEnsureNode());
        this.config.getIndentor().indent();
        return null;
    }

    @Override
    public Instruction visitEvStrNode(EvStrNode evStrNode) {
        this.print('#');
        if (!(evStrNode.getBody() instanceof NthRefNode)) {
            this.print('{');
        }
        this.config.getPrintQuotesInString().set(true);
        this.visitNode(this.unwrapNewlineNode(evStrNode.getBody()));
        this.config.getPrintQuotesInString().revert();
        if (!(evStrNode.getBody() instanceof NthRefNode)) {
            this.print('}');
        }
        return null;
    }

    private Node unwrapNewlineNode(Node node) {
        return node instanceof NewlineNode ? ((NewlineNode)node).getNextNode() : node;
    }

    @Override
    public Instruction visitFCallNode(FCallNode fCallNode) {
        this.print(fCallNode.getName());
        if (fCallNode.getIterNode() != null) {
            this.config.getCallDepth().enterCall();
        }
        this.printCallArguments(fCallNode.getArgsNode(), fCallNode.getIterNode());
        if (fCallNode.getIterNode() != null) {
            this.config.getCallDepth().leaveCall();
        }
        if (!(fCallNode.getIterNode() instanceof BlockPassNode)) {
            this.visitNode(fCallNode.getIterNode());
        }
        return null;
    }

    @Override
    public Instruction visitFalseNode(FalseNode falseNode) {
        this.print("false");
        return null;
    }

    @Override
    public Instruction visitFixnumNode(FixnumNode fixnumNode) {
        this.print(fixnumNode.getValue());
        return null;
    }

    @Override
    public Instruction visitFlipNode(FlipNode flipNode) {
        this.enterCall();
        this.visitNode(flipNode.getBeginNode());
        this.print(" ..");
        if (flipNode.isExclusive()) {
            this.print('.');
        }
        this.print(' ');
        this.visitNode(flipNode.getEndNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Instruction visitFloatNode(FloatNode floatNode) {
        this.print(floatNode.getValue());
        return null;
    }

    @Override
    public Instruction visitForNode(ForNode forNode) {
        this.print("for ");
        this.visitNode(forNode.getVarNode());
        this.print(" in ");
        this.visitNode(forNode.getIterNode());
        this.visitNodeInIndentation(forNode.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Instruction visitGlobalAsgnNode(GlobalAsgnNode globalAsgnNode) {
        this.printAsgnNode(globalAsgnNode);
        return null;
    }

    @Override
    public Instruction visitGlobalVarNode(GlobalVarNode globalVarNode) {
        this.print(globalVarNode.getName());
        return null;
    }

    private void printHashNodeContent(HashNode hashNode) {
        this.print(this.config.getFormatHelper().beforeHashContent());
        if (hashNode.getListNode() != null) {
            Iterator<Node> iterator = hashNode.getListNode().childNodes().iterator();
            while (iterator.hasNext()) {
                this.visitNode(iterator.next());
                this.print(this.config.getFormatHelper().hashAssignment());
                this.visitNode(iterator.next());
                if (!iterator.hasNext()) continue;
                this.print(this.config.getFormatHelper().getListSeparator());
            }
        }
        this.print(this.config.getFormatHelper().afterHashContent());
    }

    @Override
    public Instruction visitHashNode(HashNode hashNode) {
        this.print('{');
        this.printHashNodeContent(hashNode);
        this.print('}');
        return null;
    }

    private void printAsgnNode(AssignableNode assignableNode) {
        this.print(((INameNode)((Object)assignableNode)).getName());
        if (assignableNode.getValueNode() == null || assignableNode.getValueNode().isInvisible()) {
            return;
        }
        this.printAssignmentOperator();
        this.visitNewlineInParentheses(assignableNode.getValueNode());
    }

    @Override
    public Instruction visitInstAsgnNode(InstAsgnNode instAsgnNode) {
        this.printAsgnNode(instAsgnNode);
        return null;
    }

    @Override
    public Instruction visitInstVarNode(InstVarNode instVarNode) {
        this.print(instVarNode.getName());
        return null;
    }

    private Node printElsIfNodes(Node node) {
        if (node != null && node instanceof IfNode) {
            IfNode ifNode = (IfNode)node;
            this.printNewlineAndIndentation();
            this.print("elsif ");
            this.visitNode(ifNode.getCondition());
            this.visitNodeInIndentation(ifNode.getThenBody());
            return this.printElsIfNodes(ifNode.getElseBody());
        }
        return node != null ? node : null;
    }

    private Instruction printShortIfStatement(IfNode ifNode) {
        if (ifNode.getThenBody() == null) {
            this.visitNode(ifNode.getElseBody());
            this.print(" unless ");
            this.visitNode(ifNode.getCondition());
        } else {
            this.enterCall();
            this.factory.createShortIfNodeReWriteVisitor().visitNode(ifNode.getCondition());
            this.print(" ? ");
            this.factory.createShortIfNodeReWriteVisitor().visitNode(ifNode.getThenBody());
            this.print(" : ");
            this.factory.createShortIfNodeReWriteVisitor().visitNewlineInParentheses(ifNode.getElseBody());
            this.leaveCall();
        }
        return null;
    }

    private boolean isAssignment(Node node) {
        return node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode || node instanceof LocalAsgnNode || node instanceof ClassVarAsgnNode;
    }

    private boolean sourceSubStringEquals(int n, int n2, String string) {
        return this.config.getSource().length() >= n + n2 && this.config.getSource().substring(n, n + n2).equals(string);
    }

    private boolean isShortIfStatement(IfNode ifNode) {
        return this.isOnSingleLine(ifNode.getCondition(), ifNode.getElseBody()) && !(ifNode.getElseBody() instanceof IfNode) && !this.sourceSubStringEquals(ReWriteVisitor.getStartOffset(ifNode), 2, "if");
    }

    @Override
    public Instruction visitIfNode(IfNode ifNode) {
        if (this.isShortIfStatement(ifNode)) {
            return this.printShortIfStatement(ifNode);
        }
        this.print("if ");
        if (this.isAssignment(ifNode.getCondition())) {
            this.enterCall();
        }
        this.visitNewlineInParentheses(ifNode.getCondition());
        if (this.isAssignment(ifNode.getCondition())) {
            this.leaveCall();
        }
        this.config.getIndentor().indent();
        if (!ReWriteVisitor.isStartOnNewLine(ifNode.getCondition(), ifNode.getThenBody()) && ifNode.getThenBody() != null) {
            this.printNewlineAndIndentation();
        }
        this.visitNode(ifNode.getThenBody());
        this.config.getIndentor().outdent();
        Node node = this.printElsIfNodes(ifNode.getElseBody());
        if (node != null) {
            this.printNewlineAndIndentation();
            this.print("else");
            this.config.getIndentor().indent();
            this.visitNode(node);
            this.config.getIndentor().outdent();
        }
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    private boolean isOnSingleLine(Node node) {
        return this.isOnSingleLine(node, node);
    }

    private boolean isOnSingleLine(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        return ReWriteVisitor.getStartLine(node) == ReWriteVisitor.getEndLine(node2);
    }

    private boolean printIterVarNode(IterNode iterNode) {
        if (iterNode.getVarNode() == null) {
            return false;
        }
        this.print('|');
        this.visitNode(iterNode.getVarNode());
        this.print('|');
        return true;
    }

    @Override
    public Instruction visitIterNode(IterNode iterNode) {
        if (this.isOnSingleLine(iterNode)) {
            this.print(this.config.getFormatHelper().beforeIterBrackets());
            this.print("{");
            this.print(this.config.getFormatHelper().beforeIterVars());
            if (this.printIterVarNode(iterNode)) {
                this.print(this.config.getFormatHelper().afterIterVars());
            }
            this.config.setSkipNextNewline(true);
            this.visitNode(iterNode.getBodyNode());
            this.print(this.config.getFormatHelper().beforeClosingIterBrackets());
            this.print('}');
        } else {
            this.print(" do ");
            this.printIterVarNode(iterNode);
            this.visitNodeInIndentation(iterNode.getBodyNode());
            this.printNewlineAndIndentation();
            this.print("end");
        }
        return null;
    }

    @Override
    public Instruction visitLocalAsgnNode(LocalAsgnNode localAsgnNode) {
        this.config.getLocalVariables().addLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getName());
        this.printAsgnNode(localAsgnNode);
        return null;
    }

    @Override
    public Instruction visitLocalVarNode(LocalVarNode localVarNode) {
        this.print(localVarNode.getName());
        return null;
    }

    @Override
    public Instruction visitMultipleAsgnNode(MultipleAsgnNode multipleAsgnNode) {
        if (multipleAsgnNode.getHeadNode() != null) {
            this.factory.createMultipleAssignmentReWriteVisitor().visitAndPrintWithSeparator(multipleAsgnNode.getHeadNode().childNodes().iterator());
        }
        if (multipleAsgnNode.getValueNode() == null || multipleAsgnNode.getValueNode().isInvisible()) {
            this.visitNode(multipleAsgnNode.getArgsNode());
            return null;
        }
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.enterCall();
        if (multipleAsgnNode.getValueNode() instanceof ArrayNode) {
            this.visitAndPrintWithSeparator(multipleAsgnNode.getValueNode().childNodes().iterator());
        } else {
            this.visitNode(multipleAsgnNode.getValueNode());
        }
        this.leaveCall();
        return null;
    }

    @Override
    public Instruction visitMatch2Node(Match2Node match2Node) {
        this.visitNode(match2Node.getReceiverNode());
        this.print(this.config.getFormatHelper().matchOperator());
        this.enterCall();
        this.visitNode(match2Node.getValueNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Instruction visitMatch3Node(Match3Node match3Node) {
        this.visitNode(match3Node.getValueNode());
        this.print(this.config.getFormatHelper().matchOperator());
        this.visitNode(match3Node.getReceiverNode());
        return null;
    }

    @Override
    public Instruction visitMatchNode(MatchNode matchNode) {
        this.visitNode(matchNode.getRegexpNode());
        return null;
    }

    @Override
    public Instruction visitModuleNode(ModuleNode moduleNode) {
        this.print("module ");
        this.config.getIndentor().indent();
        this.visitNode(moduleNode.getCPath());
        this.visitNode(moduleNode.getBodyNode());
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Instruction visitNewlineNode(NewlineNode newlineNode) {
        if (this.config.isSkipNextNewline()) {
            this.config.setSkipNextNewline(false);
        } else {
            this.printNewlineAndIndentation();
        }
        this.visitNode(newlineNode.getNextNode());
        return null;
    }

    @Override
    public Instruction visitNextNode(NextNode nextNode) {
        this.print("next");
        return null;
    }

    @Override
    public Instruction visitNilNode(NilNode nilNode) {
        this.print("nil");
        return null;
    }

    @Override
    public Instruction visitNotNode(NotNode notNode) {
        if (notNode.getConditionNode() instanceof CallNode) {
            this.enterCall();
        }
        this.print(this.sourceRangeContains(notNode.getPosition(), "not") ? "not " : "!");
        this.visitNewlineInParentheses(notNode.getConditionNode());
        if (notNode.getConditionNode() instanceof CallNode) {
            this.leaveCall();
        }
        return null;
    }

    @Override
    public Instruction visitNthRefNode(NthRefNode nthRefNode) {
        this.print('$');
        this.print(nthRefNode.getMatchNumber());
        return null;
    }

    private boolean isSimpleNode(Node node) {
        return node instanceof LocalVarNode || node instanceof AssignableNode || node instanceof InstVarNode || node instanceof ClassVarNode || node instanceof GlobalVarNode || node instanceof ConstDeclNode || node instanceof VCallNode || this.isNumericNode(node);
    }

    @Override
    public Instruction visitOpElementAsgnNode(OpElementAsgnNode opElementAsgnNode) {
        if (!this.isSimpleNode(opElementAsgnNode.getReceiverNode())) {
            this.visitNewlineInParentheses(opElementAsgnNode.getReceiverNode());
        } else {
            this.visitNode(opElementAsgnNode.getReceiverNode());
        }
        this.visitNode(opElementAsgnNode.getArgsNode());
        this.print(' ');
        this.print(opElementAsgnNode.getOperatorName());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.visitNode(opElementAsgnNode.getValueNode());
        return null;
    }

    @Override
    public Instruction visitOpAsgnNode(OpAsgnNode opAsgnNode) {
        this.visitNode(opAsgnNode.getReceiverNode());
        this.print('.');
        this.print(opAsgnNode.getVariableName());
        this.print(' ');
        this.print(opAsgnNode.getOperatorName());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.visitNode(opAsgnNode.getValueNode());
        return null;
    }

    private void printOpAsgnNode(Node node, String string) {
        this.enterCall();
        this.print(((INameNode)((Object)node)).getName());
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print(string);
        this.print(this.config.getFormatHelper().afterAssignment());
        this.visitNode(((AssignableNode)node).getValueNode());
        this.leaveCall();
    }

    @Override
    public Instruction visitOpAsgnAndNode(OpAsgnAndNode opAsgnAndNode) {
        this.printOpAsgnNode(opAsgnAndNode.getSecondNode(), "&&=");
        return null;
    }

    @Override
    public Instruction visitOpAsgnOrNode(OpAsgnOrNode opAsgnOrNode) {
        this.printOpAsgnNode(opAsgnOrNode.getSecondNode(), "||=");
        return null;
    }

    @Override
    public Instruction visitOrNode(OrNode orNode) {
        this.enterCall();
        this.visitNode(orNode.getFirstNode());
        this.leaveCall();
        this.print(this.sourceRangeContains(orNode.getPosition(), "||") ? " || " : " or ");
        this.enterCall();
        this.visitNewlineInParentheses(orNode.getSecondNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Instruction visitPostExeNode(PostExeNode postExeNode) {
        return null;
    }

    @Override
    public Instruction visitPreExeNode(PreExeNode preExeNode) {
        return null;
    }

    @Override
    public Instruction visitRedoNode(RedoNode redoNode) {
        this.print("redo");
        return null;
    }

    private String getFirstRegexpEnclosure(Node node) {
        return this.isSpecialRegexNotation(node) ? "%r(" : "/";
    }

    private String getSecondRegexpEnclosure(Node node) {
        return this.isSpecialRegexNotation(node) ? ")" : "/";
    }

    private boolean isSpecialRegexNotation(Node node) {
        return ReWriteVisitor.getStartOffset(node) >= 2 && this.config.getSource().length() >= ReWriteVisitor.getStartOffset(node) && this.config.getSource().charAt(ReWriteVisitor.getStartOffset(node) - 3) == '%';
    }

    private void printRegexpOptions(int n) {
        if ((n & 1) == 1) {
            this.print('i');
        }
        if ((n & 2) == 2) {
            this.print('x');
        }
        if ((n & 4) == 4) {
            this.print('m');
        }
    }

    @Override
    public Instruction visitRegexpNode(RegexpNode regexpNode) {
        this.print(this.getFirstRegexpEnclosure(regexpNode));
        this.print(regexpNode.getValue().toString());
        this.print(this.getSecondRegexpEnclosure(regexpNode));
        this.printRegexpOptions(regexpNode.getOptions());
        return null;
    }

    public static Node firstChild(Node node) {
        if (node == null || node.childNodes().size() <= 0) {
            return null;
        }
        return node.childNodes().get(0);
    }

    @Override
    public Instruction visitRescueBodyNode(RescueBodyNode rescueBodyNode) {
        if (!rescueBodyNode.getBodyNode().isInvisible() && this.config.getLastPosition().getStartLine() == ReWriteVisitor.getEndLine(rescueBodyNode.getBodyNode())) {
            this.print(" rescue ");
        } else {
            this.print("rescue");
        }
        if (rescueBodyNode.getExceptionNodes() != null) {
            this.printExceptionNode(rescueBodyNode);
        } else {
            this.visitNodeInIndentation(rescueBodyNode.getBodyNode());
        }
        if (rescueBodyNode.getOptRescueNode() != null) {
            this.printNewlineAndIndentation();
        }
        this.visitNode(rescueBodyNode.getOptRescueNode());
        return null;
    }

    private void printExceptionNode(RescueBodyNode rescueBodyNode) {
        if (rescueBodyNode.getExceptionNodes() == null) {
            return;
        }
        this.print(' ');
        this.visitNode(ReWriteVisitor.firstChild(rescueBodyNode.getExceptionNodes()));
        Node node = rescueBodyNode.getBodyNode();
        if (rescueBodyNode.getBodyNode() instanceof BlockNode) {
            node = ReWriteVisitor.firstChild(rescueBodyNode.getBodyNode());
        }
        if (node instanceof AssignableNode) {
            this.print(this.config.getFormatHelper().beforeAssignment());
            this.print("=>");
            this.print(this.config.getFormatHelper().afterAssignment());
            this.print(((INameNode)((Object)node)).getName());
            if (node instanceof LocalAsgnNode) {
                this.config.getLocalVariables().addLocalVariable(((LocalAsgnNode)node).getIndex(), ((LocalAsgnNode)node).getName());
            }
            this.config.getIndentor().indent();
            this.visitIterAndSkipFirst(rescueBodyNode.getBodyNode().childNodes().iterator());
            this.config.getIndentor().outdent();
        } else {
            this.visitNodeInIndentation(rescueBodyNode.getBodyNode());
        }
    }

    @Override
    public Instruction visitRescueNode(RescueNode rescueNode) {
        this.visitNode(rescueNode.getBodyNode());
        this.config.getIndentor().outdent();
        if (!rescueNode.getRescueNode().getBodyNode().isInvisible() && ReWriteVisitor.getStartLine(rescueNode) != ReWriteVisitor.getEndLine(rescueNode.getRescueNode().getBodyNode())) {
            this.printNewlineAndIndentation();
        }
        if (rescueNode.getRescueNode().getBodyNode().isInvisible()) {
            this.printNewlineAndIndentation();
            this.print("rescue");
            this.printExceptionNode(rescueNode.getRescueNode());
        } else {
            this.visitNode(rescueNode.getRescueNode());
        }
        if (rescueNode.getElseNode() != null) {
            this.printNewlineAndIndentation();
            this.print("else");
            this.visitNodeInIndentation(rescueNode.getElseNode());
        }
        this.config.getIndentor().indent();
        return null;
    }

    @Override
    public Instruction visitRetryNode(RetryNode retryNode) {
        this.print("retry");
        return null;
    }

    public static Node unwrapSingleArrayNode(Node node) {
        if (!(node instanceof ArrayNode)) {
            return node;
        }
        if (((ArrayNode)node).childNodes().size() > 1) {
            return node;
        }
        return ReWriteVisitor.firstChild((ArrayNode)node);
    }

    @Override
    public Instruction visitReturnNode(ReturnNode returnNode) {
        this.print("return");
        this.enterCall();
        if (!returnNode.getValueNode().isInvisible()) {
            this.print(' ');
            this.visitNode(ReWriteVisitor.unwrapSingleArrayNode(returnNode.getValueNode()));
        }
        this.leaveCall();
        return null;
    }

    @Override
    public Instruction visitSClassNode(SClassNode sClassNode) {
        this.print("class << ");
        this.config.getIndentor().indent();
        this.visitNode(sClassNode.getReceiverNode());
        this.visitNode(sClassNode.getBodyNode());
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Instruction visitSelfNode(SelfNode selfNode) {
        this.print("self");
        return null;
    }

    @Override
    public Instruction visitSplatNode(SplatNode splatNode) {
        this.print("*");
        this.visitNode(splatNode.getValue());
        return null;
    }

    private boolean stringIsHereDocument(StrNode strNode) {
        return this.sourceRangeEquals(ReWriteVisitor.getStartOffset(strNode) + 1, ReWriteVisitor.getStartOffset(strNode) + 3, "<<") || this.sourceRangeEquals(ReWriteVisitor.getStartOffset(strNode), ReWriteVisitor.getStartOffset(strNode) + 3, "<<-");
    }

    protected char getSeparatorForSym(Node node) {
        if (this.config.getSource().length() >= ReWriteVisitor.getStartOffset(node) + 1 && this.config.getSource().charAt(ReWriteVisitor.getStartOffset(node) + 1) == '\'') {
            return '\'';
        }
        return '\"';
    }

    protected char getSeparatorForStr(Node node) {
        if (this.config.getSource().length() >= ReWriteVisitor.getStartOffset(node) && this.config.getSource().charAt(ReWriteVisitor.getStartOffset(node)) == '\'') {
            return '\'';
        }
        return '\"';
    }

    protected boolean inDRegxNode() {
        return false;
    }

    @Override
    public Instruction visitStrNode(StrNode strNode) {
        if (this.stringIsHereDocument(strNode)) {
            this.print("<<-EOF");
            this.config.depositHereDocument(strNode.getValue().toString());
            return null;
        }
        if (strNode.getValue().equals((Object)"")) {
            if (this.config.getPrintQuotesInString().isTrue()) {
                this.print("\"\"");
            }
            return null;
        }
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(strNode));
        }
        if (this.inDRegxNode()) {
            this.print(strNode.getValue().toString());
        } else {
            Matcher matcher = Pattern.compile("([\\\\\\n\\f\\r\\t\\\"\\'])").matcher(strNode.getValue().toString());
            if (matcher.find()) {
                String string = ReWriteVisitor.unescapeChar(matcher.group(1).charAt(0));
                this.print(matcher.replaceAll("\\\\" + string));
            } else {
                this.print(strNode.getValue().toString());
            }
        }
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(strNode));
        }
        return null;
    }

    public static String unescapeChar(char c) {
        switch (c) {
            case '\n': {
                return "n";
            }
            case '\f': {
                return "f";
            }
            case '\r': {
                return "r";
            }
            case '\t': {
                return "t";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private boolean needsSuperNodeParentheses(SuperNode superNode) {
        return superNode.getArgsNode().childNodes().isEmpty() && this.config.getSource().charAt(ReWriteVisitor.getEndOffset(superNode)) == '(';
    }

    @Override
    public Instruction visitSuperNode(SuperNode superNode) {
        this.print("super");
        if (this.needsSuperNodeParentheses(superNode)) {
            this.print('(');
        }
        this.printCallArguments(superNode.getArgsNode(), superNode.getIterNode());
        if (this.needsSuperNodeParentheses(superNode)) {
            this.print(')');
        }
        return null;
    }

    @Override
    public Instruction visitSValueNode(SValueNode sValueNode) {
        this.visitNode(sValueNode.getValue());
        return null;
    }

    @Override
    public Instruction visitSymbolNode(SymbolNode symbolNode) {
        this.print(':');
        this.print(symbolNode.getName());
        return null;
    }

    @Override
    public Instruction visitToAryNode(ToAryNode toAryNode) {
        this.visitNode(toAryNode.getValue());
        return null;
    }

    @Override
    public Instruction visitTrueNode(TrueNode trueNode) {
        this.print("true");
        return null;
    }

    @Override
    public Instruction visitUndefNode(UndefNode undefNode) {
        this.print("undef ");
        this.print(undefNode.getName());
        return null;
    }

    @Override
    public Instruction visitUntilNode(UntilNode untilNode) {
        this.print("until ");
        this.visitNode(untilNode.getConditionNode());
        this.visitNodeInIndentation(untilNode.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Instruction visitVAliasNode(VAliasNode vAliasNode) {
        this.print("alias ");
        this.print(vAliasNode.getNewName());
        this.print(' ');
        this.print(vAliasNode.getOldName());
        return null;
    }

    @Override
    public Instruction visitVCallNode(VCallNode vCallNode) {
        this.print(vCallNode.getName());
        return null;
    }

    public void visitNodeInIndentation(Node node) {
        this.config.getIndentor().indent();
        this.visitNode(node);
        this.config.getIndentor().outdent();
    }

    @Override
    public Instruction visitWhenNode(WhenNode whenNode) {
        this.printNewlineAndIndentation();
        this.print("when ");
        this.enterCall();
        this.visitAndPrintWithSeparator(whenNode.getExpressionNodes().childNodes().iterator());
        this.leaveCall();
        this.visitNodeInIndentation(whenNode.getBodyNode());
        if (whenNode.getNextCase() instanceof WhenNode || whenNode.getNextCase() == null) {
            this.visitNode(whenNode.getNextCase());
        } else {
            this.printNewlineAndIndentation();
            this.print("else");
            this.visitNodeInIndentation(whenNode.getNextCase());
        }
        return null;
    }

    protected void visitNewlineInParentheses(Node node) {
        if (node instanceof NewlineNode) {
            if (((NewlineNode)node).getNextNode() instanceof SplatNode) {
                this.print('[');
                this.visitNode(((NewlineNode)node).getNextNode());
                this.print(']');
            } else {
                this.print('(');
                this.visitNode(((NewlineNode)node).getNextNode());
                this.print(')');
            }
        } else {
            this.visitNode(node);
        }
    }

    private void printWhileStatement(WhileNode whileNode) {
        this.print("while ");
        if (this.isAssignment(whileNode.getConditionNode())) {
            this.enterCall();
        }
        this.visitNewlineInParentheses(whileNode.getConditionNode());
        if (this.isAssignment(whileNode.getConditionNode())) {
            this.leaveCall();
        }
        this.visitNodeInIndentation(whileNode.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
    }

    private void printDoWhileStatement(WhileNode whileNode) {
        this.print("begin");
        this.visitNodeInIndentation(whileNode.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end while ");
        this.visitNode(whileNode.getConditionNode());
    }

    @Override
    public Instruction visitWhileNode(WhileNode whileNode) {
        if (whileNode.evaluateAtStart()) {
            this.printWhileStatement(whileNode);
        } else {
            this.printDoWhileStatement(whileNode);
        }
        return null;
    }

    @Override
    public Instruction visitXStrNode(XStrNode xStrNode) {
        this.print('`');
        this.print(xStrNode.getValue().toString());
        this.print('`');
        return null;
    }

    @Override
    public Instruction visitYieldNode(YieldNode yieldNode) {
        this.print("yield");
        if (yieldNode.getArgsNode() != null) {
            this.print(this.needsParentheses(yieldNode.getArgsNode()) ? (char)'(' : ' ');
            this.enterCall();
            if (yieldNode.getArgsNode() instanceof ArrayNode) {
                this.visitAndPrintWithSeparator(yieldNode.getArgsNode().childNodes().iterator());
            } else {
                this.visitNode(yieldNode.getArgsNode());
            }
            this.leaveCall();
            if (this.needsParentheses(yieldNode.getArgsNode())) {
                this.print(')');
            }
        }
        return null;
    }

    @Override
    public Instruction visitZArrayNode(ZArrayNode zArrayNode) {
        this.print("[]");
        return null;
    }

    @Override
    public Instruction visitZSuperNode(ZSuperNode zSuperNode) {
        this.print("super");
        return null;
    }

    private static int getStartLine(Node node) {
        return node.getPosition().getStartLine();
    }

    private static int getStartOffset(Node node) {
        return node.getPosition().getStartOffset();
    }

    private static int getEndLine(Node node) {
        return node.getPosition().getEndLine();
    }

    protected static int getEndOffset(Node node) {
        return node.getPosition().getEndOffset();
    }

    public ReWriterContext getConfig() {
        return this.config;
    }

    public static String createCodeFromNode(Node node, String string) {
        return ReWriteVisitor.createCodeFromNode(node, string, new DefaultFormatHelper());
    }

    public static String createCodeFromNode(Node node, String string, FormatHelper formatHelper) {
        StringWriter stringWriter = new StringWriter();
        ReWriterContext reWriterContext = new ReWriterContext(stringWriter, string, formatHelper);
        ReWriteVisitor reWriteVisitor = new ReWriteVisitor(reWriterContext);
        reWriteVisitor.visitNode(node);
        return stringWriter.toString();
    }

    @Override
    public Instruction visitArgsPushNode(ArgsPushNode argsPushNode) {
        assert (false) : "Unhandled node";
        return null;
    }

    @Override
    public Instruction visitAttrAssignNode(AttrAssignNode attrAssignNode) {
        if (attrAssignNode.getName().equals("[]=")) {
            return this.printIndexAssignment(attrAssignNode);
        }
        if (attrAssignNode.getName().endsWith("=")) {
            this.visitNode(attrAssignNode.getReceiverNode());
            this.print('.');
            this.printNameWithoutEqualSign(attrAssignNode);
            this.printAssignmentOperator();
            if (attrAssignNode.getArgsNode() != null) {
                this.visitAndPrintWithSeparator(attrAssignNode.getArgsNode().childNodes().iterator());
            }
        } else assert (false) : "Unhandled AttrAssignNode";
        return null;
    }

    private void printNameWithoutEqualSign(INameNode iNameNode) {
        this.print(iNameNode.getName().substring(0, iNameNode.getName().length() - 1));
    }

    @Override
    public Instruction visitRootNode(RootNode rootNode) {
        this.config.getLocalVariables().addLocalVariable(rootNode.getStaticScope());
        this.visitNode(rootNode.getBodyNode());
        if (this.config.hasHereDocument()) {
            this.config.fetchHereDocument().print();
        }
        return null;
    }
}

