/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int baseVariableIndex;

    public StackBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, SkinnyMethodAdapter skinnyMethodAdapter, StaticScope staticScope, boolean bl, int n, int n2) {
        super(abstractMethodCompiler, skinnyMethodAdapter, staticScope, bl, n, n2);
        this.baseVariableIndex = n2;
    }

    public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
        if (staticScope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += staticScope.getNumberOfVariables();
        }
        if (compilerCallback != null) {
            compilerCallback.call(this.methodCompiler);
        }
    }

    public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
        throw new NotCompilableException("ERROR: stack-based variables should not be compiling class bodies");
    }

    public void beginClosure(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (staticScope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += staticScope.getNumberOfVariables();
        }
        if (compilerCallback != null) {
            this.method.aload(this.argsIndex);
            compilerCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    public void assignLocalVariable(int n) {
        this.method.dup();
        this.method.astore(this.baseVariableIndex + n);
    }

    public void assignLocalVariable(int n, CompilerCallback compilerCallback) {
        compilerCallback.call(this.methodCompiler);
        this.assignLocalVariable(n);
    }

    public void assignLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.assignLocalVariable(n);
        } else {
            this.method.aload(this.methodCompiler.getDynamicScopeIndex());
            this.method.swap();
            this.method.pushInt(n);
            this.method.swap();
            this.method.pushInt(n2);
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
        }
    }

    public void assignLocalVariable(int n, int n2, CompilerCallback compilerCallback) {
        if (n2 == 0) {
            this.assignLocalVariable(n, compilerCallback);
        } else {
            this.method.aload(this.methodCompiler.getDynamicScopeIndex());
            this.method.pushInt(n);
            compilerCallback.call(this.methodCompiler);
            this.method.pushInt(n2);
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
        }
    }

    public void retrieveLocalVariable(int n) {
        this.method.aload(this.baseVariableIndex + n);
    }

    public void retrieveLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.retrieveLocalVariable(n);
        } else {
            this.method.aload(this.methodCompiler.getDynamicScopeIndex());
            this.method.pushInt(n);
            this.method.pushInt(n2);
            this.methodCompiler.loadNil();
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, Integer.TYPE, IRubyObject.class)));
        }
    }
}

