/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyTCPServer(ruby, rubyClass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("TCPServer", ruby.fastGetClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyTCPServer.class);
        ruby.getObject().fastSetConstant("TCPserver", rubyClass);
    }

    public RubyTCPServer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = iRubyObject = iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : this.getRuntime().getNil();
        if (iRubyObject2.isNil()) {
            iRubyObject2 = this.getRuntime().newString("0.0.0.0");
        } else if (iRubyObject2 instanceof RubyFixnum) {
            iRubyObject = iRubyObject2;
            iRubyObject2 = this.getRuntime().newString("0.0.0.0");
        }
        String string = iRubyObject2.convertToString().toString();
        try {
            int n;
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ssc = ServerSocketChannel.open();
            if (iRubyObject instanceof RubyInteger) {
                n = RubyNumeric.fix2int(iRubyObject);
            } else {
                RubyString rubyString = iRubyObject.convertToString();
                RubyInteger rubyInteger = rubyString.convertToInteger(MethodIndex.TO_I, "to_i");
                n = RubyNumeric.fix2int(rubyInteger);
                if (n <= 0) {
                    n = RubyNumeric.fix2int(RubySocket.getservbyname(this.getRuntime().getObject(), new IRubyObject[]{rubyString}));
                }
            }
            this.socket_address = new InetSocketAddress(inetAddress, n);
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(new ChannelDescriptor(this.ssc, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (BindException bindException) {
            throw this.getRuntime().newErrnoEADDRINUSEError();
        }
        catch (IOException iOException) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    /*
     * Loose catch block
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept() {
        RubyTCPSocket rubyTCPSocket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        boolean bl = this.ssc.isBlocking();
        try {
            this.ssc.configureBlocking(false);
            while (true) {
                boolean bl2;
                if (bl2 = threadContext.getThread().selectForAccept(this)) {
                    Object object;
                    try {
                        object = this.ssc.accept();
                        ((SocketChannel)object).finishConnect();
                        rubyTCPSocket.initSocket(new ChannelDescriptor((Channel)object, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
                    }
                    catch (InvalidValueException invalidValueException) {
                        throw this.getRuntime().newErrnoEINVALError();
                    }
                    object = rubyTCPSocket;
                    return object;
                }
                this.getRuntime().getCurrentContext().pollThreadEvents();
                continue;
                break;
            }
            catch (IOException iOException) {
                throw RubyTCPServer.sockerr(this, "problem when accepting");
            }
        }
        finally {
            try {
                this.ssc.configureBlocking(bl);
            }
            catch (IOException iOException) {}
        }
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock() {
        RubyTCPSocket rubyTCPSocket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        Selector selector = null;
        try {
            this.ssc.configureBlocking(false);
            selector = Selector.open();
            SelectionKey selectionKey = this.ssc.register(selector, 16);
            int n = selector.selectNow();
            if (n == 0) {
                throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            try {
                rubyTCPSocket.initSocket(new ChannelDescriptor(this.ssc.accept(), RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException invalidValueException) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            RubyTCPSocket rubyTCPSocket2 = rubyTCPSocket;
            return rubyTCPSocket2;
        }
        catch (IOException iOException) {
            throw RubyTCPServer.sockerr(this, "problem when accepting");
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(IRubyObject iRubyObject) {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"peeraddt"}, rest=true)
    public IRubyObject peeraddr(IRubyObject[] iRubyObjectArray) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(IRubyObject[] iRubyObjectArray) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "new", iRubyObjectArray);
        if (!block.isGiven()) {
            return iRubyObject2;
        }
        try {
            IRubyObject iRubyObject3 = block.yield(threadContext, iRubyObject2);
            return iRubyObject3;
        }
        finally {
            iRubyObject2.callMethod(threadContext, "close");
        }
    }
}

