/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNativeThread
extends Thread {
    private Ruby runtime;
    private Frame currentFrame;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private static boolean warnedAboutTC = false;

    public RubyNativeThread(RubyThread rubyThread, IRubyObject[] iRubyObjectArray, Block block) {
        super(rubyThread.getRuntime().getThreadService().getRubyThreadGroup(), "Ruby Thread" + rubyThread.hash());
        this.setDaemon(true);
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext threadContext = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, block);
        this.currentFrame = threadContext.getCurrentFrame();
        this.arguments = iRubyObjectArray;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadContext threadContext;
        block34: {
            threadContext = this.runtime.getThreadService().registerNewThread(this.rubyThread);
            try {
                Thread.currentThread().setContextClassLoader(this.runtime.getJRubyClassLoader());
            }
            catch (SecurityException securityException) {
                if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block34;
                System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
            }
        }
        threadContext.preRunThread(this.currentFrame);
        try {
            IRubyObject iRubyObject = this.proc.call(threadContext, this.arguments);
            this.rubyThread.cleanTerminate(iRubyObject);
        }
        catch (ThreadKill threadKill) {
            Object object = this.rubyThread.killLock;
            synchronized (object) {
                this.rubyThread.killLock.notifyAll();
            }
        }
        catch (JumpException.ReturnJump returnJump) {
            this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
        }
        catch (RaiseException raiseException) {
            this.rubyThread.exceptionRaised(raiseException);
        }
        catch (MainExitException mainExitException) {
            this.runtime.getThreadService().getMainThread().kill();
        }
        finally {
            this.runtime.getThreadService().setCritical(false);
            this.runtime.getThreadService().unregisterThread(this.rubyThread);
            RubyThread rubyThread = this.rubyThread;
            synchronized (rubyThread) {
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
            }
        }
    }
}

