/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedJavaMethod
extends JavaMethod {
    private final Method method;
    private final boolean needsBlock;
    private final boolean isStatic;
    private final int required;
    private final int optional;
    private final boolean rest;
    private final int max;
    private final boolean argsAsIs;
    private final boolean needsThreadContext;

    public ReflectedJavaMethod(RubyModule rubyModule, Method method, JRubyMethod jRubyMethod) {
        super(rubyModule, jRubyMethod.visibility());
        this.method = method;
        Class[] classArray = method.getParameterTypes();
        this.needsBlock = classArray.length > 0 && classArray[classArray.length - 1] == Block.class;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        Arity arity = Arity.fromAnnotation(jRubyMethod, classArray, this.isStatic);
        this.setArity(arity);
        this.required = arity.getValue() >= 0 ? arity.getValue() : Math.abs(arity.getValue()) - 1;
        this.optional = jRubyMethod.optional();
        this.rest = jRubyMethod.rest();
        this.needsThreadContext = classArray.length > 0 && classArray[0] == ThreadContext.class;
        this.argsAsIs = !this.isStatic && this.optional == 0 && !this.rest && !this.needsBlock && !this.needsThreadContext;
        this.max = this.rest ? -1 : this.required + this.optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext var1_1, IRubyObject var2_2, RubyModule var3_3, String var4_4, IRubyObject[] var5_5, Block var6_6) {
        var7_7 = var1_1.getRuntime();
        Arity.checkArgumentCount(var7_7, var5_5, this.required, this.max);
        this.callConfig.pre(var1_1, var2_2, this.getImplementationClass(), var4_4, var6_6, null, this);
        if (!this.isStatic && !this.method.getDeclaringClass().isAssignableFrom(var2_2.getClass())) {
            throw new ClassCastException(var2_2.getClass().getName() + " cannot be converted to " + this.method.getDeclaringClass().getName());
        }
        if (this.argsAsIs) {
            var8_8 = var7_7.hasEventHooks();
            try {
                if (var8_8 != 0) {
                    var7_7.callEventHooks(var1_1, 5, var1_1.getFile(), var1_1.getLine(), var4_4, this.getImplementationClass());
                }
                var9_12 = (IRubyObject)this.method.invoke((Object)var2_2, (Object[])var5_5);
                return var9_12;
            }
            finally {
                if (var8_8 != 0) {
                    var7_7.callEventHooks(var1_1, 6, var1_1.getFile(), var1_1.getLine(), var4_4, this.getImplementationClass());
                }
            }
        }
        var8_8 = this.calcArgsLength();
        ** GOTO lbl31
        {
            catch (IllegalArgumentException var8_9) {
                throw RaiseException.createNativeRaiseException(var7_7, var8_9);
            }
            catch (IllegalAccessException var8_10) {
                throw RaiseException.createNativeRaiseException(var7_7, var8_10);
            }
            catch (InvocationTargetException var8_11) {
                var9_13 = var8_11.getCause();
                if (var9_13 instanceof RuntimeException) {
                    throw (RuntimeException)var9_13;
                }
                if (var9_13 instanceof Error == false) throw RaiseException.createNativeRaiseException(var7_7, (Throwable)var9_13);
                throw (Error)var9_13;
            }
lbl31:
            // 1 sources

            var9_13 = new Object[var8_8];
            var10_15 = 0;
            if (this.needsThreadContext) {
                var9_13[var10_15++] = var1_1;
            }
            if (this.isStatic) {
                var9_13[var10_15++] = var2_2;
            }
            if (this.optional == 0 && !this.rest) {
                for (var11_16 = 0; var11_16 < var5_5.length; ++var11_16) {
                    var9_13[var10_15++] = var5_5[var11_16];
                }
            } else {
                var9_13[var10_15++] = var5_5;
            }
            if (this.needsBlock) {
                var9_13[var10_15++] = var6_6;
            }
            var11_16 = (int)var7_7.hasEventHooks();
            try {
                if (var11_16 != 0) {
                    var7_7.callEventHooks(var1_1, 5, var1_1.getFile(), var1_1.getLine(), var4_4, this.getImplementationClass());
                }
                if (this.isStatic) {
                    var12_17 = (IRubyObject)this.method.invoke(null, var9_13);
                    if (var11_16 == 0) return var12_17;
                    var7_7.callEventHooks(var1_1, 6, var1_1.getFile(), var1_1.getLine(), var4_4, this.getImplementationClass());
                    return var12_17;
                }
            }
            catch (Throwable var13_19) {}
            {
                if (var11_16 == 0) throw var13_19;
                var7_7.callEventHooks(var1_1, 6, var1_1.getFile(), var1_1.getLine(), var4_4, this.getImplementationClass());
                throw var13_19;
            }
        }
        {
            var12_18 = (IRubyObject)this.method.invoke((Object)var2_2, var9_13);
            if (var11_16 == 0) return var12_18;
            var7_7.callEventHooks(var1_1, 6, var1_1.getFile(), var1_1.getLine(), var4_4, this.getImplementationClass());
            return var12_18;
        }
        finally {
            this.callConfig.post(var1_1);
        }
    }

    private int calcArgsLength() {
        int n = 0;
        if (this.needsThreadContext) {
            ++n;
        }
        if (this.isStatic) {
            ++n;
        }
        n = this.optional == 0 && !this.rest ? (n += this.required) : ++n;
        if (this.needsBlock) {
            ++n;
        }
        return n;
    }
}

