/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaConstructor"})
public class JavaConstructor
extends JavaCallable {
    private final Constructor<?> constructor;
    private final Class<?>[] parameterTypes;

    public static RubyClass createJavaConstructorClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaConstructor", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(ruby, rubyClass);
        JavaCallable.registerRubyMethods(ruby, rubyClass);
        rubyClass.defineAnnotatedMethods(JavaConstructor.class);
        return rubyClass;
    }

    public JavaConstructor(Ruby ruby, Constructor<?> constructor) {
        super(ruby, ruby.getJavaSupport().getJavaConstructorClass());
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
    }

    public static JavaConstructor create(Ruby ruby, Constructor<?> constructor) {
        return new JavaConstructor(ruby, constructor);
    }

    public static JavaConstructor getMatchingConstructor(Ruby ruby, Class<?> clazz, Class<?>[] classArray) {
        try {
            return JavaConstructor.create(ruby, clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            block2: for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] classArray2 = constructor.getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                if (classArray2.length == 0 && classArray.length == 0) {
                    return JavaConstructor.create(ruby, constructor);
                }
                boolean bl = true;
                for (int i = 0; i < classArray.length; ++i) {
                    if (i >= classArray2.length) {
                        bl = false;
                    }
                    if (!classArray2[i].isAssignableFrom(classArray[i])) {
                        bl = false;
                        continue block2;
                    }
                    bl = true;
                }
                if (!bl) continue;
                return JavaConstructor.create(ruby, constructor);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JavaConstructor && this.constructor == ((JavaConstructor)object).constructor;
    }

    @Override
    public int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    protected String nameOnInspection() {
        return this.getType().toString();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.constructor.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.constructor.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.constructor.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.constructor.isVarArgs();
    }

    @Override
    public int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.constructor.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.constructor;
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.constructor.getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject return_type() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public IRubyObject new_instance(IRubyObject[] iRubyObjectArray) {
        int n = iRubyObjectArray.length;
        Class<?>[] classArray = this.parameterTypes;
        if (n != classArray.length) {
            throw this.getRuntime().newArgumentError(n, classArray.length);
        }
        Object[] objectArray = new Object[n];
        int n2 = n;
        while (--n2 >= 0) {
            objectArray[n2] = JavaUtil.convertArgument(this.getRuntime(), iRubyObjectArray[n2], classArray[n2]);
        }
        try {
            Object obj = this.constructor.newInstance(objectArray);
            return JavaObject.wrap(this.getRuntime(), obj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + ", got [" + objectArray[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access");
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getRuntime().getJavaSupport().handleNativeException(invocationTargetException.getTargetException());
            assert (false);
            return null;
        }
        catch (InstantiationException instantiationException) {
            throw this.getRuntime().newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }
}

