/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class ThreadLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) throws IOException {
        Mutex.setup(ruby);
        ConditionVariable.setup(ruby);
        Queue.setup(ruby);
        SizedQueue.setup(ruby);
    }

    static boolean wait_timeout(IRubyObject iRubyObject, Double d) throws InterruptedException {
        if (d != null) {
            long l;
            long l2 = (long)(d * 1.0E9);
            long l3 = System.nanoTime();
            if (l2 > 0L) {
                l = l2 / 1000000L;
                int n = (int)(l2 % 1000000L);
                iRubyObject.wait(l, n);
            }
            return (l = System.nanoTime()) - l3 <= l2;
        }
        iRubyObject.wait();
        return true;
    }

    @JRubyClass(name={"SizedQueue"}, parent="Queue")
    public static class SizedQueue
    extends Queue {
        private int capacity = 1;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            SizedQueue sizedQueue = new SizedQueue(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            sizedQueue.callInit(iRubyObjectArray, block);
            return sizedQueue;
        }

        public SizedQueue(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("SizedQueue", ruby.fastGetClass("Queue"), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new SizedQueue(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(SizedQueue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear() {
            super.clear();
            this.notifyAll();
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized RubyNumeric max() {
            return RubyNumeric.int2fix(this.getRuntime(), this.capacity);
        }

        @JRubyMethod(name={"max=", "initialize"})
        public synchronized IRubyObject max_set(IRubyObject iRubyObject) {
            int n = RubyNumeric.fix2int(iRubyObject);
            if (n <= 0) {
                this.getRuntime().newArgumentError("queue size must be positive");
            }
            int n2 = n > this.capacity ? n - this.capacity : 0;
            this.capacity = n;
            if (n2 > 0) {
                this.notifyAll();
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject = super.pop(iRubyObjectArray);
            this.notifyAll();
            return iRubyObject;
        }

        @JRubyMethod(name={"push", "<<"})
        public synchronized IRubyObject push(IRubyObject iRubyObject) {
            if (this.java_length() >= (long)this.capacity) {
                ++this.numWaiting;
                while (this.java_length() >= (long)this.capacity) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                --this.numWaiting;
            }
            super.push(iRubyObject);
            this.notifyAll();
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Queue"})
    public static class Queue
    extends RubyObject {
        private LinkedList entries = new LinkedList();
        protected volatile int numWaiting = 0;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Queue queue = new Queue(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            queue.callInit(iRubyObjectArray, block);
            return queue;
        }

        public Queue(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Queue", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new Queue(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(Queue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear() {
            this.entries.clear();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"empty?"})
        public synchronized RubyBoolean empty_p() {
            return this.entries.size() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"length", "size"})
        public synchronized RubyNumeric length() {
            return RubyNumeric.int2fix(this.getRuntime(), this.entries.size());
        }

        protected synchronized long java_length() {
            return this.entries.size();
        }

        @JRubyMethod
        public RubyNumeric num_waiting() {
            return this.getRuntime().newFixnum(this.numWaiting);
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(IRubyObject[] iRubyObjectArray) {
            boolean bl = true;
            if (Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 0, 1) == 1) {
                boolean bl2 = bl = !iRubyObjectArray[0].isTrue();
            }
            if (!bl && this.entries.size() == 0) {
                throw new RaiseException(this.getRuntime(), this.getRuntime().getThreadError(), "queue empty", false);
            }
            ++this.numWaiting;
            while (this.entries.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.numWaiting;
            return (IRubyObject)this.entries.removeFirst();
        }

        @JRubyMethod(name={"push", "<<", "enq"})
        public synchronized IRubyObject push(IRubyObject iRubyObject) {
            this.entries.addLast(iRubyObject);
            this.notify();
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"ConditionVariable"})
    public static class ConditionVariable
    extends RubyObject {
        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static ConditionVariable newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            ConditionVariable conditionVariable = new ConditionVariable(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            conditionVariable.callInit(iRubyObjectArray, block);
            return conditionVariable;
        }

        public ConditionVariable(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("ConditionVariable", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new ConditionVariable(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(ConditionVariable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"wait"}, required=1, optional=1)
        public IRubyObject wait_ruby(IRubyObject[] iRubyObjectArray) throws InterruptedException {
            if (iRubyObjectArray.length < 1) {
                throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            if (iRubyObjectArray.length > 2) {
                throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            if (!(iRubyObjectArray[0] instanceof Mutex)) {
                throw this.getRuntime().newTypeError(iRubyObjectArray[0], this.getRuntime().fastGetClass("Mutex"));
            }
            Mutex mutex = (Mutex)iRubyObjectArray[0];
            Double d = null;
            if (iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil()) {
                d = iRubyObjectArray[1].convertToFloat().getDoubleValue();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean bl = false;
            try {
                ConditionVariable conditionVariable = this;
                synchronized (conditionVariable) {
                    mutex.unlock();
                    try {
                        bl = ThreadLibrary.wait_timeout(this, d);
                    }
                    finally {
                        if (!bl) {
                            this.notify();
                        }
                    }
                }
            }
            finally {
                mutex.lock();
            }
            if (d != null) {
                return this.getRuntime().newBoolean(bl);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized IRubyObject broadcast() {
            this.notifyAll();
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized IRubyObject signal() {
            this.notify();
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Mutex"})
    public static class Mutex
    extends RubyObject {
        private RubyThread owner = null;

        @JRubyMethod(name={"new"}, rest=true, meta=true)
        public static Mutex newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Mutex mutex = new Mutex(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            mutex.callInit(iRubyObjectArray, block);
            return mutex;
        }

        public Mutex(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Mutex", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new Mutex(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(Mutex.class);
        }

        @JRubyMethod(name={"locked?"})
        public synchronized RubyBoolean locked_p() {
            return this.owner != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public RubyBoolean try_lock() throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                if (this.owner != null) {
                    return this.getRuntime().getFalse();
                }
                this.lock();
            }
            return this.getRuntime().getTrue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject lock() throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                try {
                    while (this.owner != null) {
                        this.wait();
                    }
                    this.owner = this.getRuntime().getCurrentContext().getThread();
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
            return this;
        }

        @JRubyMethod
        public synchronized RubyBoolean unlock() {
            if (this.owner != null) {
                this.owner = null;
                this.notify();
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject synchronize(Block block) throws InterruptedException {
            try {
                this.lock();
                IRubyObject iRubyObject = block.yield(this.getRuntime().getCurrentContext(), null);
                return iRubyObject;
            }
            finally {
                this.unlock();
            }
        }
    }
}

