/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class BlockStaticScope
extends StaticScope {
    private static final long serialVersionUID = -3882063260379968149L;

    public BlockStaticScope(StaticScope staticScope) {
        super(staticScope, new String[0]);
    }

    public BlockStaticScope(StaticScope staticScope, String[] stringArray) {
        super(staticScope, stringArray);
    }

    public StaticScope getLocalScope() {
        return this.enclosingScope.getLocalScope();
    }

    public int isDefined(String string, int n) {
        int n2 = this.exists(string);
        if (n2 >= 0) {
            return n << 16 | n2;
        }
        return this.enclosingScope.isDefined(string, n + 1);
    }

    public String[] getAllNamesInScope() {
        String[] stringArray = this.enclosingScope.getAllNamesInScope();
        String[] stringArray2 = this.getVariables();
        int n = stringArray.length + stringArray2.length;
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected AssignableNode assign(ISourcePosition iSourcePosition, String string, Node node, StaticScope staticScope, int n) {
        int n2 = this.exists(string);
        if (n2 >= 0) {
            if (n > 0) {
                this.capture(n2);
            }
            return new DAsgnNode(iSourcePosition, string, n << 16 | n2, node);
        }
        return this.enclosingScope.assign(iSourcePosition, string, node, staticScope, n + 1);
    }

    public AssignableNode addAssign(ISourcePosition iSourcePosition, String string, Node node) {
        int n = this.addVariable(string);
        return new DAsgnNode(iSourcePosition, string, n, node);
    }

    public Node declare(ISourcePosition iSourcePosition, String string, int n) {
        int n2 = this.exists(string);
        if (n2 >= 0) {
            if (n > 0) {
                this.capture(n2);
            }
            return new DVarNode(iSourcePosition, n << 16 | n2, string);
        }
        return this.enclosingScope.declare(iSourcePosition, string, n + 1);
    }

    public String toString() {
        return "BlockScope: " + super.toString() + "\n" + this.getEnclosingScope();
    }
}

