/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.ast.Node;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Parser {
    private final Ruby runtime;

    public Parser(Ruby ruby) {
        this.runtime = ruby;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node parseRewriter(String string, InputStream inputStream, ParserConfiguration parserConfiguration) throws SyntaxException {
        DefaultRubyParser defaultRubyParser = RubyParserPool.getInstance().borrowParser();
        try {
            defaultRubyParser.setWarnings(new NullWarnings());
            LexerSource lexerSource = LexerSource.getSource(string, inputStream, null, parserConfiguration);
            Node node = defaultRubyParser.parse(parserConfiguration, lexerSource).getAST();
            return node;
        }
        finally {
            RubyParserPool.getInstance().returnParser(defaultRubyParser);
        }
    }

    public Node parse(String string, ByteList byteList, DynamicScope dynamicScope, ParserConfiguration parserConfiguration) {
        return this.parse(string, new ByteArrayInputStream(byteList.bytes()), dynamicScope, parserConfiguration);
    }

    public Node parse(String string, InputStream inputStream, DynamicScope dynamicScope, ParserConfiguration parserConfiguration) {
        Object object;
        Object object2;
        Object object3;
        IRubyObject iRubyObject = this.runtime.getObject().fastGetConstantAt("SCRIPT_LINES__");
        RubyArray rubyArray = null;
        if (!parserConfiguration.isEvalParse() && iRubyObject != null && iRubyObject instanceof RubyHash) {
            object3 = this.runtime.newString(string);
            object2 = this.runtime.getCurrentContext();
            object = ((RubyHash)iRubyObject).op_aref((ThreadContext)object2, (IRubyObject)object3);
            rubyArray = (RubyArray)(object instanceof RubyArray ? object : this.runtime.newArray());
            ((RubyHash)iRubyObject).op_aset((ThreadContext)object2, (IRubyObject)object3, rubyArray);
        }
        if (dynamicScope != null) {
            parserConfiguration.parseAsBlock(dynamicScope);
        }
        object3 = null;
        object2 = null;
        try {
            object3 = RubyParserPool.getInstance().borrowParser();
            ((DefaultRubyParser)object3).setWarnings(this.runtime.getWarnings());
            object = LexerSource.getSource(string, inputStream, rubyArray, parserConfiguration);
            object2 = ((DefaultRubyParser)object3).parse(parserConfiguration, (LexerSource)object);
            if (((RubyParserResult)object2).getEndOffset() >= 0) {
                IRubyObject iRubyObject2 = this.runtime.getVerbose();
                this.runtime.setVerbose(this.runtime.getNil());
                this.runtime.defineGlobalConstant("DATA", new RubyFile(this.runtime, string, inputStream));
                this.runtime.setVerbose(iRubyObject2);
                ((RubyParserResult)object2).setEndOffset(-1);
            }
        }
        catch (SyntaxException syntaxException) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(syntaxException.getPosition().getFile()).append(':');
            stringBuilder.append(syntaxException.getPosition().getEndLine() + 1).append(": ");
            stringBuilder.append(syntaxException.getMessage());
            throw this.runtime.newSyntaxError(stringBuilder.toString());
        }
        finally {
            RubyParserPool.getInstance().returnParser((DefaultRubyParser)object3);
        }
        if (((RubyParserResult)object2).getScope() != null) {
            ((RubyParserResult)object2).getScope().growIfNeeded();
        }
        return ((RubyParserResult)object2).getAST();
    }
}

