/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.IArityNode;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Arity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, Arity> arities = new HashMap<Integer, Arity>();
    private final int value;
    public static final Arity NO_ARGUMENTS = Arity.newArity(0);
    public static final Arity ONE_ARGUMENT = Arity.newArity(1);
    public static final Arity TWO_ARGUMENTS = Arity.newArity(2);
    public static final Arity THREE_ARGUMENTS = Arity.newArity(3);
    public static final Arity OPTIONAL = Arity.newArity(-1);
    public static final Arity ONE_REQUIRED = Arity.newArity(-2);
    public static final Arity TWO_REQUIRED = Arity.newArity(-3);
    public static final Arity THREE_REQUIRED = Arity.newArity(-3);

    private Arity(int n) {
        this.value = n;
    }

    public static Arity createArity(int n) {
        switch (n) {
            case -4: {
                return THREE_REQUIRED;
            }
            case -3: {
                return TWO_REQUIRED;
            }
            case -2: {
                return ONE_REQUIRED;
            }
            case -1: {
                return OPTIONAL;
            }
            case 0: {
                return NO_ARGUMENTS;
            }
            case 1: {
                return ONE_ARGUMENT;
            }
            case 2: {
                return TWO_ARGUMENTS;
            }
            case 3: {
                return THREE_ARGUMENTS;
            }
        }
        return Arity.newArity(n);
    }

    public static Arity fromAnnotation(JRubyMethod jRubyMethod) {
        if (jRubyMethod.optional() > 0 || jRubyMethod.rest()) {
            return Arity.createArity(-(jRubyMethod.required() + 1));
        }
        return Arity.createArity(jRubyMethod.required());
    }

    public static Arity fromAnnotation(JRubyMethod jRubyMethod, int n) {
        if (jRubyMethod.optional() > 0 || jRubyMethod.rest()) {
            return Arity.createArity(-(n + 1));
        }
        return Arity.createArity(n);
    }

    public static Arity fromAnnotation(JRubyMethod jRubyMethod, Class[] classArray, boolean bl) {
        int n = 0;
        if (jRubyMethod.optional() == 0 && !jRubyMethod.rest() && jRubyMethod.required() == 0) {
            int n2 = classArray.length;
            if (bl) {
                --n2;
            }
            if (classArray.length > 0) {
                if (classArray[0] == ThreadContext.class) {
                    --n2;
                }
                if (classArray[classArray.length - 1] == Block.class) {
                    --n2;
                }
            }
            n = n2;
        } else {
            n = jRubyMethod.required();
        }
        if (jRubyMethod.optional() > 0 || jRubyMethod.rest()) {
            return Arity.createArity(-(n + 1));
        }
        return Arity.createArity(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Arity newArity(int n) {
        Arity arity;
        Integer n2 = new Integer(n);
        Map<Integer, Arity> map = arities;
        synchronized (map) {
            arity = arities.get(n2);
            if (arity == null) {
                arity = new Arity(n);
                arities.put(n2, arity);
            }
        }
        return arity;
    }

    public static Arity fixed(int n) {
        assert (n >= 0);
        return Arity.createArity(n);
    }

    public static Arity optional() {
        return OPTIONAL;
    }

    public static Arity required(int n) {
        assert (n >= 0);
        return Arity.createArity(-(1 + n));
    }

    public static Arity noArguments() {
        return NO_ARGUMENTS;
    }

    public static Arity singleArgument() {
        return ONE_ARGUMENT;
    }

    public static Arity twoArguments() {
        return TWO_ARGUMENTS;
    }

    public static Arity procArityOf(Node node) {
        if (node instanceof AttrAssignNode && node != null) {
            node = ((AttrAssignNode)node).getArgsNode();
        }
        if (node == null) {
            return Arity.optional();
        }
        if (node instanceof IArityNode) {
            return ((IArityNode)((Object)node)).getArity();
        }
        if (node instanceof CallNode) {
            return Arity.singleArgument();
        }
        if (node instanceof ArrayNode) {
            return Arity.singleArgument();
        }
        throw new Error("unexpected type " + node.getClass() + " at " + node.getPosition());
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        if (this.isFixed() ? iRubyObjectArray.length != this.required() : iRubyObjectArray.length < this.required()) {
            throw ruby.newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + this.required() + ")");
        }
    }

    public boolean isFixed() {
        return this.value >= 0;
    }

    public int required() {
        if (this.value < 0) {
            return -(1 + this.value);
        }
        return this.value;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.isFixed()) {
            return "Fixed" + this.required();
        }
        return "Opt";
    }

    public static int checkArgumentCount(Ruby ruby, IRubyObject[] iRubyObjectArray, int n, int n2) {
        int n3 = iRubyObjectArray.length;
        int n4 = 0;
        if (n3 < n) {
            n4 = n;
        } else if (n2 > -1 && n3 > n2) {
            n4 = n2;
        } else {
            return n3;
        }
        throw ruby.newArgumentError(n3, n4);
    }

    public static void raiseArgumentError(Ruby ruby, int n, int n2, int n3) {
        if (n < n2) {
            throw ruby.newArgumentError(n, n2);
        }
        if (n3 > -1 && n > n3) {
            throw ruby.newArgumentError(n, n3);
        }
    }

    public static IRubyObject[] scanArgs(Ruby ruby, IRubyObject[] iRubyObjectArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = Arity.checkArgumentCount(ruby, iRubyObjectArray, n, n3);
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[n3];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, n4);
        for (int i = n4; i < n3; ++i) {
            iRubyObjectArray2[i] = ruby.getNil();
        }
        return iRubyObjectArray2;
    }
}

