/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import org.jruby.Ruby;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.InvocationCallback;

public abstract class FastInvocationCallback
extends InvocationCallback {
    public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (this.arityValue >= 0) {
            if (iRubyObjectArray.length != this.arityValue) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + this.arityValue + ")");
            }
        } else if (iRubyObjectArray.length < -(1 + this.arityValue)) {
            throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + -(1 + this.arityValue) + ")");
        }
        try {
            return this.call(iRubyObject, iRubyObjectArray);
        }
        catch (RaiseException raiseException) {
            throw raiseException;
        }
        catch (JumpException jumpException) {
            throw jumpException;
        }
        catch (ThreadKill threadKill) {
            throw threadKill;
        }
        catch (MainExitException mainExitException) {
            throw mainExitException;
        }
        catch (Exception exception) {
            Ruby ruby = iRubyObject.getRuntime();
            ruby.getJavaSupport().handleNativeException(exception);
            return ruby.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2);
}

