/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;

public class NormalizedFile
extends File {
    private static final long serialVersionUID = 7630618150344842227L;

    public NormalizedFile(String string) {
        super(string);
    }

    public NormalizedFile(URI uRI) {
        super(uRI);
    }

    public NormalizedFile(File file, String string) {
        super(file, string);
    }

    public NormalizedFile(String string, String string2) {
        super(string, string2);
    }

    public String getAbsolutePath() {
        return new File(super.getPath()).getAbsolutePath().replace(File.separatorChar, '/');
    }

    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath().replace(File.separatorChar, '/');
    }

    public String getPath() {
        return super.getPath().replace(File.separatorChar, '/');
    }

    public String toString() {
        return super.toString().replace(File.separatorChar, '/');
    }

    public File getAbsoluteFile() {
        return new NormalizedFile(this.getAbsolutePath());
    }

    public File getCanonicalFile() throws IOException {
        return new NormalizedFile(this.getCanonicalPath());
    }

    public String getParent() {
        return super.getParent().replace(File.separatorChar, '/');
    }

    public File getParentFile() {
        return new NormalizedFile(this.getParent());
    }

    public static File[] listRoots() {
        File[] fileArray = File.listRoots();
        File[] fileArray2 = new NormalizedFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new NormalizedFile(fileArray[i].getPath());
        }
        return fileArray2;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        return new NormalizedFile(file2.getPath());
    }

    public static File createTempFile(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        return new NormalizedFile(file.getPath());
    }

    public String[] list() {
        return super.list();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = super.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].replace(File.separatorChar, '/');
        }
        return stringArray2;
    }

    public File[] listFiles() {
        File[] fileArray = super.listFiles();
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new NormalizedFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new NormalizedFile(fileArray[i].getPath());
        }
        return fileArray2;
    }

    public File[] listFiles(FileFilter fileFilter) {
        File[] fileArray = super.listFiles(fileFilter);
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new NormalizedFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new NormalizedFile(fileArray[i].getPath());
        }
        return fileArray2;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        File[] fileArray = super.listFiles(filenameFilter);
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new NormalizedFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new NormalizedFile(fileArray[i].getPath());
        }
        return fileArray2;
    }

    public static String getFileProperty(String string) {
        String string2 = System.getProperty(string);
        return string2.replace(File.separatorChar, '/');
    }
}

