/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class OpenFile {
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    public static final int READWRITE = 3;
    public static final int APPEND = 64;
    public static final int CREATE = 128;
    public static final int BINMODE = 4;
    public static final int SYNC = 8;
    public static final int WBUF = 16;
    public static final int RBUF = 32;
    public static final int WSPLIT = 512;
    public static final int WSPLIT_INITIALIZED = 1024;
    public static final int SYNCWRITE = 10;
    private Stream mainStream;
    private Stream pipeStream;
    private int mode;
    private Process process;
    private int lineNumber = 0;
    private String path;
    private Finalizer finalizer;

    public Stream getMainStream() {
        return this.mainStream;
    }

    public void setMainStream(Stream stream) {
        this.mainStream = stream;
    }

    public Stream getPipeStream() {
        return this.pipeStream;
    }

    public void setPipeStream(Stream stream) {
        this.pipeStream = stream;
    }

    public Stream getWriteStream() {
        return this.pipeStream == null ? this.mainStream : this.pipeStream;
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString(Ruby ruby) {
        String string = OpenFile.getStringFromMode(this.mode);
        if (string == null) {
            throw ruby.newArgumentError("Illegal access modenum " + Integer.toOctalString(this.mode));
        }
        return string;
    }

    public static String getStringFromMode(int n) {
        if ((n & 0x40) != 0) {
            if ((n & 3) != 0) {
                return "ab+";
            }
            return "ab";
        }
        switch (n & 3) {
            case 1: {
                return "rb";
            }
            case 2: {
                return "wb";
            }
            case 3: {
                if ((n & 0x80) != 0) {
                    return "wb+";
                }
                return "rb+";
            }
        }
        return null;
    }

    public void checkReadable(Ruby ruby) throws IOException, BadDescriptorException, PipeException, InvalidValueException {
        this.checkClosed(ruby);
        if ((this.mode & 1) == 0) {
            throw ruby.newIOError("not opened for reading");
        }
        if (!((this.mode & 0x10) == 0 && (this.mode & 0x2A) != 10 || this.mainStream.feof() || this.pipeStream != null)) {
            this.seek(0L, 1);
        }
    }

    public void seek(long l, int n) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushBeforeSeek();
        this.getWriteStream().lseek(l, n);
    }

    private void flushBeforeSeek() throws BadDescriptorException, IOException {
        if ((this.mode & 0x10) != 0) {
            this.fflush(this.getWriteStream());
        }
    }

    public void fflush(Stream stream) throws IOException, BadDescriptorException {
        int n;
        while ((n = stream.fflush()) == -1) {
        }
        this.mode &= 0xFFFFFFEF;
    }

    public void checkWritable(Ruby ruby) throws IOException, BadDescriptorException, InvalidValueException, PipeException {
        this.checkClosed(ruby);
        if ((this.mode & 2) == 0) {
            throw ruby.newIOError("not opened for writing");
        }
        if ((this.mode & 0x20) != 0 && !this.mainStream.feof() && this.pipeStream == null) {
            this.seek(0L, 1);
        }
        if (this.pipeStream == null) {
            this.mode &= 0xFFFFFFDF;
        }
    }

    public void checkClosed(Ruby ruby) {
        if (this.mainStream == null && this.pipeStream == null) {
            throw ruby.newIOError("closed stream");
        }
    }

    public boolean isOpen() {
        return this.mainStream != null || this.pipeStream != null;
    }

    public boolean isReadable() {
        return (this.mode & 1) != 0;
    }

    public boolean isWritable() {
        return (this.mode & 2) != 0;
    }

    public boolean isReadBuffered() {
        return (this.mode & 0x20) != 0;
    }

    public void setReadBuffered() {
        this.mode |= 0x20;
    }

    public boolean isWriteBuffered() {
        return (this.mode & 0x10) != 0;
    }

    public void setWriteBuffered() {
        this.mode |= 0x10;
    }

    public void setSync(boolean bl) {
        this.mode = bl ? (this.mode |= 8) : (this.mode &= 0xFFFFFFF7);
    }

    public boolean isSync() {
        return (this.mode & 8) != 0;
    }

    public boolean areBothEOF() throws IOException, BadDescriptorException {
        return this.mainStream.feof() && (this.pipeStream == null || this.pipeStream.feof());
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public Finalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }

    public void cleanup(Ruby ruby, boolean bl) {
        if (this.finalizer != null) {
            this.finalizer.finalize(ruby, bl);
        } else {
            this.finalize(ruby, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize(Ruby ruby, boolean bl) {
        block18: {
            try {
                ChannelDescriptor channelDescriptor = null;
                ChannelDescriptor channelDescriptor2 = null;
                if (this.pipeStream != null) {
                    channelDescriptor2 = this.pipeStream.getDescriptor();
                    try {
                        this.pipeStream.fflush();
                        this.pipeStream.fclose();
                    }
                    finally {
                        this.pipeStream = null;
                        ruby.getDescriptors().remove(channelDescriptor2.getFileno());
                    }
                }
                if (this.mainStream == null) break block18;
                channelDescriptor = this.mainStream.getDescriptor();
                try {
                    if (channelDescriptor2 == null && this.isWriteBuffered()) {
                        this.mainStream.fflush();
                    }
                    this.mainStream.fclose();
                }
                catch (BadDescriptorException badDescriptorException) {
                    if (channelDescriptor == channelDescriptor2) {
                        break block18;
                    }
                    throw badDescriptorException;
                }
                finally {
                    this.mainStream = null;
                    ruby.getDescriptors().remove(channelDescriptor.getFileno());
                }
            }
            catch (IOException iOException) {
                if (bl) {
                    throw ruby.newIOErrorFromException(iOException);
                }
            }
            catch (BadDescriptorException badDescriptorException) {
                if (bl) {
                    throw ruby.newErrnoEBADFError();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static interface Finalizer {
        public void finalize(Ruby var1, boolean var2);
    }
}

