/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring;

import java.awt.event.ActionEvent;
import javax.swing.text.Position;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.ui.actions.ShowSourceAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public class WSDLRefactoringElement
extends SimpleRefactoringElementImplementation {
    private FileObject source;
    Model model;
    Component comp;
    Node node;
    XMLRefactoringTransaction transaction;

    public WSDLRefactoringElement(Model model, Referenceable referenceable, Component component) {
        this.model = model;
        this.comp = component;
        try {
            if (model instanceof WSDLModel) {
                DataObject dataObject;
                ModelSource modelSource = model.getModelSource();
                this.source = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                if (this.source != null && (dataObject = DataObject.find((FileObject)this.source)) != null && dataObject instanceof WSDLDataObject) {
                    this.node = NodesFactory.getInstance().create(component);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this.comp);
    }

    public FileObject getParentFile() {
        if (this.source == null) {
            assert (this.model != null) : "Invalid object, expecting non-null model.";
            this.source = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
            assert (this.source != null) : "ModelSource should have FileObject in lookup";
        }
        return this.source;
    }

    public String getText() {
        if (this.node == null) {
            TreeElement treeElement = TreeElementFactory.getTreeElement((Object)this.comp);
            return treeElement.getText(true);
        }
        return this.node.getName();
    }

    public String getDisplayText() {
        if (this.node == null) {
            TreeElement treeElement = TreeElementFactory.getTreeElement((Object)this.comp);
            return treeElement.getText(true);
        }
        return this.node.getHtmlDisplayName();
    }

    public void performChange() {
    }

    public PositionBounds getPosition() {
        if (this.comp.getModel() instanceof AbstractDocumentModel) {
            CloneableEditorSupport cloneableEditorSupport;
            DocumentModelAccess documentModelAccess = null;
            Element element = null;
            int n = 0;
            documentModelAccess = this.comp instanceof SchemaComponent ? ((AbstractDocumentModel)this.model).getAccess() : ((AbstractDocumentModel)this.comp.getModel()).getAccess();
            element = ((DocumentComponent)this.comp).getPeer();
            n = ((DocumentComponent)this.comp).findPosition();
            String string = documentModelAccess.getXmlFragmentInclusive(element);
            int n2 = n + string.length();
            DataObject dataObject = null;
            try {
                cloneableEditorSupport = (FileObject)this.comp.getModel().getModelSource().getLookup().lookup(FileObject.class);
                dataObject = DataObject.find((FileObject)cloneableEditorSupport);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            cloneableEditorSupport = SharedUtils.findCloneableEditorSupport(dataObject);
            if (cloneableEditorSupport == null) {
                return null;
            }
            PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
            PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
            PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
            return positionBounds;
        }
        return null;
    }

    public void openInEditor() {
        SystemAction systemAction = SystemAction.get(ShowSourceAction.class);
        String string = (String)systemAction.getValue("ActionCommandKey");
        if (this.node == null) {
            this.node = new AbstractNode(Children.LEAF);
        }
        ActionEvent actionEvent = new ActionEvent(this.node, 0, string);
        systemAction.actionPerformed(actionEvent);
    }

    void addTransactionObject(XMLRefactoringTransaction xMLRefactoringTransaction) {
        this.transaction = xMLRefactoringTransaction;
    }

    protected String getNewFileContent() {
        if (this.comp.getModel() instanceof AbstractDocumentModel && this.transaction != null) {
            try {
                String string = this.transaction.refactorForPreview(this.comp.getModel());
                return string;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return null;
    }
}

