/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo.keys;

import java.io.File;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class DiskFileKey {
    private final FileObject fileObject;
    private final int hashCode;
    private String absolutePath;

    public static DiskFileKey createKey(FileObject fileObject) {
        return new DiskFileKey(fileObject);
    }

    private DiskFileKey(FileObject fileObject) {
        FileObject fileObject2 = (FileObject)fileObject.getAttribute("VCS-Native-FileObject");
        if (fileObject2 == null) {
            fileObject2 = fileObject;
        }
        this.fileObject = fileObject;
        this.hashCode = fileObject.getNameExt().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DiskFileKey) {
            DiskFileKey diskFileKey = (DiskFileKey)object;
            if (this.hashCode != diskFileKey.hashCode) {
                return false;
            }
            FileObject fileObject = this.fileObject;
            FileObject fileObject2 = diskFileKey.fileObject;
            if (fileObject == fileObject2) {
                return true;
            }
            try {
                File file;
                FileSystem fileSystem = fileObject.getFileSystem();
                FileSystem fileSystem2 = fileObject2.getFileSystem();
                if (fileSystem.equals(fileSystem2)) {
                    return fileObject.equals(fileObject2);
                }
                if (this.absolutePath == null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                    this.absolutePath = file.getAbsolutePath();
                }
                if (diskFileKey.absolutePath == null) {
                    file = FileUtil.toFile((FileObject)fileObject2);
                    diskFileKey.absolutePath = file.getAbsolutePath();
                }
                return this.absolutePath.equals(diskFileKey.absolutePath);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify((Throwable)fileStateInvalidException);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.absolutePath != null) {
            return this.absolutePath;
        }
        return this.fileObject.toString();
    }
}

