/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.saas;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.jaxws.saas.JavaSourceHelper;
import org.netbeans.modules.websvc.core.jaxws.saas.RestWrapperForSoapGenerator;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RestResourceGenerator {
    public static final String RESOURCE_TEMPLATE = "Templates/WebServices/GenericResource.java";
    public static final String SWDP_LIBRARY = "restlib";
    public static final String RESTAPI_LIBRARY = "restapi";
    private static final String[] CLASSPATHTYPES = new String[]{"javac.classpath"};
    private FileObject folder;
    private URL wsdlURL;
    private WsdlModel wsdlModel;
    private RestWrapperForSoapGenerator generator;

    public RestResourceGenerator(FileObject fileObject, URL uRL) {
        this.folder = fileObject;
        this.wsdlURL = uRL;
    }

    public void generate() {
        try {
            this.addSwdpLibrary(CLASSPATHTYPES);
            WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(this.wsdlURL);
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel wsdlModel) {
                    RestResourceGenerator.this.wsdlModel = wsdlModel;
                    FileObject fileObject = null;
                    List list = RestResourceGenerator.this.wsdlModel.getServices();
                    for (WsdlService wsdlService : list) {
                        List list2 = wsdlService.getPorts();
                        for (WsdlPort wsdlPort : list2) {
                            fileObject = JavaSourceHelper.createJavaSource(RestResourceGenerator.RESOURCE_TEMPLATE, RestResourceGenerator.this.folder, RestResourceGenerator.this.folder.getName(), wsdlPort.getName());
                            List list3 = wsdlPort.getOperations();
                            for (WSOperation wSOperation : list3) {
                                try {
                                    new RestWrapperForSoapGenerator((WSService)wsdlService, (WSPort)wsdlPort, wSOperation, fileObject).generate();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify((Throwable)iOException);
                                }
                            }
                        }
                    }
                    try {
                        RestResourceGenerator.openFileInEditor(DataObject.find(fileObject));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public static void openFileInEditor(DataObject dataObject) {
        final OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    openCookie.open();
                }
            }, 1000);
        } else {
            final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    editorCookie.open();
                }
            }, 1000);
        }
    }

    private void addSwdpLibrary(String[] stringArray) throws IOException {
        Library library = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
        if (library == null) {
            return;
        }
        Library library2 = LibraryManager.getDefault().getLibrary(RESTAPI_LIBRARY);
        if (library2 == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.folder);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            throw new IOException("Project has no Java sources");
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        for (String string : stringArray) {
            try {
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{library2, library}, (FileObject)fileObject, (String)string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.getLogger(this.getClass().getName()).info(string + " not supported.");
            }
        }
    }
}

