/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxwsstack.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.core.jaxwsstack.JaxWs;
import org.netbeans.modules.websvc.core.jaxwsstack.WSUriDescriptor;
import org.netbeans.modules.websvc.core.jaxwsstack.tomcat.TomcatJaxWsTool;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatJaxWsStackImpl
implements WSStackImplementation<JaxWs> {
    private static final String[] WSIT_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String KEYSTORE_LOCATION = "certs/server-keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "certs/server-truststore.jks";
    private static final String KEYSTORE_CLIENT_LOCATION = "certs/client-keystore.jks";
    private static final String TRUSTSTORE_CLIENT_LOCATION = "certs/client-truststore.jks";
    private JaxWs jaxWs;
    private File catalinaHome;
    private WSStackVersion version;

    public TomcatJaxWsStackImpl(File file) {
        this.catalinaHome = file;
        this.initJaxWsDescriptor();
        try {
            this.version = WSStackFactory.createWSStackVersion((String)this.resolveImplementationVersion());
            if (this.version == null) {
                this.version = WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)0);
            }
        }
        catch (IOException iOException) {
            this.version = WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)0);
        }
    }

    public void initJaxWsDescriptor() {
        this.jaxWs = new JaxWs();
        WSUriDescriptor wSUriDescriptor = new WSUriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }
        };
        this.jaxWs.setWSUriDescriptor(wSUriDescriptor);
        File file = new File(this.catalinaHome, KEYSTORE_LOCATION);
        if (file.exists()) {
            this.jaxWs.setKeystore(file);
        }
        if ((file = new File(this.catalinaHome, KEYSTORE_CLIENT_LOCATION)).exists()) {
            this.jaxWs.setKeystoreClient(file);
        }
        if ((file = new File(this.catalinaHome, TRUSTSTORE_LOCATION)).exists()) {
            this.jaxWs.setTruststore(file);
        }
        if ((file = new File(this.catalinaHome, TRUSTSTORE_CLIENT_LOCATION)).exists()) {
            this.jaxWs.setTruststoreClient(file);
        }
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return this.version;
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (this.isWsit()) {
            URL[] uRLArray = new URL[WSIT_LIBS.length];
            for (int i = 0; i < WSIT_LIBS.length; ++i) {
                try {
                    uRLArray[i] = new File(this.catalinaHome, WSIT_LIBS[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return WSStackFactory.createWSTool((WSToolImplementation)new TomcatJaxWsTool(tool, uRLArray));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.WSIT) {
            return this.isWsit();
        }
        return feature == JaxWs.Feature.TESTER_PAGE;
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        File file = new File(this.catalinaHome, "shared/lib/webservices-tools.jar");
        if (file.exists() && (jarEntry = (jarFile = new JarFile(file)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (!string3.startsWith("major-version=")) continue;
                string2 = string3.substring(14);
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }

    private boolean isWsit() {
        boolean bl = true;
        for (int i = 0; i < WSIT_LIBS.length; ++i) {
            if (new File(this.catalinaHome, WSIT_LIBS[i]).exists()) continue;
            bl = false;
        }
        return bl;
    }
}

