/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.action;

import java.awt.Dialog;
import org.netbeans.modules.websvc.core.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.WebServiceActionProvider;
import org.netbeans.modules.websvc.core.webservices.ui.panels.ClientExplorerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class InvokeOperationAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(InvokeOperationAction.class, (String)"LBL_CallWebServiceOperation");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray != null && nodeArray.length == 1 && nodeArray[0] != null && 0 != this.getTargetSourceType(nodeArray[0])) {
            return true;
        }
        return bl;
    }

    protected void performAction(Node[] nodeArray) {
        FileObject fileObject;
        if (nodeArray != null && nodeArray[0] != null && (fileObject = this.getCurrentFileObject(nodeArray[0])) != null) {
            InvokeOperationCookie invokeOperationCookie;
            ClientExplorerPanel clientExplorerPanel = new ClientExplorerPanel(fileObject);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)clientExplorerPanel, NbBundle.getMessage(InvokeOperationAction.class, (String)"TTL_SelectOperation"));
            clientExplorerPanel.setDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
            dialog.setVisible(true);
            if (dialogDescriptor.getValue().equals(NotifyDescriptor.OK_OPTION) && (invokeOperationCookie = WebServiceActionProvider.getInvokeOperationAction(fileObject, clientExplorerPanel.getSelectedMethod())) != null) {
                invokeOperationCookie.invokeOperation(this.getTargetSourceType(nodeArray[0]), nodeArray[0], clientExplorerPanel.getSelectedMethod());
            }
        }
    }

    private FileObject getCurrentFileObject(Node node) {
        FileObject fileObject = null;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        return fileObject;
    }

    private int getTargetSourceType(Node node) {
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && "text/x-jsp".equals(editorCookie.getDocument().getProperty("mimeType"))) {
            return 2;
        }
        if (editorCookie != null && "text/x-java".equals(editorCookie.getDocument().getProperty("mimeType"))) {
            return 1;
        }
        return 0;
    }
}

