/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.webservices.ui.panels.SelectHandlerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSHandlerDialog {
    private Dialog dialog;
    private SelectHandlerPanel sPanel;
    private AddMessageHandlerDialogDesc dlgDesc;
    private boolean isJaxWS;
    private Map<String, Integer> handlerMap;
    public static final int JAXWS_LOGICAL_HANDLER = 1;
    public static final int JAXWS_MESSAGE_HANDLER = 2;
    public static final int JAXRPC_MESSAGE_HANDLER = 3;
    public static final int INVALID_HANDLER = -1;

    public WSHandlerDialog(Project project, boolean bl) {
        this.isJaxWS = bl;
        this.sPanel = new SelectHandlerPanel(project);
        this.dlgDesc = new AddMessageHandlerDialogDesc(this.sPanel);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.dlgDesc);
        this.dialog.getAccessibleContext().setAccessibleDescription(this.dialog.getTitle());
        this.handlerMap = new TreeMap<String, Integer>();
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public boolean okButtonPressed() {
        return this.dlgDesc.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Map<String, Integer> getSelectedClasses() {
        return this.handlerMap;
    }

    private FileObject getFileObjectFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    public static int getHandlerType(CompilationController compilationController, boolean bl) throws IOException {
        TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
        if (typeElement != null) {
            TypeMirror typeMirror = typeElement.asType();
            if (bl) {
                WildcardType wildcardType;
                TypeElement typeElement2;
                TypeElement typeElement3 = compilationController.getElements().getTypeElement("javax.xml.ws.handler.LogicalHandler");
                DeclaredType declaredType = null;
                if (typeElement3 != null) {
                    typeElement2 = compilationController.getElements().getTypeElement("javax.xml.ws.handler.LogicalMessageContext");
                    wildcardType = compilationController.getTypes().getWildcardType(typeElement2.asType(), null);
                    declaredType = compilationController.getTypes().getDeclaredType(typeElement3, wildcardType);
                }
                if (declaredType != null && compilationController.getTypes().isAssignable(typeMirror, declaredType)) {
                    return 1;
                }
                typeElement3 = compilationController.getElements().getTypeElement("javax.xml.ws.handler.Handler");
                declaredType = null;
                if (typeElement3 != null) {
                    typeElement2 = compilationController.getElements().getTypeElement("javax.xml.ws.handler.MessageContext");
                    wildcardType = compilationController.getTypes().getWildcardType(typeElement2.asType(), null);
                    declaredType = compilationController.getTypes().getDeclaredType(typeElement3, wildcardType);
                }
                if (declaredType != null && compilationController.getTypes().isAssignable(typeMirror, declaredType)) {
                    return 2;
                }
            } else {
                TypeElement typeElement4 = compilationController.getElements().getTypeElement("javax.xml.rpc.handler.Handler");
                if (typeElement4 != null && compilationController.getTypes().isSubtype(typeMirror, typeElement4.asType())) {
                    return 3;
                }
            }
        }
        return -1;
    }

    class AddMessageHandlerDialogDesc
    extends DialogDescriptor {
        Project project;
        final SelectHandlerPanel sPanel;
        private Object[] closingOptionsWithoutOK;
        private Object[] closingOptionsWithOK;

        public AddMessageHandlerDialogDesc(SelectHandlerPanel selectHandlerPanel) {
            super((Object)selectHandlerPanel, NbBundle.getMessage(WSHandlerDialog.class, (String)"TTL_SelectHandler"));
            this.closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
            this.closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};
            this.sPanel = selectHandlerPanel;
            this.setButtonListener(new AddMessageActionListener(selectHandlerPanel));
        }

        class AddMessageActionListener
        implements ActionListener {
            SelectHandlerPanel sPanel;

            public AddMessageActionListener(SelectHandlerPanel selectHandlerPanel) {
                this.sPanel = selectHandlerPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean bl = true;
                    String string = null;
                    Node[] nodeArray = this.sPanel.getSelectedNodes();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        FileObject fileObject = WSHandlerDialog.this.getFileObjectFromNode(node);
                        if (fileObject == null) {
                            string = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotJavaClass_msg");
                            bl = false;
                            break;
                        }
                        final int[] nArray = new int[]{1};
                        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                        if (javaSource == null) {
                            string = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotJavaClass_msg");
                            bl = false;
                            break;
                        }
                        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                            public void run(CompilationController compilationController) throws IOException {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                nArray[0] = WSHandlerDialog.getHandlerType(compilationController, WSHandlerDialog.this.isJaxWS);
                            }

                            public void cancel() {
                            }
                        };
                        try {
                            javaSource.runUserActionTask((Task)cancellableTask, true);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                        if (nArray[0] == -1) {
                            string = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotHandlerClass_msg");
                            bl = false;
                            break;
                        }
                        FileObject fileObject2 = WSHandlerDialog.this.getFileObjectFromNode(node);
                        if (fileObject2 == null) continue;
                        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
                        String string2 = classPath.getResourceName(fileObject2, '.', false);
                        WSHandlerDialog.this.handlerMap.put(string2, nArray[0]);
                    }
                    if (!bl) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message(string, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        AddMessageHandlerDialogDesc.this.setClosingOptions(AddMessageHandlerDialogDesc.this.closingOptionsWithoutOK);
                    } else {
                        AddMessageHandlerDialogDesc.this.setClosingOptions(AddMessageHandlerDialogDesc.this.closingOptionsWithOK);
                    }
                }
            }
        }
    }
}

