/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.core.webservices.ui.WSHandlerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandlerPanel
extends JPanel {
    private Project project;
    private List<String> handlerClasses;
    private boolean isJaxWS;
    private String componentName;
    private boolean isChanged;
    private int protocolIndex = -1;
    private static final String LOGICAL_TYPE = "Logical";
    private static final String PROTOCOL_TYPE = "Protocol";
    private JButton addBtn;
    private JButton downBtn;
    private JTable handlerTable;
    private DefaultTableModel handlerTableModel;
    private JScrollPane jScrollPane2;
    private JButton removeBtn;
    private JButton upBtn;

    public MessageHandlerPanel(Project project, List<String> list, boolean bl, String string) {
        this.project = project;
        this.handlerClasses = list;
        this.isJaxWS = bl;
        this.componentName = string;
        this.initComponents();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        this.populateHandlers();
        this.isChanged = false;
        this.handlerTable.getColumnModel().getColumn(1).setCellRenderer(new TypeCellRenderer());
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public TableModel getHandlerTableModel() {
        return this.handlerTableModel;
    }

    private FileObject getFileObjectOfClass(String string) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject = sourceGroupArray[i].getRootFolder();
            FileObject fileObject2 = fileObject.getFileObject(string.replaceAll("\\.", "/") + ".java");
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    private void populateHandlers() {
        ListIterator<String> listIterator = this.handlerClasses.listIterator();
        final int[] nArray = new int[]{1};
        while (listIterator.hasNext()) {
            String string = listIterator.next();
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    nArray[0] = WSHandlerDialog.getHandlerType(compilationController, MessageHandlerPanel.this.isJaxWS);
                }

                public void cancel() {
                }
            };
            FileObject fileObject = this.getFileObjectOfClass(string);
            if (fileObject != null) {
                try {
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                    javaSource.runUserActionTask((Task)cancellableTask, true);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            if (nArray[0] == 1) {
                ++this.protocolIndex;
            }
            this.handlerTableModel.addRow(new Object[]{string, nArray[0]});
        }
        if (this.handlerTableModel.getRowCount() > 0) {
            this.handlerTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.handlerTable = new HandlerTable();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)resourceBundle.getString("Add_DotDotDot_label"));
        this.addBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)resourceBundle.getString("Remove_label"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtn, (String)NbBundle.getMessage(MessageHandlerPanel.class, (String)"LBL_Move_Up"));
        this.upBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Move_Up"));
        this.upBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageHandlerPanel.this.moveUpHandler(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downBtn, (String)NbBundle.getMessage(MessageHandlerPanel.class, (String)"LBL_Move_Down"));
        this.downBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Move_Down"));
        this.downBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageHandlerPanel.this.moveDownHandler(actionEvent);
            }
        });
        this.handlerTableModel = new HandlerTableModel(new String[]{NbBundle.getMessage(MessageHandlerPanel.class, (String)"HEADING_HANDLERS"), NbBundle.getMessage(MessageHandlerPanel.class, (String)"HEADING_TYPE")}, 0);
        this.handlerTable.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.handlerTable.setModel(this.handlerTableModel);
        this.jScrollPane2.setViewportView(this.handlerTable);
        this.handlerTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessageHandlerPanel.class, (String)"ACSD_MessageHandlerTable"));
        this.handlerTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageHandlerPanel.class, (String)"ACSD_MessageHandlerTable"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 364, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addBtn, -1, 95, Short.MAX_VALUE).add((Component)this.upBtn, -1, 95, Short.MAX_VALUE).add((Component)this.removeBtn, -1, 95, Short.MAX_VALUE).add((Component)this.downBtn, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBtn).addPreferredGap(0).add((Component)this.removeBtn).add(23, 23, 23).add((Component)this.upBtn).addPreferredGap(0).add((Component)this.downBtn)).add(1, (Component)this.jScrollPane2, -1, 219, Short.MAX_VALUE)).addContainerGap()));
    }

    private void moveUpHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow();
        if (n == -1) {
            return;
        }
        Integer n2 = (Integer)this.handlerTableModel.getValueAt(n, 1);
        if (n2 == 2 && n - 1 == this.protocolIndex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"TXT_CannotMoveUp", (Object)2)));
            return;
        }
        int n3 = n - 1;
        this.handlerTableModel.moveRow(n, n, n3);
        this.handlerTable.getSelectionModel().setSelectionInterval(n3, n3);
        this.isChanged = true;
    }

    private void moveDownHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow();
        if (n == -1) {
            return;
        }
        Integer n2 = (Integer)this.handlerTableModel.getValueAt(n, 1);
        if (n2 == 1 && n == this.protocolIndex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"TXT_CannotMoveDown", (Object)2)));
            return;
        }
        int n3 = n + 1;
        this.handlerTableModel.moveRow(n, n, n3);
        this.handlerTable.getSelectionModel().setSelectionInterval(n3, n3);
        this.isChanged = true;
    }

    private int getSelectedRow() {
        ListSelectionModel listSelectionModel = this.handlerTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return listSelectionModel.getMinSelectionIndex();
    }

    class TypeCellRenderer
    implements TableCellRenderer {
        TypeCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Integer n3;
            JLabel jLabel = new JLabel();
            if (n2 == 1 && (n3 = (Integer)object) != null) {
                if (n3 == 1) {
                    jLabel.setText(MessageHandlerPanel.LOGICAL_TYPE);
                } else {
                    jLabel.setText(MessageHandlerPanel.PROTOCOL_TYPE);
                }
            }
            return jLabel;
        }
    }

    class HandlerTableModel
    extends DefaultTableModel {
        public HandlerTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class HandlerListSelectionListener
    implements ListSelectionListener {
        HandlerListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = MessageHandlerPanel.this.getSelectedRow();
                if (n == 0) {
                    MessageHandlerPanel.this.upBtn.setEnabled(false);
                } else if (!MessageHandlerPanel.this.upBtn.isEnabled()) {
                    MessageHandlerPanel.this.upBtn.setEnabled(true);
                }
                if (n == MessageHandlerPanel.this.handlerTableModel.getRowCount() - 1) {
                    MessageHandlerPanel.this.downBtn.setEnabled(false);
                } else if (!MessageHandlerPanel.this.downBtn.isEnabled()) {
                    MessageHandlerPanel.this.downBtn.setEnabled(true);
                }
            }
        }
    }

    class HandlerTable
    extends JTable {
        public HandlerTable() {
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setResizingAllowed(false);
            jTableHeader.setReorderingAllowed(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionMode(1);
            listSelectionModel.addListSelectionListener(new HandlerListSelectionListener());
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        DialogDescriptor dlgDesc = null;

        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Map<String, Integer> map;
            WSHandlerDialog wSHandlerDialog = new WSHandlerDialog(MessageHandlerPanel.this.project, MessageHandlerPanel.this.isJaxWS);
            wSHandlerDialog.show();
            if (wSHandlerDialog.okButtonPressed() && (map = wSHandlerDialog.getSelectedClasses()).size() > 0) {
                int n = 0;
                Set<Map.Entry<String, Integer>> set = map.entrySet();
                for (Map.Entry<String, Integer> entry : set) {
                    Integer n2 = map.get(entry.getKey());
                    if (n2 == 1) {
                        MessageHandlerPanel.this.handlerTableModel.insertRow(++MessageHandlerPanel.this.protocolIndex, new Object[]{entry.getKey(), n2});
                        n = MessageHandlerPanel.this.protocolIndex;
                        continue;
                    }
                    MessageHandlerPanel.this.handlerTableModel.addRow(new Object[]{entry.getKey(), n2});
                    n = MessageHandlerPanel.this.handlerTableModel.getRowCount() - 1;
                }
                MessageHandlerPanel.this.handlerTable.getSelectionModel().setSelectionInterval(n, n);
                MessageHandlerPanel.this.isChanged = true;
            }
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MessageHandlerPanel.this.getSelectedRow();
            if (n == -1) {
                return;
            }
            String string = (String)MessageHandlerPanel.this.handlerTableModel.getValueAt(n, 0);
            if (this.confirmDeletion(string)) {
                Integer n2 = (Integer)MessageHandlerPanel.this.handlerTableModel.getValueAt(n, 1);
                if (n2 == 1) {
                    --MessageHandlerPanel.this.protocolIndex;
                }
                MessageHandlerPanel.this.handlerTableModel.removeRow(n);
                int n3 = n - 1;
                MessageHandlerPanel.this.handlerTable.getSelectionModel().setSelectionInterval(n3, n3);
                MessageHandlerPanel.this.isChanged = true;
            }
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string, (Object)MessageHandlerPanel.this.componentName), NbBundle.getMessage(MessageHandlerPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

