/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderChildren
extends Children.Keys<FileObject>
implements PropertyChangeListener,
ChangeListener,
FileChangeListener {
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");
    private DataFolder folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private FileChangeListener fcListener;
    private ChangeListener changeListener;
    private Logger err;
    private volatile Task refTask = Task.EMPTY;

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        super(true);
        this.folder = dataFolder;
        this.filter = dataFilter;
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.fcListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.folder.getPrimaryFile());
        String string = dataFolder.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(string);
    }

    DataFilter getFilter() {
        return this.filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("children".equals(propertyChangeEvent.getPropertyName())) {
            this.err.fine("Got PROP_CHILDREN");
            this.refreshChildren(0);
            return;
        }
        if ("sortMode".equals(propertyChangeEvent.getPropertyName()) || "order".equals(propertyChangeEvent.getPropertyName())) {
            this.err.fine("Got PROP_SORT_MODE or PROP_ORDER");
            this.refreshChildren(0);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshChildren(1);
    }

    final void refreshChildren(int n) {
        class R
        implements Runnable {
            int op;

            R() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block6: {
                    block5: {
                        if (this.op == 1) {
                            this.op = 2;
                            Children.MUTEX.postWriteRequest((Runnable)this);
                            return;
                        }
                        FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}", this.op);
                        try {
                            if (this.op == -1) {
                                FolderChildren.this.setKeys(Collections.emptyList());
                                Object var5_1 = null;
                                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
                                return;
                            }
                            FileObject[] fileObjectArray = FolderChildren.this.folder.getPrimaryFile().getChildren();
                            FolderOrder folderOrder = FolderOrder.findFor(FolderChildren.this.folder.getPrimaryFile());
                            Arrays.sort(fileObjectArray, folderOrder);
                            List list = FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false);
                            if (this.op == 2) {
                                FolderChildren.this.setKeys(Collections.emptyList());
                                FolderChildren.this.setKeys(list);
                                break block5;
                            }
                            if (this.op != 0) throw new IllegalStateException("Unknown op: " + this.op);
                            FolderChildren.this.setKeys(list);
                            break block6;
                        }
                        catch (Throwable throwable) {
                            Object var5_4 = null;
                            FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
                            throw throwable;
                        }
                    }
                    Object var5_2 = null;
                    FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
                    return;
                }
                Object var5_3 = null;
                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
            }
        }
        R r = new R();
        if (n == 10) {
            this.refTask.waitFinished();
            r.op = 0;
            r.run();
        } else {
            r.op = n;
            this.refTask = refRP.post((Runnable)r);
        }
    }

    protected Node[] createNodes(FileObject fileObject) {
        this.err.fine("createNodes: " + fileObject);
        try {
            DataObject dataObject = DataObject.find(fileObject);
            if (fileObject.equals(dataObject.getPrimaryFile()) && (this.filter == null || this.filter.acceptDataObject(dataObject))) {
                return new Node[]{dataObject.getClonedNodeDelegate(this.filter)};
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
        }
        return null;
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodes();
    }

    public Node findChild(String string) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodesCount(true);
        }
        return super.findChild(string);
    }

    private void waitOptimalResult() {
        if (FolderChildren.checkChildrenMutex()) {
            this.err.fine("waitOptimalResult");
            FolderList.find(this.folder.getPrimaryFile(), true).waitProcessingFinished();
            this.refTask.waitFinished();
            this.err.fine("waitOptimalResult: waitProcessingFinished");
        } else {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
        }
    }

    public int getNodesCount(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodesCount();
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        this.folder.getPrimaryFile().addFileChangeListener(this.fcListener);
        if (this.filter instanceof ChangeableDataFilter) {
            ChangeableDataFilter changeableDataFilter = (ChangeableDataFilter)this.filter;
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)changeableDataFilter);
            changeableDataFilter.addChangeListener(this.changeListener);
        }
        this.refreshChildren(10);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.getPrimaryFile().removeFileChangeListener(this.fcListener);
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        List list = Collections.emptyList();
        this.setKeys(list);
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if ("NetBeansAttrAssignedLoader".equals(fileAttributeEvent.getName())) {
            DataObjectPool.checkAttributeChanged(fileAttributeEvent);
            this.refreshKey(fileAttributeEvent.getFile());
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshChildren(0);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.refreshChildren(0);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.refreshChildren(0);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }
}

