/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.support.StreamRedirect;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

class ScriptExecSupport {
    private static final String ENV_PREFIX_TO_REMOVE = "ENV-";
    private FileObject fileObject;

    public ScriptExecSupport(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public void runScript() {
        DataObject dataObject;
        String string;
        Object object;
        Object object2;
        try {
            object2 = Repository.getDefault().getDefaultFileSystem().findResource("Actions/Project/org-netbeans-modules-project-ui-RunSingle.instance");
            if (object2 != null && (object = (string = (InstanceCookie)(dataObject = DataObject.find((FileObject)object2)).getCookie(InstanceCookie.class)).instanceCreate()) instanceof Action) {
                final Action action = (Action)object;
                if (action.isEnabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            action.actionPerformed(new ActionEvent(this, 0, null));
                        }
                    });
                }
                return;
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        LifecycleManager.getDefault().saveAll();
        object2 = null;
        try {
            object2 = new ProcessRunnable();
        }
        catch (Exception exception) {
            string = exception.getMessage();
            if (string == null || string.length() == 0) {
                string = exception.getClass().toString();
                if (exception.getStackTrace().length > 0) {
                    string = string + " " + exception.getStackTrace()[0].toString();
                }
            }
            object = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            return;
        }
        dataObject = IOProvider.getDefault().getIO(this.fileObject.getNameExt(), false);
        ((ProcessRunnable)object2).setIO((InputOutput)dataObject);
        try {
            dataObject.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ExecutionEngine.getDefault().execute(this.fileObject.getNameExt(), (Runnable)object2, (InputOutput)dataObject);
    }

    String getClassPath() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        if (project == null) {
            return "";
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.fileObject, (String)"classpath/execute");
        FileObject[] fileObjectArray = classPath.getRoots();
        if (fileObjectArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            try {
                URL uRL = fileObjectArray[i].getURL();
                if (uRL.getProtocol().equals("jar")) {
                    uRL = FileUtil.getArchiveFile((URL)uRL);
                }
                URI uRI = new URI(uRL.toExternalForm());
                File file = new File(uRI);
                stringBuffer.append(file.getAbsolutePath());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    public String getScriptExec() {
        GroovySettings groovySettings = new GroovySettings();
        File file = new File(groovySettings.getGroovyHome());
        if (file == null || !file.exists()) {
            String string = NbBundle.getMessage(ScriptExecSupport.class, (String)"MSG_HomeNotSet");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append(Utilities.isWindows() ? "\\bin\\groovy.bat" : "/bin/groovy");
        return stringBuffer.toString();
    }

    private class ProcessRunnable
    implements Runnable {
        InputOutput io;
        String[] command = this.createCommand();
        String[] env = this.createEnv();

        ProcessRunnable() {
        }

        void setIO(InputOutput inputOutput) {
            this.io = inputOutput;
        }

        private String[] createCommand() {
            String[] stringArray = new String[2];
            stringArray[0] = ScriptExecSupport.this.getScriptExec();
            File file = FileUtil.toFile((FileObject)ScriptExecSupport.this.fileObject);
            stringArray[1] = file.getAbsolutePath();
            return stringArray;
        }

        private String[] createEnv() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String string = entry.getKey().toString();
                if (!string.toUpperCase().startsWith(ScriptExecSupport.ENV_PREFIX_TO_REMOVE)) continue;
                String string2 = string.substring(ScriptExecSupport.ENV_PREFIX_TO_REMOVE.length()) + "=" + entry.getValue().toString();
                arrayList.add(string2);
            }
            arrayList.add("CLASSPATH=" + ScriptExecSupport.this.getClassPath());
            return arrayList.toArray(new String[arrayList.size()]);
        }

        private void displayMsg(String string) {
            MessageFormat messageFormat = new MessageFormat(NbBundle.getMessage(ScriptExecSupport.class, (String)string));
            String string2 = messageFormat.format(new Object[]{ScriptExecSupport.this.fileObject.getNameExt()});
            StatusDisplayer.getDefault().setStatusText(string2);
        }

        public void run() {
            try {
                int n;
                this.displayMsg("MSG_ScriptStarted");
                if (this.io != null) {
                    this.io.getOut().println(this.command[0] + " " + this.command[1]);
                }
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(this.command, this.env);
                if (this.io != null) {
                    StreamRedirect streamRedirect = new StreamRedirect(ScriptExecSupport.this.fileObject, process.getErrorStream(), this.io.getErr());
                    StreamRedirect streamRedirect2 = new StreamRedirect(ScriptExecSupport.this.fileObject, process.getInputStream(), this.io.getOut());
                    streamRedirect.start();
                    streamRedirect2.start();
                }
                this.displayMsg((n = process.waitFor()) == 0 ? "MSG_ScriptFinished" : "MSG_ScriptFailed");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

