/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class ScriptHyperlink
extends Annotation
implements OutputListener,
PropertyChangeListener {
    private static final Set<ScriptHyperlink> hyperlinks = new WeakSet();
    private final URL url;
    private final String message;
    private final int line1;
    private int col1;
    private final int line2;
    private final int col2;
    private boolean dead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set<ScriptHyperlink> set = hyperlinks;
        synchronized (set) {
            Iterator<ScriptHyperlink> iterator = hyperlinks.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptHyperlink(URL uRL, String string, int n, int n2, int n3, int n4) {
        this.url = uRL;
        this.message = string;
        this.line1 = n;
        this.col1 = n2;
        this.line2 = n3;
        this.col2 = n4;
        Set<ScriptHyperlink> set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void setColumn1(int n) {
        if (this.col1 == -1) {
            this.col1 = n;
        }
    }

    void destroy() {
        this.doDetach();
        this.dead = true;
    }

    public void outputLineAction(OutputEvent outputEvent) {
        block11: {
            if (this.dead) {
                return;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)this.url);
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null && fileObject == dataObject.getPrimaryFile()) {
                    if (this.line1 == -1) {
                        editorCookie.open();
                        break block11;
                    }
                    editorCookie.openDocument();
                    try {
                        Line line = editorCookie.getLineSet().getOriginal(this.line1 - 1);
                        if (line.isDeleted()) break block11;
                        this.attachAsNeeded(line);
                        if (this.col1 == -1) {
                            line.show(2);
                            break block11;
                        }
                        line.show(2, this.col1 - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                    break block11;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.message != null) {
            StatusDisplayer.getDefault().setStatusText(this.message);
        }
    }

    public void outputLineSelected(OutputEvent outputEvent) {
        if (this.dead) {
            return;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)this.url);
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                Line line;
                if (editorCookie.getDocument() == null) {
                    return;
                }
                if (this.line1 != -1 && !(line = editorCookie.getLineSet().getOriginal(this.line1 - 1)).isDeleted()) {
                    this.attachAsNeeded(line);
                    if (this.col1 == -1) {
                        line.show(0);
                    } else {
                        line.show(0, this.col1 - 1);
                    }
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private synchronized void attachAsNeeded(Line line) {
        if (this.getAttachedAnnotatable() == null) {
            Object object;
            String string = line.getText();
            if (string != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                int n = this.convertTabColumnsToCharacterColumns(string, this.col1 - 1, 8);
                int n2 = this.convertTabColumnsToCharacterColumns(string, this.col2 - 1, 8);
                object = n2 != -1 && n2 >= n && n2 < string.length() ? line.createPart(n, n2 - n + 1) : (n < string.length() ? line.createPart(n, string.length() - n - 1) : line);
            } else {
                object = line;
            }
            this.attach((Annotatable)object);
            for (ScriptHyperlink scriptHyperlink : hyperlinks) {
                if (scriptHyperlink == this) continue;
                scriptHyperlink.doDetach();
            }
            object.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private int convertTabColumnsToCharacterColumns(String string, int n, int n2) {
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = 0;
        for (n3 = 0; n3 < cArray.length && n4 < n; ++n3) {
            if (cArray[n3] == '\t') {
                n4 += n2 - n4 % n2;
                continue;
            }
            ++n4;
        }
        return n3;
    }

    private synchronized void doDetach() {
        Annotatable annotatable = this.getAttachedAnnotatable();
        if (annotatable != null) {
            annotatable.removePropertyChangeListener((PropertyChangeListener)this);
            this.detach();
        }
    }

    public void outputLineCleared(OutputEvent outputEvent) {
        this.doDetach();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.dead) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null || string.equals("text") || string.equals("deleted")) {
            this.doDetach();
        }
    }

    public String getAnnotationType() {
        return "org-apache-tools-ant-module-error";
    }

    public String getShortDescription() {
        if (this.message != null) {
            return this.message;
        }
        return null;
    }

    public String toString() {
        return "Hyperlink[" + this.url + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
    }
}

