/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.groovy.support.options.SupportOptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SupportPanel
extends JPanel {
    private final SupportOptionsPanelController controller;
    private JButton chooseDocButton;
    private JButton chooseHomeButton;
    private JLabel docLabel;
    private JTextField groovyDocTextField;
    private JTextField groovyHomeTextField;
    private JLabel homeLabel;
    private JLabel jLabel2;
    private JLabel linkLabel;

    SupportPanel(SupportOptionsPanelController supportOptionsPanelController) {
        this.controller = supportOptionsPanelController;
        this.initComponents();
    }

    private void initComponents() {
        this.homeLabel = new JLabel();
        this.groovyHomeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.linkLabel = new JLabel();
        this.chooseHomeButton = new JButton();
        this.docLabel = new JLabel();
        this.groovyDocTextField = new JTextField();
        this.chooseDocButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.homeLabel, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.homeLabel.text"));
        this.groovyHomeTextField.setText(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyHomeTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.linkLabel, (String)"<html><a href=\"http://groovy.codehaus.org\">http://groovy.codehaus.org</a></html>");
        this.linkLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SupportPanel.this.linkLabelMousePressed(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SupportPanel.this.linkLabelMouseExited(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                SupportPanel.this.linkLabelMouseEntered(mouseEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chooseHomeButton, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseHomeButton.text"));
        this.chooseHomeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SupportPanel.this.chooseHomeButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.docLabel, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.docLabel.text"));
        this.groovyDocTextField.setText(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDocButton, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.text"));
        this.chooseDocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SupportPanel.this.chooseDocButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.homeLabel).add((Component)this.docLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.linkLabel)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.groovyDocTextField, -1, 319, Short.MAX_VALUE).add((Component)this.groovyHomeTextField, -1, 319, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chooseDocButton).add((Component)this.chooseHomeButton)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.homeLabel).add((Component)this.chooseHomeButton).add((Component)this.groovyHomeTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.docLabel).add((Component)this.groovyDocTextField, -2, -1, -2).add((Component)this.chooseDocButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2, -2, 16, -2).add((Component)this.linkLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void linkLabelMousePressed(MouseEvent mouseEvent) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://groovy.codehaus.org"));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    private void linkLabelMouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void linkLabelMouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void chooseHomeButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.groovyHomeTextField.getText());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SupportPanel.class, (String)"LBL_Select_Directory"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!new File(new File(file, "bin"), "groovy").isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SupportPanel.class, (String)"LBL_Not_groovy_home"), 2));
                return;
            }
            this.groovyHomeTextField.setText(file.getAbsolutePath());
        }
    }

    private void chooseDocButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.groovyDocTextField.getText());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SupportPanel.class, (String)"LBL_Select_Directory"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!new File(new File(file, "groovy-jdk"), "index.html").isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SupportPanel.class, (String)"LBL_Not_groovy_doc"), 2));
                return;
            }
            this.groovyDocTextField.setText(file.getAbsolutePath());
        }
    }

    void load() {
        GroovySettings groovySettings = new GroovySettings();
        this.groovyHomeTextField.setText(groovySettings.getGroovyHome());
        this.groovyDocTextField.setText(groovySettings.getGroovyDoc());
    }

    void store() {
        GroovySettings groovySettings = new GroovySettings();
        groovySettings.setGroovyHome(this.groovyHomeTextField.getText().trim());
        groovySettings.setGroovyDoc(this.groovyDocTextField.getText().trim());
    }

    boolean valid() {
        String string = this.groovyHomeTextField.getText().trim();
        String string2 = this.groovyDocTextField.getText().trim();
        return !"".equals(string) && !"".equals(string2);
    }
}

