/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.bdj;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BdjPlatformDetector
extends CDCPlatformDetector {
    private static String PLATFORM_TYPE = "bdj";
    private Detector[] detectors = new Detector[]{new SunBdjLauncherDetector(), new WinDVDDetector(), new DigitalTheatreDetector(), new PowerDVDDetector()};
    private int lastDetected = -1;

    public String getPlatformName() {
        return "BD-J platform";
    }

    public String getPlatformType() {
        return PLATFORM_TYPE;
    }

    public boolean accept(FileObject fileObject) {
        for (int i = 0; i < this.detectors.length; ++i) {
            if (!this.detectors[i].accept(fileObject)) continue;
            this.lastDetected = i;
            return true;
        }
        return false;
    }

    public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
        assert (this.lastDetected != -1);
        return this.detectors[this.lastDetected].detectPlatform(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject installStubs(FileObject fileObject) throws IOException {
        File file = InstalledFileLocator.getDefault().locate("external/bdj/bdj_stubs.zip", "org.netbeans.modules.j2me.cdc.platform.bdj", false);
        if (file == null || !file.isFile()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BdjPlatformDetector.class, (String)"ERR_StubsMissing", (Object)2)));
            throw new IOException("Missing stubs");
        }
        FileObject fileObject2 = fileObject.createData("bdj_stubs", "zip");
        FileLock fileLock = null;
        BufferedOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            fileLock = fileObject2.lock();
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedOutputStream = new BufferedOutputStream(fileObject2.getOutputStream(fileLock));
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        finally {
            fileLock.releaseLock();
        }
        return fileObject2;
    }

    private class SunBdjLauncherDetector
    implements Detector {
        private SunBdjLauncherDetector() {
        }

        public boolean accept(FileObject fileObject) {
            FileObject fileObject2 = CDCPlatformUtil.findTool((String)"lib", (String)"bd-j__bdj-emulator.jar", Collections.singleton(fileObject));
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"lib", (String)"bd-j__blu-ray-generator.jar", Collections.singleton(fileObject));
            return null != fileObject2 && null != fileObject3;
        }

        public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
            FileObject fileObject2;
            assert (fileObject != null);
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"lib", (String)"bd-j__bdj-emulator.jar", Collections.singleton(fileObject));
            if (fileObject3 == null) {
                throw new IOException("Sun BD-J Launcher can not be found in desired location!");
            }
            File file = FileUtil.toFile((FileObject)fileObject3);
            if (file == null) {
                throw new IOException("Sun BD-J Launcher can not be found in desired location!");
            }
            String string = file.getAbsolutePath();
            FileObject fileObject4 = fileObject.getFileObject("lib/bdj_stubs.zip");
            if (fileObject4 == null) {
                fileObject2 = fileObject.getFileObject("lib");
                fileObject4 = BdjPlatformDetector.installStubs(fileObject2);
            }
            fileObject2 = fileObject.getFileObject("");
            ArrayList arrayList = new ArrayList();
            String string2 = "0.1";
            String string3 = "Sun BD-J Launcher" + (string2 != null ? " " + string2 : "");
            return new CDCPlatform(string3, string3, PLATFORM_TYPE, "1.3", Collections.singletonList(fileObject.getURL()), Collections.EMPTY_LIST, arrayList, this.getBdjSDKDevice(string, FileUtil.toFile((FileObject)fileObject2), fileObject, FileUtil.toFile((FileObject)fileObject4).getAbsolutePath()), false);
        }

        private CDCDevice[] getBdjSDKDevice(String string, File file, FileObject fileObject, String string2) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CDCPlatform.PROP_EXEC_XLET, "javax.tv.xlet.Xlet");
            CDCDevice.CDCProfile cDCProfile = new CDCDevice.CDCProfile("Personal Basis Profile", "Personal Basis Profile with BD-J extensions", "1.0", hashMap, stringBuffer.toString(), null, true);
            CDCDevice cDCDevice = new CDCDevice();
            cDCDevice.setProfiles(new CDCDevice.CDCProfile[]{cDCProfile});
            return new CDCDevice[]{cDCDevice};
        }
    }

    private class PowerDVDDetector
    implements Detector {
        private PowerDVDDetector() {
        }

        public boolean accept(FileObject fileObject) {
            FileObject fileObject2 = CDCPlatformUtil.findTool((String)"", (String)"PowerDVD", Collections.singleton(fileObject));
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"NavFilter/bin", (String)"cvmi.dll", Collections.singleton(fileObject));
            return null != fileObject2 && null != fileObject3;
        }

        public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
            FileObject fileObject2;
            assert (fileObject != null);
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"", (String)"PowerDVD", Collections.singleton(fileObject));
            if (fileObject3 == null) {
                throw new IOException("PowerDVD can not be found in desired location!");
            }
            File file = FileUtil.toFile((FileObject)fileObject3);
            if (file == null) {
                throw new IOException("PowerDVD can not be found in desired location!");
            }
            String string = file.getAbsolutePath();
            FileObject fileObject4 = fileObject.getFileObject("NavFilter/bdj_stubs.zip");
            if (fileObject4 == null) {
                fileObject2 = fileObject.getFileObject("NavFilter");
                fileObject4 = BdjPlatformDetector.installStubs(fileObject2);
            }
            fileObject2 = fileObject.getFileObject("");
            ArrayList arrayList = new ArrayList();
            String string2 = "1.0";
            String string3 = "CyberLink PowerDVD BD-J player " + (string2 != null ? " " + string2 : "");
            return new CDCPlatform(string3, string3, PLATFORM_TYPE, "1.3", Collections.singletonList(fileObject.getURL()), Collections.EMPTY_LIST, arrayList, this.getBdjSDKDevice(string, FileUtil.toFile((FileObject)fileObject2), fileObject, FileUtil.toFile((FileObject)fileObject4).getAbsolutePath()), false);
        }

        private CDCDevice[] getBdjSDKDevice(String string, File file, FileObject fileObject, String string2) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CDCPlatform.PROP_EXEC_XLET, "javax.tv.xlet.Xlet");
            CDCDevice.CDCProfile cDCProfile = new CDCDevice.CDCProfile("Personal Basis Profile", "Personal Basis Profile with BD-J extensions", "1.0", hashMap, stringBuffer.toString(), null, true);
            CDCDevice cDCDevice = new CDCDevice();
            cDCDevice.setProfiles(new CDCDevice.CDCProfile[]{cDCProfile});
            return new CDCDevice[]{cDCDevice};
        }
    }

    private class DigitalTheatreDetector
    implements Detector {
        private DigitalTheatreDetector() {
        }

        public boolean accept(FileObject fileObject) {
            FileObject fileObject2 = CDCPlatformUtil.findTool((String)"", (String)"uDigital Theatre", Collections.singleton(fileObject));
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"BDJ/cvm", (String)"cvmi.dll", Collections.singleton(fileObject));
            return null != fileObject2 && null != fileObject3;
        }

        public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
            FileObject fileObject2;
            assert (fileObject != null);
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"", (String)"uDigital Theatre", Collections.singleton(fileObject));
            if (fileObject3 == null) {
                throw new IOException("uDigital Theatre can not be found in desired location!");
            }
            File file = FileUtil.toFile((FileObject)fileObject3);
            if (file == null) {
                throw new IOException("uDigital Theatre can not be found in desired location!");
            }
            String string = file.getAbsolutePath();
            FileObject fileObject4 = fileObject.getFileObject("BDJ/cvm/lib/bdj_stubs.zip");
            if (fileObject4 == null) {
                fileObject2 = fileObject.getFileObject("BDJ/cvm/lib");
                fileObject4 = BdjPlatformDetector.installStubs(fileObject2);
            }
            fileObject2 = fileObject.getFileObject("");
            ArrayList arrayList = new ArrayList();
            String string2 = "1.0";
            String string3 = "ArcSoft Digital Theatre BD-J player " + (string2 != null ? " " + string2 : "");
            return new CDCPlatform(string3, string3, PLATFORM_TYPE, "1.3", Collections.singletonList(fileObject.getURL()), Collections.EMPTY_LIST, arrayList, this.getBdjSDKDevice(string, FileUtil.toFile((FileObject)fileObject2), fileObject, FileUtil.toFile((FileObject)fileObject4).getAbsolutePath()), false);
        }

        private CDCDevice[] getBdjSDKDevice(String string, File file, FileObject fileObject, String string2) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CDCPlatform.PROP_EXEC_XLET, "javax.tv.xlet.Xlet");
            CDCDevice.CDCProfile cDCProfile = new CDCDevice.CDCProfile("Personal Basis Profile", "Personal Basis Profile with BD-J extensions", "1.0", hashMap, stringBuffer.toString(), null, true);
            CDCDevice cDCDevice = new CDCDevice();
            cDCDevice.setProfiles(new CDCDevice.CDCProfile[]{cDCProfile});
            return new CDCDevice[]{cDCDevice};
        }
    }

    private class WinDVDDetector
    implements Detector {
        private WinDVDDetector() {
        }

        public boolean accept(FileObject fileObject) {
            FileObject fileObject2 = CDCPlatformUtil.findTool((String)"", (String)"WinDVD", Collections.singleton(fileObject));
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"BDJ/jre/bin", (String)"cvmi.dll", Collections.singleton(fileObject));
            return null != fileObject2 && null != fileObject3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
            Object object;
            FileObject fileObject2;
            assert (fileObject != null);
            FileObject fileObject3 = CDCPlatformUtil.findTool((String)"", (String)"WinDVD", Collections.singleton(fileObject));
            if (fileObject3 == null) {
                throw new IOException("WinDVD can not be found in desired location!");
            }
            File file = FileUtil.toFile((FileObject)fileObject3);
            if (file == null) {
                throw new IOException("WinDVD can not be found in desired location!");
            }
            String string = file.getAbsolutePath();
            FileObject fileObject4 = fileObject.getFileObject("BDJ/jre/lib/bdj_stubs.zip");
            if (fileObject4 == null) {
                fileObject2 = fileObject.getFileObject("BDJ/jre/lib");
                fileObject4 = BdjPlatformDetector.installStubs(fileObject2);
            }
            fileObject2 = fileObject.getFileObject("");
            ArrayList arrayList = new ArrayList();
            String string2 = null;
            InputStream inputStream = null;
            try {
                object = fileObject.getFileObject("WinDVD.exe", "manifest");
                if (object != null) {
                    inputStream = object.getInputStream();
                    ManifestParser manifestParser = new ManifestParser();
                    manifestParser.parse(inputStream);
                    string2 = manifestParser.getVersion();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            object = "Corel WinDVD BD-J player " + (string2 != null ? " " + string2 : "");
            return new CDCPlatform((String)object, (String)object, PLATFORM_TYPE, "1.3", Collections.singletonList(fileObject.getURL()), Collections.EMPTY_LIST, arrayList, this.getBdjSDKDevice(string, FileUtil.toFile((FileObject)fileObject2), fileObject, FileUtil.toFile((FileObject)fileObject4).getAbsolutePath()), false);
        }

        private void findJavaDoc(FileObject fileObject, List list) {
            int n;
            if (fileObject == null) {
                return;
            }
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (n = 0; n < fileObjectArray.length; ++n) {
                if (!fileObjectArray[n].isData() || !"index".equals(fileObjectArray[n].getName())) continue;
                list.add(fileObjectArray[n].getParent());
            }
            for (n = 0; n < fileObjectArray.length; ++n) {
                if (!fileObjectArray[n].isFolder() || list.contains(fileObjectArray[n].getParent())) continue;
                this.findJavaDoc(fileObjectArray[n], list);
            }
        }

        private CDCDevice[] getBdjSDKDevice(String string, File file, FileObject fileObject, String string2) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CDCPlatform.PROP_EXEC_XLET, "javax.tv.xlet.Xlet");
            CDCDevice.CDCProfile cDCProfile = new CDCDevice.CDCProfile("Personal Basis Profile", "Personal Basis Profile with BD-J extensions", "1.0", hashMap, stringBuffer.toString(), null, true);
            CDCDevice cDCDevice = new CDCDevice();
            cDCDevice.setProfiles(new CDCDevice.CDCProfile[]{cDCProfile});
            return new CDCDevice[]{cDCDevice};
        }

        private class ManifestParser
        extends DefaultHandler {
            private String version = "N/A";

            private ManifestParser() {
            }

            public String getVersion() {
                return this.version;
            }

            public void parse(InputStream inputStream) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                try {
                    sAXParserFactory.setNamespaceAware(true);
                    sAXParserFactory.setValidating(false);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    sAXParser.parse(inputStream, (DefaultHandler)this);
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (string2.equals("assemblyIdentity") && "WinDVD.exe".equals(attributes.getValue("name"))) {
                    this.version = attributes.getValue("version");
                }
            }
        }
    }

    static interface Detector {
        public boolean accept(FileObject var1);

        public CDCPlatform detectPlatform(FileObject var1) throws IOException;
    }
}

