/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java;

import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JMethod;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Option;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl2java.ast.MethodNode;
import com.sun.research.ws.wadl2java.ast.RepresentationNode;
import com.sun.research.ws.wadl2java.ast.ResourceNode;
import com.sun.research.ws.wadl2java.ast.ResourceTypeNode;
import java.io.IOException;
import java.io.StringWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaDocUtil {
    protected void copyElementContent(Element source, Element sink) {
        NamedNodeMap sourceAttributes = source.getAttributes();
        for (int i = 0; i < sourceAttributes.getLength(); ++i) {
            Attr a = (Attr)sourceAttributes.item(i);
            if (a.getName().startsWith("xmlns")) continue;
            if (a.getLocalName() == null) {
                sink.setAttribute(a.getName(), a.getValue());
                continue;
            }
            sink.setAttribute(a.getLocalName(), a.getValue());
        }
        NodeList children = source.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            Node newNode = null;
            switch (child.getNodeType()) {
                case 1: {
                    Element childElem = (Element)child;
                    newNode = childElem.getLocalName() != null ? source.getOwnerDocument().createElement(childElem.getLocalName()) : source.getOwnerDocument().createElement(child.getNodeName());
                    this.copyElementContent(childElem, (Element)newNode);
                    break;
                }
                case 3: {
                    newNode = source.getOwnerDocument().createTextNode(child.getNodeValue());
                    break;
                }
            }
            sink.appendChild(newNode);
        }
    }

    protected String createTaggedJavaDoc(Element e) {
        Element normalizedDoc = e.getLocalName() != null ? e.getOwnerDocument().createElement(e.getLocalName()) : e.getOwnerDocument().createElement(e.getTagName());
        this.copyElementContent(e, normalizedDoc);
        StringWriter sw = new StringWriter();
        OutputFormat of = new OutputFormat("html", null, false);
        of.setOmitXMLDeclaration(true);
        XMLSerializer xs = new XMLSerializer(sw, of);
        try {
            xs.serialize(normalizedDoc);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sw.toString();
    }

    protected void appendTextContent(Doc d, JCommentPart jdoc) {
        if (d.getTitle() != null) {
            jdoc.append((Object)d.getTitle());
            if (!d.getTitle().endsWith(".")) {
                jdoc.append((Object)".");
            }
        }
        for (Object o : d.getContent()) {
            if (o instanceof String) {
                jdoc.append(o);
                continue;
            }
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            jdoc.append((Object)this.createTaggedJavaDoc(e));
        }
    }

    public void generateClassDoc(ResourceNode r, JDefinedClass c) {
        if (r.getDoc().size() < 1) {
            return;
        }
        Doc d = r.getDoc().get(0);
        JDocComment jdoc = c.javadoc();
        this.appendTextContent(d, (JCommentPart)jdoc);
    }

    void generateClassDoc(ResourceTypeNode n, JDefinedClass iface) {
        if (n.getDoc().size() < 1) {
            return;
        }
        Doc d = n.getDoc().get(0);
        JDocComment jdoc = iface.javadoc();
        this.appendTextContent(d, (JCommentPart)jdoc);
    }

    public void generateMethodDoc(MethodNode m, JMethod jm) {
        if (m.getDoc().size() < 1) {
            return;
        }
        Doc d = m.getDoc().get(0);
        JDocComment jdoc = jm.javadoc();
        this.appendTextContent(d, (JCommentPart)jdoc);
    }

    public void generateEnumDoc(Param p, JDefinedClass e) {
        if (p.getDoc().size() < 1) {
            return;
        }
        Doc d = p.getDoc().get(0);
        JDocComment jdoc = e.javadoc();
        this.appendTextContent(d, (JCommentPart)jdoc);
    }

    public void generateParamDoc(Param p, JMethod jm) {
        if (p.getDoc().size() < 1) {
            return;
        }
        Doc d = p.getDoc().get(0);
        JDocComment jdoc = jm.javadoc();
        JCommentPart jp = jdoc.addParam(p.getName());
        this.appendTextContent(d, jp);
    }

    public void generateParamDoc(RepresentationNode r, JMethod jm) {
        if (r.getDoc().size() < 1) {
            return;
        }
        Doc d = r.getDoc().get(0);
        JDocComment jdoc = jm.javadoc();
        JCommentPart jp = jdoc.addParam("input");
        this.appendTextContent(d, jp);
    }

    public void generateReturnDoc(RepresentationNode r, JMethod jm) {
        if (r.getDoc().size() < 1) {
            return;
        }
        Doc d = r.getDoc().get(0);
        JDocComment jdoc = jm.javadoc();
        JCommentPart jp = jdoc.addReturn();
        this.appendTextContent(d, jp);
    }

    void generateEnumConstantDoc(Option o, JEnumConstant c) {
        if (o.getDoc().size() < 1) {
            return;
        }
        Doc d = o.getDoc().get(0);
        JDocComment jdoc = c.javadoc();
        this.appendTextContent(d, (JCommentPart)jdoc);
    }
}

