/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewWSDLAction
extends NodeAction {
    protected boolean enable(Node[] nodeArray) {
        WsdlSaas wsdlSaas = this.getWsdlSaas(nodeArray);
        if (wsdlSaas != null) {
            return wsdlSaas.getState() == Saas.State.RETRIEVED || wsdlSaas.getState() == Saas.State.READY;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(ViewWSDLAction.class, (String)"VIEW_WSDL");
    }

    private WsdlSaas getWsdlSaas(Node[] nodeArray) {
        WsdlSaasPort wsdlSaasPort;
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        WsdlSaas wsdlSaas = (WsdlSaas)nodeArray[0].getLookup().lookup(WsdlSaas.class);
        if (wsdlSaas == null && (wsdlSaasPort = (WsdlSaasPort)nodeArray[0].getLookup().lookup(WsdlSaasPort.class)) != null) {
            wsdlSaas = wsdlSaasPort.getParentSaas();
        }
        if (wsdlSaas == null && (wsdlSaasPort = (WsdlSaasMethod)nodeArray[0].getLookup().lookup(WsdlSaasMethod.class)) != null) {
            wsdlSaas = wsdlSaasPort.getSaas();
        }
        return wsdlSaas;
    }

    protected void performAction(Node[] nodeArray) {
        WsdlSaas wsdlSaas = this.getWsdlSaas(nodeArray);
        if (wsdlSaas == null) {
            throw new IllegalArgumentException("No nodes assoaciated WsdlSaas in lookup.");
        }
        if (wsdlSaas.getState() != Saas.State.RETRIEVED && wsdlSaas.getState() != Saas.State.READY) {
            throw new IllegalStateException("Unexpected state: " + wsdlSaas.getState());
        }
        String string = wsdlSaas.getWsdlData().getWsdlFile();
        FileObject fileObject = wsdlSaas.getLocalWsdlFile();
        if (null == fileObject) {
            String string2 = NbBundle.getMessage(ViewWSDLAction.class, (String)"WSDL_FILE_NOT_FOUND", (Object)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            editorCookie.open();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public boolean asynchronous() {
        return true;
    }
}

