/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WadlMethodNode
extends AbstractNode {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private WadlSaasMethod method;
    private Transferable transferable;
    private static final Image ICON = Utilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/method.png");

    public WadlMethodNode(WadlSaasMethod wadlSaasMethod) {
        this(wadlSaasMethod, new InstanceContent());
    }

    public WadlMethodNode(WadlSaasMethod wadlSaasMethod, InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.method = wadlSaasMethod;
        instanceContent.add((Object)wadlSaasMethod);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)wadlSaasMethod, SaasTransferable.WADL_METHOD_FLAVORS));
    }

    public String getDisplayName() {
        Set set;
        String string;
        if (this.method.getMethod() != null) {
            return this.method.getMethod().getName();
        }
        if (this.method.getWadlMethod().getId() != null) {
            return this.method.getWadlMethod().getId();
        }
        String string2 = string = this.method.getWadlMethod().getName();
        if (GET.equals(string)) {
            Set set2 = SaasUtil.getMediaTypesFromJAXBElement((List)this.method.getWadlMethod().getResponse().getRepresentationOrFault());
            if (set2 != null && set2.size() > 0) {
                string2 = string2 + set2.toString();
            }
        } else if ((PUT.equals(string) || POST.equals(string)) && (set = SaasUtil.getMediaTypes((List)this.method.getWadlMethod().getRequest().getRepresentation())) != null && set.size() > 0) {
            string2 = string2 + set;
        }
        return string2;
    }

    public String getShortDescription() {
        if (this.method.getMethod() != null) {
            return this.method.getMethod().getDocumentation();
        }
        return SaasUtil.getSignature((WadlSaasMethod)this.method);
    }

    public Image getIcon(int n) {
        return ICON;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action[] getActions(boolean bl) {
        List<Action> list = SaasNode.getActions(this.getLookup());
        return list.toArray(new Action[list.size()]);
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.method.getSaas().getState() != Saas.State.READY) {
            this.method.getSaas().toStateReady(false);
            return super.clipboardCopy();
        }
        return SaasTransferable.addFlavors((Transferable)this.transferable);
    }
}

