/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddWebServiceDlg
extends JPanel
implements ActionListener {
    public static final String DEFAULT_PACKAGE_HOLDER = NbBundle.getMessage(AddWebServiceDlg.class, (String)"MSG_ClickToOverride");
    private DialogDescriptor dlg = null;
    private String addString = NbBundle.getMessage(AddWebServiceDlg.class, (String)"Add");
    private String cancelString = NbBundle.getMessage(AddWebServiceDlg.class, (String)"CANCEL");
    private Dialog dialog;
    private static String previousDirectory = null;
    private static JFileChooser wsdlFileChooser;
    private final FileFilter WSDL_FILE_FILTER = new ServiceFileFilter();
    private JButton cancelButton = new JButton();
    private JButton addButton = new JButton();
    private SaasGroup group;
    private final boolean jaxRPCAvailable;
    private String defaultMsg;
    private boolean allControlsDisabled;
    private static final String[] KEYWORDS;
    private static final Set<String> KEYWORD_SET;
    private ButtonGroup buttonGroup1;
    private JLabel errorLabel;
    private JButton jBtnBrowse;
    private JButton jBtnProxy;
    private JLabel jLblChooseSource;
    private JRadioButton jRbnFilesystem;
    private JRadioButton jRbnUrl;
    private JTextField jTxServiceURL;
    private JTextField jTxtLocalFilename;
    private JTextField jTxtpackageName;
    private JLabel pkgNameLbl;

    public AddWebServiceDlg(SaasGroup saasGroup) {
        this.initComponents();
        this.myInitComponents();
        this.group = saasGroup;
        this.jaxRPCAvailable = WsdlUtil.isJAXRPCAvailable();
        this.defaultMsg = this.jaxRPCAvailable ? "" : NbBundle.getMessage(AddWebServiceDlg.class, (String)"WARNING_JAXRPC_UNAVAILABLE");
        this.checkServicesModel();
    }

    private static boolean isValidPackageName(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (KEYWORD_SET.contains(string2)) {
                return false;
            }
            char[] cArray = string2.toCharArray();
            if (!Character.isJavaIdentifierStart(cArray[0])) {
                return false;
            }
            for (n = 1; n < cArray.length; ++n) {
                if (Character.isJavaIdentifierPart(cArray[n])) continue;
                return false;
            }
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3 = n = string.charAt(i) == '.' ? 1 : 0;
            if (n != 0 && n2 != 0) {
                return false;
            }
            n2 = n;
        }
        return !string.endsWith(".");
    }

    private void setErrorMessage(String string) {
        if (string == null || string.length() == 0) {
            this.errorLabel.setVisible(false);
        } else {
            this.errorLabel.setVisible(true);
            this.errorLabel.setText(string);
        }
    }

    private void updateAddButtonState(Component component) {
        block14: {
            boolean bl;
            String string = this.jTxtpackageName.getText().trim();
            boolean bl2 = bl = DEFAULT_PACKAGE_HOLDER.equals(string) || string.length() == 0;
            if (!bl && !AddWebServiceDlg.isValidPackageName(string)) {
                this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_PACKAGE"));
                this.addButton.setEnabled(false);
            } else if (this.jTxtLocalFilename.isEnabled()) {
                String string2 = this.jTxtLocalFilename.getText().trim();
                if (string2.length() == 0) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"EMPTY_FILE"));
                    this.addButton.setEnabled(false);
                    return;
                }
                File file = new File(string2);
                if (!file.exists()) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_FILE_NOT_FOUND"));
                    this.addButton.setEnabled(false);
                    return;
                }
                if (!file.isFile()) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_FILE_NOT_FILE"));
                    this.addButton.setEnabled(false);
                    return;
                }
                if (this.group.serviceExists(string2)) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"SERVICE_ALREADY_EXISTS_FOR_FILE"));
                    this.addButton.setEnabled(false);
                    return;
                }
                this.setErrorMessage(this.defaultMsg);
                this.addButton.setEnabled(true);
            } else if (this.jTxServiceURL.isEnabled()) {
                String string3 = this.jTxServiceURL.getText().trim();
                if (string3.length() == 0) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"EMPTY_URL"));
                    this.addButton.setEnabled(false);
                    return;
                }
                try {
                    URL uRL = new URL(string3);
                    if (this.group.serviceExists(string3)) {
                        this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"SERVICE_ALREADY_EXISTS_FOR_URL"));
                        this.addButton.setEnabled(false);
                        break block14;
                    }
                    this.setErrorMessage(this.defaultMsg);
                    this.addButton.setEnabled(true);
                }
                catch (MalformedURLException malformedURLException) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_URL"));
                    this.addButton.setEnabled(false);
                }
            } else {
                this.setErrorMessage(this.defaultMsg);
                this.addButton.setEnabled(true);
            }
        }
    }

    private void myInitComponents() {
        wsdlFileChooser = new JFileChooser();
        ServiceFileFilter serviceFileFilter = new ServiceFileFilter();
        wsdlFileChooser.setFileFilter(serviceFileFilter);
        this.addButton.setText(NbBundle.getMessage(this.getClass(), (String)"Add"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.addButton.ACC_name"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.addButton.ACC_desc"));
        this.addButton.setMnemonic(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.addButton.ACC_mnemonic").charAt(0));
        this.cancelButton.setText(NbBundle.getMessage(this.getClass(), (String)"CANCEL"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.cancelButton.ACC_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.cancelButton.ACC_desc"));
        this.cancelButton.setMnemonic(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.cancelButton.ACC_mnemonic").charAt(0));
        this.jTxtLocalFilename.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxtLocalFilename);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxtLocalFilename);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxtLocalFilename);
            }
        });
        this.jTxServiceURL.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxServiceURL);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxServiceURL);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxServiceURL);
            }
        });
        this.enableControls();
        this.setDefaults();
        this.jTxtpackageName.setText(DEFAULT_PACKAGE_HOLDER);
        this.jTxtpackageName.setForeground(Color.GRAY);
    }

    public void displayDialog() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(AddWebServiceDlg.class, (String)"ADD_WEB_SERVICE"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, this.getHelpCtx(), (ActionListener)this);
        this.addButton.setEnabled(false);
        this.dlg.setOptions(new Object[]{this.addButton, this.cancelButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dialog.setVisible(true);
    }

    private void cancelButtonAction(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.dialog.dispose();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_add_websvcdb");
    }

    private void setDefaults() {
        this.jRbnUrl.setSelected(true);
        this.jRbnFilesystem.setSelected(false);
        this.enableControls();
    }

    private void enableControls() {
        if (this.allControlsDisabled) {
            return;
        }
        if (this.jRbnUrl.isSelected()) {
            this.jTxServiceURL.setEnabled(true);
            this.jTxServiceURL.requestFocusInWindow();
            this.jTxtLocalFilename.setEnabled(false);
            this.updateAddButtonState(this.jTxServiceURL);
            this.jLblChooseSource.setLabelFor(this.jTxServiceURL);
        } else if (this.jRbnFilesystem.isSelected()) {
            this.jTxtLocalFilename.setEnabled(true);
            this.jTxtLocalFilename.requestFocusInWindow();
            this.jTxServiceURL.setEnabled(false);
            this.updateAddButtonState(this.jTxtLocalFilename);
            this.jLblChooseSource.setLabelFor(this.jTxtLocalFilename);
        }
    }

    private void disableAllControls() {
        this.allControlsDisabled = true;
        this.jBtnBrowse.setEnabled(false);
        this.jBtnProxy.setEnabled(false);
        this.jRbnFilesystem.setEnabled(false);
        this.jRbnUrl.setEnabled(false);
        this.jTxServiceURL.setEnabled(false);
        this.jTxtLocalFilename.setEnabled(false);
        this.jTxtpackageName.setEnabled(false);
        this.pkgNameLbl.setEnabled(false);
    }

    private void enableAllControls() {
        this.allControlsDisabled = false;
        this.jBtnBrowse.setEnabled(true);
        this.jBtnProxy.setEnabled(true);
        this.jRbnFilesystem.setEnabled(true);
        this.jRbnUrl.setEnabled(true);
        this.jTxServiceURL.setEnabled(true);
        this.jTxtLocalFilename.setEnabled(true);
        this.jTxtpackageName.setEnabled(true);
        this.pkgNameLbl.setEnabled(true);
    }

    private String fixFileURL(String string) {
        String string2 = string;
        try {
            File file = new File(string2);
            return file.toURI().toURL().toString();
        }
        catch (Exception exception) {
            string2 = string2.substring(0, 1).equalsIgnoreCase("/") ? "file://" + string2 : "file:///" + string2;
            return string2;
        }
    }

    private void addButtonAction(ActionEvent actionEvent) {
        if (this.jTxServiceURL.getText() == null && this.jTxtLocalFilename.getText() == null) {
            return;
        }
        String string = this.jRbnUrl.isSelected() ? this.jTxServiceURL.getText().trim() : this.fixFileURL(this.jTxtLocalFilename.getText().trim());
        String string2 = this.jTxtpackageName.getText().trim();
        if (string2.equals(NbBundle.getMessage(AddWebServiceDlg.class, (String)"MSG_ClickToOverride"))) {
            string2 = "";
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        try {
            SaasServicesModel.getInstance().createSaasService(this.group, string, string2);
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private void checkServicesModel() {
        if (SaasServicesModel.getInstance().getState() != SaasServicesModel.State.READY) {
            this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INIT_WEB_SERVICES_MANAGER"));
            this.disableAllControls();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SaasServicesModel.getInstance().initRootGroup();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AddWebServiceDlg.this.enableAllControls();
                            AddWebServiceDlg.this.enableControls();
                            AddWebServiceDlg.this.setErrorMessage(AddWebServiceDlg.this.defaultMsg);
                        }
                    });
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase(this.addString)) {
            this.addButtonAction(actionEvent);
        } else if (string.equalsIgnoreCase(this.cancelString)) {
            this.cancelButtonAction(actionEvent);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLblChooseSource = new JLabel();
        this.jRbnFilesystem = new JRadioButton();
        this.jTxtLocalFilename = new JTextField();
        this.jBtnBrowse = new JButton();
        this.jRbnUrl = new JRadioButton();
        this.jTxServiceURL = new JTextField();
        this.jBtnProxy = new JButton();
        this.pkgNameLbl = new JLabel();
        this.jTxtpackageName = new JTextField();
        this.errorLabel = new JLabel();
        this.errorLabel.setVisible(false);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                AddWebServiceDlg.this.formAncestorAdded(ancestorEvent);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.jLblChooseSource.setLabelFor(this.jTxServiceURL);
        Mnemonics.setLocalizedText((JLabel)this.jLblChooseSource, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlSource"));
        this.buttonGroup1.add(this.jRbnFilesystem);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnFilesystem, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlSourceFilesystem"));
        this.jRbnFilesystem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddWebServiceDlg.this.jRbnFilesystemActionPerformed(actionEvent);
            }
        });
        this.jTxtLocalFilename.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnBrowse, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_Browse"));
        this.jBtnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddWebServiceDlg.this.jBtnBrowseActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jRbnUrl);
        this.jRbnUrl.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnUrl, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlUrl"));
        this.jRbnUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddWebServiceDlg.this.jRbnUrlActionPerformed(actionEvent);
            }
        });
        this.jTxServiceURL.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnProxy, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_ProxySettings"));
        this.jBtnProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddWebServiceDlg.this.jBtnProxyActionPerformed(actionEvent);
            }
        });
        this.pkgNameLbl.setLabelFor(this.jTxtpackageName);
        Mnemonics.setLocalizedText((JLabel)this.pkgNameLbl, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"PACKAGE_LABEL"));
        this.jTxtpackageName.setColumns(20);
        this.jTxtpackageName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AddWebServiceDlg.this.jTxtpackageNameMouseClicked(mouseEvent);
            }
        });
        this.jTxtpackageName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxtpackageName);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxtpackageName);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AddWebServiceDlg.this.updateAddButtonState(AddWebServiceDlg.this.jTxtpackageName);
            }
        });
        this.errorLabel.setVerticalTextPosition(1);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLblChooseSource).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.pkgNameLbl).add((Component)this.jRbnFilesystem).add((Component)this.jRbnUrl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTxServiceURL, -1, 548, Short.MAX_VALUE).add((Component)this.jTxtLocalFilename, -1, 548, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jBtnProxy, -2, 118, -2).add((Component)this.jBtnBrowse, -2, 118, -2)).add(14, 14, 14)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jTxtpackageName, -1, 551, Short.MAX_VALUE).add(136, 136, 136)))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.errorLabel, -1, 769, Short.MAX_VALUE).addContainerGap()))));
        groupLayout.linkSize(new Component[]{this.jBtnBrowse, this.jBtnProxy}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLblChooseSource, -2, 28, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jBtnBrowse).add((Component)this.jTxtLocalFilename, -2, -1, -2)).add((Component)this.jRbnFilesystem)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jRbnUrl).add((Component)this.jBtnProxy).add((Component)this.jTxServiceURL, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.pkgNameLbl).add((Component)this.jTxtpackageName, -2, -1, -2)).addPreferredGap(1).add((Component)this.errorLabel, -1, 59, Short.MAX_VALUE).addContainerGap()));
        this.jLblChooseSource.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlSource"));
        this.jRbnFilesystem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFilelRadioButton.ACC_desc"));
        this.jTxtLocalFilename.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFileComboBox.ACC_name"));
        this.jTxtLocalFilename.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFileComboBox.ACC_desc"));
        this.jBtnBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFileButton.ACC_desc"));
        this.jRbnUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.urlRadioButton.ACC_desc"));
        this.jTxServiceURL.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.urlComboBox.ACC_name"));
        this.jTxServiceURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.urlComboBox.ACC_desc"));
        this.jBtnProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.httpProxyButton.ACC_desc"));
        this.jTxtpackageName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.packageTextField.ACC_name"));
        this.jTxtpackageName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.packageTextField.ACC_desc"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.errorLabel.ACC_name"));
        this.getAccessibleContext().setAccessibleName("null");
        this.getAccessibleContext().setAccessibleDescription("null");
    }

    private void jRbnUrlActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jBtnProxyActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void jBtnBrowseActionPerformed(ActionEvent actionEvent) {
        this.jRbnFilesystem.setSelected(false);
        this.jRbnFilesystem.setSelected(true);
        this.enableControls();
        JFileChooser jFileChooser = new JFileChooser(previousDirectory);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(this.WSDL_FILE_FILTER);
        jFileChooser.setFileFilter(this.WSDL_FILE_FILTER);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.jTxtLocalFilename.setText(file.getAbsolutePath());
            previousDirectory = file.getPath();
        }
    }

    private void jRbnFilesystemActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jTxtpackageNameMouseClicked(MouseEvent mouseEvent) {
        this.jTxtpackageName.selectAll();
        this.jTxtpackageName.setForeground(Color.BLACK);
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableControls();
    }

    static {
        KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"};
        KEYWORD_SET = new HashSet<String>(KEYWORDS.length * 2);
        for (int i = 0; i < KEYWORDS.length; ++i) {
            KEYWORD_SET.add(KEYWORDS[i]);
        }
    }

    private static class ServiceFileFilter
    extends FileFilter {
        private ServiceFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = FileUtil.getExtension((String)file.getName());
            for (int i = 0; i < Saas.SUPPORTED_EXTENSIONS.length; ++i) {
                if (!Saas.SUPPORTED_EXTENSIONS[i].equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

